<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ7 ns1 sig" version="1.0" xmlns:УТ7="http://пф.рф/УТ/2023-04-03" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/СЗВ-К/2024-01-01">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	 <xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-04-03.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:СЗВ-К"/>
		<div class="afWrap sfrAfSZV-K2">
			<xsl:for-each select="$vForm/ns1:ЗЛ">
				<p class="afInterval"/>
				<div class="afRow afCenter">
					<div class="afRight-1-3">
						<div class="afC afSmallSize">
							Приложение № 6<br/>
	к приказу Фонда пенсионного и социального страхования Российской Федерации<br/>
						от 30 октября 2023 г. № 2153
						</div>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afCol-1-5 afLeftAlign">
						<span class="afUnderline">Форма СЗВ-К</span>
					</div>
					<div class="afCol-4-5">
						<div class="afTable10 afFrame afTableRight">&#160;</div>
						<div class="afTable20 afCenterBlock afTableRight">Код по ОКУД</div>
					</div>
				</div>
				<p class="afInterval"/>
				<h1 class="afHeader">Сведения о трудовом стаже застрахованного лица за период
                    до регистрации в системе обязательного пенсионного страхования</h1>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afC afValue afMarginLeft20">Тип сведений:</div>
					<div class="afCol-1-4">
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="$vForm/ns1:ТипСведений[text() = 'ИСХД' or text() = 'ИСХОДНАЯ']">V</xsl:if>
							</div>
						</div>
						<div class="afCol-1-2 afPadding">
							<div class="afC">Исходная</div>
						</div>
					</div>
					<div class="afCol-1-4">
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="$vForm/ns1:ТипСведений[text() = 'КОРР' or text() = 'КОРРЕКТИРУЮЩАЯ']">V</xsl:if>
							</div>
						</div>
						<div class="afCol-1-2 afPadding">
							<div class="afC">Корректирующая</div>
						</div>
					</div>
					<div class="afCol-1-4">
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="$vForm/ns1:ТипСведений[text() = 'ОТМН' or text() = 'ОТМЕНЯЮЩАЯ']">V</xsl:if>
							</div>
						</div>
						<div class="afCol-1-2 afPadding">
							<div class="afC">Отменяющая</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC afValue">Сведения о страхователе:</div>
				</div>
				<div class="afRow">
					<div class="afC">Регистрационный номер СФР</div>
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="$vForm/ns1:Страхователь/ns1:Составитель/УТ7:РегНомер"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">ИНН<sup class="afFootnote">1</sup>
					</div>
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="$vForm/ns1:Страхователь/ns1:Составитель/УТ7:ИНН"/>
						</p>
					</div>
					<div class="afC">КПП<sup class="afFootnote">2</sup>
					</div>
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="$vForm/ns1:Страхователь/ns1:Составитель/УТ7:КПП"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Наименование организации (краткое)</div>
					<p class="afValue afMarginLeft250 afUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:Страхователь/ns1:Составитель/УТ7:Наименование"/>
					</p>
				</div>
				<div class="afRow">
					<div class="afC afValue">Сведения о застрахованном лице:</div>
				</div>
				<div class="afRow">
					<div class="afC">Страховой номер индивидуального лицевого счета</div>
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="УТ7:СНИЛС"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Фамилия</div>
					<div class="afCol-1-2">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="УТ7:ФИО/УТ7:Фамилия"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Имя</div>
					<div class="afCol-1-2">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="УТ7:ФИО/УТ7:Имя"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Отчество (при наличии)</div>
					<div class="afCol-1-2">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="УТ7:ФИО/УТ7:Отчество"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Дата рождения
						<span class="afUnderline">
							<xsl:if test="УТ7:ДатаРождения">
								<xsl:call-template name="Date2Text">
									<xsl:with-param name="pDate" select="УТ7:ДатаРождения"/>
									<xsl:with-param name="style" select="1"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="УТ7:ДатаРожденияОсобая">
								<xsl:call-template name="УТ7:DateSpecialStr">
									<xsl:with-param name="pDate" select="УТ7:ДатаРожденияОсобая"/>
								</xsl:call-template>
							</xsl:if>
						</span> года
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Территориальные условия проживания на 31.12.2001</div>
					<div class="afMarginLeft200">
						<div class="afCol-1-5 afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="ns1:ТерриториальныеУсловияНа31.12.2001/ns1:ОснованиеТУ"/>&#160;
                                <xsl:value-of select="ns1:ТерриториальныеУсловияНа31.12.2001/ns1:Коэффициент"/>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">
						<div class="afCol-9-10">Факт постоянного проживания на территории Республики Крым или на территории города федерального значения Севастополя по состоянию на 18 марта 2014 года</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="ns1:ФактПроживанияКрым[text() = '1' or text() = 'true']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">
						<div class="afCol-9-10">Факт постоянного проживания на территории Донецкой Народной Республики, Луганской Народной Республики, Запорожской области, Херсонской области по состоянию на 30 сентября 2022 года</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="ns1:ФактПроживанияДНРЛНРЗОХО[text() = '1' or text() = 'true']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">
						<div class="afCol-9-10">Факт постоянного проживания на территории Донецкой Народной Республики или Луганской Народной Республики в период с                    11 мая 2014 года по 29 сентября 2022 года</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="ns1:ФактПроживанияДНРЛНР[text() = '1' or text() = 'true']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">
						<div class="afCol-9-10">Факт постоянного проживания на территории Запорожской области или Херсонской области в период с 24 февраля по 29 сентября 2022 года</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="ns1:ФактПроживанияЗОХО[text() = '1' or text() = 'true']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afValue afC">Периоды трудовой или иной общественно полезной
                        деятельности</div>
				</div>
				<xsl:for-each select="ns1:СтажДоРегистрации/ns1:ПериодДеятельности">
					<xsl:variable name="pos3" select="position()"/>
					<div class="afNoFloat afNoBreakInside">
						<div class="afRow">
							<div class="afCol-1-10">
								<p>
									<xsl:value-of select="$pos3"/>.</p>
							</div>
							<div class="afC">Наименование организации</div>
							<div class="afCol-2-3 afValue afUnderlinedAlignLeftPadding">
								<xsl:value-of select="ns1:НаименованиеОрганизации"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afCol-1-10">&#160;</div>
							<div class="afC">Вид деятельности (код)</div>
							<div class="afCol-2-3 afValue afUnderlinedAlignLeftPadding">
								<xsl:value-of select="ns1:ВидДеятельности"/>
							</div>
						</div>
						<table class="afTable afNoBreakInside afSmallSize">
							<tr>
								<td rowspan="2" class="afCenter">№ п/п</td>
								<td rowspan="2" class="afCenter">Начало периода (дд.мм.гггг)</td>
								<td rowspan="2" class="afCenter">Конец периода (дд.мм.гггг)</td>
								<td rowspan="2" class="afCenter">Территориальные условия (код)</td>
								<td rowspan="2" class="afCenter">Особые условия труда (код)</td>
								<td colspan="2" class="afCenter">Исчисляемый страховой (трудовой) стаж</td>
								<td colspan="2" class="afCenter">Выслуга лет</td>
							</tr>
							<tr>
								<td class="afCenter">основание (код)</td>
								<td class="afCenter">дополнительные сведения</td>
								<td class="afCenter">основание (код)</td>
								<td class="afCenter">дополнительные сведения</td>
							</tr>
							<xsl:for-each select="ns1:ВсеПериодыРаботы/ns1:ПериодРаботы">
								<xsl:variable name="pos1" select="position()"/>
								<tr>
									<td>
										<xsl:value-of select="$pos1"/>
									</td>
									<td class="afValue afCenter">
										<xsl:call-template name="Date2GOST">
											<xsl:with-param name="pDate" select="ns1:ОсновнаяСтрока/ns1:ДатаНачалаПериода"/>
										</xsl:call-template>
									
									</td>
									<td class="afValue afCenter">
										<xsl:call-template name="Date2GOST">
											<xsl:with-param name="pDate" select="ns1:ОсновнаяСтрока/ns1:ДатаКонцаПериода"/>
										</xsl:call-template>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ТерриториальныеУсловия/ns1:ОснованиеТУ">
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ТерриториальныеУсловия/ns1:ОснованиеТУ"/>,&#160; <xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ТерриториальныеУсловия/ns1:Коэффициент"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ОсобыеУсловияТруда/ns1:ОснованиеОУТ">
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ОсобыеУсловияТруда/ns1:ОснованиеОУТ"/>
										</xsl:if>
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ОсобыеУсловияТруда/ns1:ПозицияСписка"><br/>
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ОсобыеУсловияТруда/ns1:ПозицияСписка"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ИсчисляемыйСтаж/ns1:ОснованиеИС">
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ИсчисляемыйСтаж/ns1:ОснованиеИС"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:call-template name="ProductionStr">
											<xsl:with-param name="pProduction" select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ИсчисляемыйСтаж"/>
										</xsl:call-template>
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ДекретДети">,&#160;
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ДекретДети"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ВыслугаЛет/ns1:ОснованиеВЛ">
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ВыслугаЛет/ns1:ОснованиеВЛ"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ВыслугаЛет/ns1:КодИсчисления">
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ВыслугаЛет/ns1:КодИсчисления"/>&#160;
										</xsl:if>
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ВыслугаЛет">
											<xsl:call-template name="ProductionStr">
												<xsl:with-param name="pProduction" select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ВыслугаЛет"/>
											</xsl:call-template>&#160;
										</xsl:if>
										<xsl:if test="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ВыслугаЛет/ns1:ДоляСтавки">
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ВыслугаЛет/ns1:ДоляСтавки"/>
										</xsl:if>
									</td>
								</tr>								
								
								<tr>
									<td colspan="9">(профессия или должность) <span class="afValue">
											<xsl:value-of select="ns1:ОсновнаяСтрока/ns1:ЛьготныйСтаж/ns1:ПрофессияДолжность"/>
										</span>
									</td>
								</tr>
								<xsl:if test="ns1:ДополнительныеСтроки/ns1:ЛьготныйСтаж">
								<xsl:for-each select="ns1:ДополнительныеСтроки/ns1:ЛьготныйСтаж">
									<tr>
									<td>
										<xsl:value-of select="$pos1"/>.<xsl:value-of select="position()"/>
									</td>
									<td class="afValue afCenter"/>
									<td class="afValue afCenter"/>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ТерриториальныеУсловия/ns1:ОснованиеТУ">
											<xsl:value-of select="ns1:ТерриториальныеУсловия/ns1:ОснованиеТУ"/>,&#160; <xsl:value-of select="ns1:ТерриториальныеУсловия/ns1:Коэффициент"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ОсобыеУсловияТруда/ns1:ОснованиеОУТ">
											<xsl:value-of select="ns1:ОсобыеУсловияТруда/ns1:ОснованиеОУТ"/>
										</xsl:if>
										<xsl:if test="ns1:ОсобыеУсловияТруда/ns1:ПозицияСписка">
											<br/>
											<xsl:value-of select="ns1:ОсобыеУсловияТруда/ns1:ПозицияСписка"/>	
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ИсчисляемыйСтаж/ns1:ОснованиеИС">
											<xsl:value-of select="ns1:ИсчисляемыйСтаж/ns1:ОснованиеИС"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:call-template name="ProductionStr">
											<xsl:with-param name="pProduction" select="ns1:ИсчисляемыйСтаж"/>
										</xsl:call-template>
										
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ВыслугаЛет/ns1:ОснованиеВЛ">
											<xsl:value-of select="ns1:ВыслугаЛет/ns1:ОснованиеВЛ"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ВыслугаЛет/ns1:КодИсчисления"><xsl:value-of select="ns1:ВыслугаЛет/ns1:КодИсчисления"/>,&#160;</xsl:if>
									
										<xsl:call-template name="ProductionStr">
											<xsl:with-param name="pProduction" select="ns1:ВыслугаЛет"/>
										</xsl:call-template>
										
										<xsl:if test="ns1:ДекретДети">,&#160;
											<xsl:value-of select="ns1:ДекретДети"/>
										</xsl:if>
										<xsl:if test="ns1:ВыслугаЛет/ns1:ДоляСтавки">,&#160;<xsl:value-of select="ns1:ВыслугаЛет/ns1:ДоляСтавки"/></xsl:if>
									</td>
								</tr>								
								
								<tr>
									<td colspan="9">(профессия или должность) <span class="afValue">
											<xsl:value-of select="ns1:ПрофессияДолжность"/>
										</span>
									</td>
								</tr>
								</xsl:for-each>
								</xsl:if>
							</xsl:for-each>
						</table>
					</div>
				</xsl:for-each>
				<p class="afInterval"/>
				<div class="afNoBreakBefore afNoBreakInside">
					<p class="afInterval"/>
					<div class="afSign">
						<div class="afPadding afCenter">
							<p class="afCenter">Лист</p>
						</div>
						<div class="afPadding afCenter">
							<p class="afCenter">Сведения представлены на
                            &#160;&#160;&#160;&#160;&#160;&#160; листах</p>
						</div>
					</div>
				</div>
				<div class="afNoBreakBefore afNoBreakInside">
					<p class="afInterval"/>
					<div class="afRaw">
						<div class="afCol-4-10">
							<p class="afValue afCenter afUnderlinedBlock">
								<xsl:value-of select="$vForm/ns1:Руководитель/УТ7:Должность"/>
							</p>
							<p class="afCenter afSubscript">Наименование должности руководителя</p>
						</div>
						<div class="afCol-1-5">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afCenter afSubscript">Подпись</p>
						</div>
						<div class="afCol-4-10">
							<p class="afUnderlinedBlock afCenter afValue">
								<xsl:call-template name="УТ7:NameStr">
									<xsl:with-param name="pName" select="$vForm/ns1:Руководитель/УТ7:ФИО"/>
								</xsl:call-template> 
							</p>
							<p class="afCenter afSubscript">Расшифровка подписи</p>
						</div>
					</div>
				</div>
				
				<p class="afInterval"/>
				<p class="afInterval"/>
				<div class="afNoBreakBefore afNoBreakInside">
					<p class="afInterval"/>
					<div class="afSign">
						<div class="afPadding afCenter">
							<p class="afValue afUnderlinedBlock">
								<xsl:call-template name="Date2GOST">
									<xsl:with-param name="pDate" select="$vForm/ns1:Страхователь/ns1:ДатаСоставления"/>
								</xsl:call-template>
							</p>
							<p class="afCenter afSubscript">Дата</p>
						</div>
						<div class="afPadding afCenter">
							<p>М.П. (при наличии)</p>
						</div>
						<div class="afPadding afCenter"> </div>
					</div>
				</div>
				<p class="afInterval"/>
				<p class="afInterval"/>
				<div class="afNoBreakBefore afNoBreakInside">
					<p class="afInterval"/>
					<div class="afSign">
						<div class="afPadding afCenter">
							<p class="afValue">
								<p class="afCenter">Со сведениями о трудовом стаже ознакомлен</p>
							</p>
						</div>
						<div class="afPadding afCenter">
							<p class="afValue afUnderlinedBlock"/>
							<p class="afCenter afSubscript">Подпись застрахованного лица</p>
						</div>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<xsl:if test="/ns1:ЭДСФР/sig:SignInfo">
						<xsl:call-template name="PrintSignInfo">
							<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
						</xsl:call-template>
					</xsl:if>
				</div>
				<p class="afInterval"/>
				
				<p>_____________________________________________</p>
				<p class="afFootnote">
					<sup>1</sup> Идентификационный номер налогоплательщика.</p>
				<p class="afFootnote">
					<sup>2</sup> Код причины постановки на учет по месту нахождения организации.</p>
				
				<p class="afNextPageAfter"/>
			</xsl:for-each>
		</div>
	</xsl:template>
	 <xsl:template name="ProductionStr">
        <xsl:param name="pProduction"/>
        <xsl:choose>
			<xsl:when test="$pProduction//ns1:ВыработкаВчасах">
				<xsl:if test="$pProduction//ns1:ВыработкаВчасах/ns1:Часы">
					<xsl:value-of select="$pProduction//ns1:ВыработкаВчасах/ns1:Часы"/> ч.&#160;</xsl:if>
				<xsl:if test="$pProduction/ns1:ВыработкаВчасах/ns1:Минуты">
					<xsl:value-of select="$pProduction/ns1:ВыработкаВчасах/ns1:Минуты"/> мин.&#160;</xsl:if>
			</xsl:when>
			<xsl:when test="$pProduction/ns1:ВыработкаКалендарная">
				<xsl:if test="$pProduction/ns1:ВыработкаКалендарная/ns1:ВсеГоды">
					<xsl:value-of select="$pProduction/ns1:ВыработкаКалендарная/ns1:ВсеГоды"/>г. (лет)&#160;</xsl:if>
				<xsl:if test="$pProduction/ns1:ВыработкаКалендарная/ns1:ВсеМесяцы">
					<xsl:value-of select="$pProduction/ns1:ВыработкаКалендарная/ns1:ВсеМесяцы"/> мес.&#160;</xsl:if>
				<xsl:if test="$pProduction/ns1:ВыработкаКалендарная/ns1:ВсеДни">
					<xsl:value-of select="$pProduction/ns1:ВыработкаКалендарная/ns1:ВсеДни"/> д.&#160; </xsl:if>
			</xsl:when>
		</xsl:choose>
    </xsl:template>
</xsl:stylesheet>
