<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1 sig ВС2 ИС6" version="1.0"
    xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:ВС2="http://пф.рф/ВС/типы/2023-01-10"
    xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10"
    xmlns:ns1="http://пф.рф/СЗВ-КОРР/2023-01-10" xmlns:ИС6="http://пф.рф/ВС/ИС/2023-01-10"> 
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
    <xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
    <xsl:template name="inc">
        <div class="afWrap sfrAfSZV-KORR">

            <p class="afRight-3-10">
                УТВЕРЖДЕНА<br/>
                постановлением Правления СФР<br/>
                от 6 декабря 2018 г. № 507п
            </p>
            <p class="afInterval"/>
            <p class="afP">Форма ОДВ-1</p>
            <p class="afInterval"/>
            <p class="afValue afP">Сведения по страхователю, передаваемые в СФР для ведения индивидуального (персонифицированного) учета</p>
            <p class="afInterval"/>
            <p class="afValue afP">1. Реквизиты страхователя, передающего документы:</p>
            <p class="afInterval"/>
            <xsl:variable name="RegNum" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:РегНомер"/>
            <div class="afRow">
				<div class="afC">Регистрационный номер в СФР</div> 
				<div class="afCol-1-2">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 1, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 2, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 3, 1)" /></td>
							<td>&#160;-&#160;</td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 5, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 6, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 7, 1)" /></td>
							<td>&#160;-&#160;</td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 9, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 10, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 11, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 12, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 13, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 14, 1)" /></td>
						</tr>
					</table>
				</div>
				<div class="afCol-1-10 afCenterBlock">Стр.</div>
				<div class="afCol-1-10">
					<table class="afTable100 afTableCollapse">
						<tr>
							<td class=" afCheckSmall">&#160;&#160;</td>
							<td class=" afCheckSmall">&#160;&#160;</td>
							<td class=" afCheckSmall">&#160;&#160;</td>
						</tr>
					</table>
				</div>
			</div>
            <xsl:variable name="NumINN" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:ИНН"/>
            <xsl:variable name="NumKPP" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:КПП"/>
            <div class="afRow">
				<div class="afCol-1-5 afCenterBlock">ИНН</div> 
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 9, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 10, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 11, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 12, 1)" /></td>
                        </tr>
                    </table>
                </div>
                <div class="afCol-1-5 afCenterBlock">КПП</div>
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 9, 1)" /></td>
                        </tr>
                    </table>
                </div>
            </div>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afC">Наименование (краткое)</div>
                <div class="afCol-2-3 afValue afUnderlinedBlock">
                    <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/ИС6:Наименование"/>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-3-10">
                    <div class="afC afValue">2. Отчетный период (код):</div>
                    <div class="afCol-1-10">
                        <div class="afC afCheck">
                            <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОтчетныйПериод/ns1:Код"/>
                        </div>
                    </div>
                </div>
                 <div class="afCol-1-5">
                    <div class="afC afMarginLeft10">год</div>
                    <div class="afValue">
						<div class="afCol-1-4 afCheck">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОтчетныйПериод/ns1:Год"/>
						</div>
                    </div>
                </div>
                <div class="afCol-1-2">
                    <div class="afP">
                        <div class="afCol-1-4 afPadding">Исходная</div>
                        <div class="afCol-1-10 ">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '0']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                    <div class="afP">
                        <div class="afCol-1-4 afPadding">Корректирующая</div>
                        <div class="afCol-1-10">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '1']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                    <div class="afP">
                        <div class="afCol-1-4 afPadding">Отменяющая</div>
                        <div class="afCol-1-10">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '2']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <p class="afP afValue">3. Перечень входящих документов</p>
            <table class="afTable afSmallSize">
                <tr class="afCenter">
                    <td>Наименование входящего документа</td>
                    <td>Количество застрахованных лиц, на которых представлены сведения, чел.</td>
                </tr>
                <tr>
                    <td>Форма "Сведения о страховом стаже застрахованного лица (СЗВ-СТАЖ)"</td>
                    <td> </td>
                </tr>
                <tr>
                    <td>Форма "Сведения о заработке (вознаграждении) доходе, сумме выплат и иных вознаграждений, начисленных и уплаченных страховых взносах, о периодах трудовой и иной деятельности,
                        засчитываемых в страховой стаж застрахованного лица (СЗВ-ИСХ)"</td>
                    <td/>
                </tr>
                <tr>
                    <td>Форма "Данные о корректировке сведений, учтенных на индивидуальном лицевом счету застрахованного лица (СЗВ-КОРР)"</td>
                    <td class="afValue afCenter">
                        <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:КоличествоЗЛ"/>
                    </td>
                </tr>
                <tr>
                    <td>Иные входящие документы:</td>
                    <td/>
                </tr>
            </table>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
				<p class="afP afValue">4. Данные в целом по страхователю:</p>
				<table class="afTable afSmallSize">
					<tr class="afCenter">
						<td/>
						<td>Задолженность на начало отчетного периода, руб. коп.</td>
						<td>Начислено страховых взносов, руб. коп.</td>
						<td>Уплачено страховых взносов, руб. коп.</td>
						<td>Задолженность на конец отчетного периода, руб. коп.</td>
					</tr>
					<tr>
						<td>На страховую пенсию</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:ЗадолженностьНаНачало"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:Начислено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:Уплачено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:ЗадолженностьНаКонец"/>
						</td>
					</tr>
					<tr>
						<td>На накопительную пенсию</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:ЗадолженностьНаНачало"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:Начислено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:Уплачено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:ЗадолженностьНаКонец"/>
						</td>
					</tr>
					<tr>
						<td>По тарифу страховых взносов</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:ЗадолженностьНаНачало"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:Начислено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:Уплачено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:ЗадолженностьНаКонец"/>
						</td>
					</tr>
				</table>
			</div>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
                <p class="afP">Расшифровка графы "Уплачено" по периодам, за которые была произведена уплата страховых взносов</p>
                <table class="afTable afSmallSize">
                    <tr class="afCenter">
                        <td>Уплачено в календарном году</td>
                        <td>На страховую пенсию</td>
                        <td>На накопительную пенсию</td>
                        <td>По тарифу страховых взносов</td>
                    </tr>
                    <tr>
                        <td>Всего, в том числе:</td>
                        <td>
                            <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:Уплачено"/>
                        </td>
                        <td>
                            <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:Уплачено"/>
                        </td>
                        <td>
                            <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:Уплачено"/>
                        </td>
                    </tr>
                    <xsl:choose>
                        <xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Уплата/ИС6:Год">
                            <xsl:for-each select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Уплата">
                                <tr>
                                    <td>за <span class="afValue"><xsl:value-of select="./ИС6:Год"/></span> год</td>
                                    <td>
                                        <xsl:value-of select="./ИС6:Страховая"/>
                                    </td>
                                    <td>
                                        <xsl:value-of select="./ИС6:Накопительная"/>
                                    </td>
                                    <td>
                                        <xsl:value-of select="./ИС6:ТарифСВ"/>
                                    </td>
                                </tr>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <tr>
                                <td>за ________ год</td>
                                <td/>
                                <td/>
                                <td/>
                            </tr>
                            <tr>
                                <td>за ________ год</td>
                                <td/>
                                <td/>
                                <td/>
                            </tr>
                        </xsl:otherwise>
                    </xsl:choose>
                </table>
            </div>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
				<p class="afP afValue">5. Основание для отражения данных о периодах работы застрахованного лица в условиях, дающих право на досрочное назначение пенсии в соответствии со статьей 30
                Федерального закона от 28.12.2013 № 400–ФЗ «О страховых пенсиях»</p>
				<table class="afTable afSmallSize">
					<tr class="afCenter">
						<td>№ п/п</td>
						<td>Наименование структурного подразделения по штатному расписанию</td>
						<td>Наименование профессии, должности по штатному расписанию</td>
						<td>Кол-во раб. мест по штат. расписанию</td>
						<td>Кол-во раб-ов факт.</td>
						<td>Характер фактически выполняемых работ и дополнительные условия труда</td>
						<td>Наименование первичных документов, подтверждающих занятость в особых условиях труда</td>
						<td>Код особых условий труда/выслуги лет по Классификатору</td>
						<td>Код позиции Списка № 1 и 2, "малого" списка</td>
					</tr>
					<tr class="afHeightRow afCenter afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
						<td>5</td>
						<td>6</td>
						<td>7</td>
						<td>8</td>
						<td>9</td>
					</tr>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание">
							<xsl:for-each select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание">
								<tr>
									<td>
										<xsl:value-of select="position()"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:Подразделение"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:ПрофессияДолжность"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:КоличествоШтат"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:КоличествоФакт"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:Описание"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:Документы"/>
									</td>
									<td>
										<xsl:for-each select="./ns1:ОУТ">
											<p class="afP">
												<xsl:value-of select="./ns1:Код"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="./ns1:ОУТ">
											<p class="afP">
												<xsl:value-of select="./ns1:ПозицияСписка"/>
											</p>
										</xsl:for-each>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr class="afHeightBlankRow">
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</table>
			</div>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
				<div class="afRow">
					<div class="afC afValue">Общее количество рабочих мест в особых условиях труда по штату</div>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП">
							<div class="afCol-1-3 afValue afUnderlinedBlock">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ИС6:ВсегоШтат"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afCol-1-3 afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<div class="afRow">
					<div class="afC afValue">Количество фактически работающих в особых условиях труда</div>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП">
							<div class="afCol-1-3 afValue afUnderlinedBlock">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ИС6:ВсегоФакт"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afCol-1-3 afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afInterval"/>
				
				<div class="afRow">
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
						</p>
						<p class="afCenter afSubscriptNormal">Наименование должности руководителя</p>
					</div>
					<div class="afCol-2">&#160;</div>
					<div class="afCol-1-5">
						<p class="afBlankUnderlinedBlock"/>
						<p class="afCenter afSubscriptNormal">Подпись</p>
					</div>
					<div class="afCol-2">&#160;</div>
					<div class="afCol-4-10">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="УТ6:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afCenter afSubscriptNormal">Ф.И.О.</p>
					</div>
				</div>
<!--				
				<div class="afSign">
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
						</p>
						<p class="afSubscriptNormal afCenter">Наименование должности руководителя</p>
					</div>
					<div class="afPadding">
						<p class="afBlankUnderlinedBlock"/>
						<p class="afSubscriptNormal afCenter">Подпись</p>
					</div>
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="УТ6:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afSubscriptNormal afCenter">Расшифровка подписи</p>
					</div>
				</div>
-->				
				<p class="afInterval"/>
				<div class="afSign">
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ДатаЗаполнения"/>
								</xsl:with-param>
							</xsl:call-template>
						</p>
						<p class="afP afCenter">Дата (дд.мм.гггг)</p>
					</div>
					<div class="afPadding">М.П. (при наличии)</div>
					<div class="afPadding"></div>
				</div>
			</div>	
            
            <!-- ФОРМА СЗВ-КОРР -->
            
            
            <xsl:for-each select="/ns1:ЭДСФР/ns1:СЗВ-КОРР">
				<div id="break"/>
				<xsl:variable name="RegNumKORR" select="ns1:Страхователь/УТ6:РегНомер"/>
				<div class="afRow">
					<div class="afC">Регистрационный номер в СФР</div> 
					<div class="afCol-1-2">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 1, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 2, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 3, 1)" /></td>
								<td>&#160;-&#160;</td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 5, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 6, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 7, 1)" /></td>
								<td>&#160;-&#160;</td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 9, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 10, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 11, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 12, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 13, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 14, 1)" /></td>
							</tr>
						</table>
					</div>
					<div class="afCol-1-10 afCenterBlock">Стр.</div>
					<div class="afCol-1-10">
						<table class="afTable100 afTableCollapse">
							<tr>
								<td class=" afCheckSmall">&#160;&#160;</td>
								<td class=" afCheckSmall">&#160;&#160;</td>
								<td class=" afCheckSmall">&#160;&#160;</td>
							</tr>
						</table>
					</div>
				</div>

				<xsl:variable name="NumINNKORR" select="ns1:Страхователь/УТ6:ИНН"/>
				<xsl:variable name="NumKPPKORR" select="ns1:Страхователь/УТ6:КПП"/>
				<div class="afRow">
					<div class="afCol-1-5 afCenterBlock">ИНН</div> 
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 1, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 2, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 3, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 4, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 5, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 6, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 7, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 8, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 9, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 10, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 11, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 12, 1)" /></td>
							</tr>
						</table>
					</div>
					<div class="afCol-1-5 afCenterBlock">КПП</div>
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<xsl:choose>
								<xsl:when test="ns1:Страхователь/УТ6:КПП">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 3, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 4, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 5, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 6, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 7, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 8, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 9, 1)" /></td>
									</tr>
								</xsl:when>
								<xsl:otherwise>
									<tr>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
									</tr>
								</xsl:otherwise>
							</xsl:choose>
						</table>
					</div>
				</div>
				<p class="afInterval"/>
				
				<p class="afRight-3-10">
					УТВЕРЖДЕНА<br/>
					постановлением Правления СФР<br/>
					от 6 декабря 2018 г. № 507п
				</p>
				<p class="afInterval"/>
				<p class="afP">Форма СЗВ-КОРР</p>
				<p class="afInterval"/>
				<p class="afValue afP">Данные о корректировке сведений, учтенных на индивидуальном лицевом счете застрахованного лица</p>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afC afSmallSize">Отчетный период, в котором представляются сведения</div>
					<div class="afC afFrame">
						<span class="afPadding"><xsl:value-of select="ns1:ОтчетныйПериод/ns1:Код"/> - <xsl:value-of select="ns1:ОтчетныйПериод/ns1:Год"/></span>
					</div>
					<div class="afC afSmallSize">Тип сведений</div>
					<div class="afCol-1-4 afFrame">
						<span class="afPadding">
							<xsl:call-template name="TypeInformation">
								<xsl:with-param name="pTypeInformation" select="ns1:Тип"/>
							</xsl:call-template>
						</span>
					</div>
				</div>
				<div class="afRow">
					<div class="afC afSmallSize">Отчетный период, за который корректируются данные</div>
					<div class="afC afFrame">
						<span class="afPadding"><xsl:value-of select="ns1:КорректируемыйПериод/ns1:ОтчетныйПериод/ns1:Код"/> - <xsl:value-of
								select="ns1:КорректируемыйПериод/ns1:ОтчетныйПериод/ns1:Год"/></span>
					</div>
				</div>
				<p class="afInterval"/>
				<p class="afP afValue">1. Сведения о страхователе</p>
				<div class="afRow">
					<div class="afCol2-1-2 afFrame">
						<p class="afP afValue">В отчетном периоде</p>
						<div class="afRow">
							<div class="afC">Регистрационный номер в СФР</div>
							<div class="afC">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 3, 1)" /></td>
										<td>&#160;-&#160;</td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 5, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 6, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 7, 1)" /></td>
										<td>&#160;-&#160;</td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 9, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 10, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 11, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 12, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 13, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 14, 1)" /></td>
									</tr>
								</table>
							</div>
						</div>
						
						
						
						
						<div class="afRow">
							<div class="afC">ИНН</div>
							<div class="afC">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 3, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 4, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 5, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 6, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 7, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 8, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 9, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 10, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 11, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 12, 1)" /></td>
									</tr>
								</table>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">КПП</div>
							<div class="afC">
								<table class="afTableCollapse">
									<xsl:choose>
										<xsl:when test="ns1:Страхователь/УТ6:КПП">
											<tr>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 1, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 2, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 3, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 4, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 5, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 6, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 7, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 8, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 9, 1)" /></td>
											</tr>
										</xsl:when>
										<xsl:otherwise>
											<tr>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
											</tr>
										</xsl:otherwise>
									</xsl:choose>
								</table>
							</div>
						</div>
						
					</div>
					<xsl:variable name="RegNumKORRPeriod" select="ns1:КорректируемыйПериод/ns1:Страхователь/УТ6:РегНомер"/>
					<xsl:variable name="NumINNKORRPeriod" select="ns1:КорректируемыйПериод/ns1:Страхователь/УТ6:ИНН"/>
					<xsl:variable name="NumKPPKORRPeriod" select="ns1:КорректируемыйПериод/ns1:Страхователь/УТ6:КПП"/>
					<div class="afCol2-1-2 afFrame">
						<p class="afP afValue">В корректируемом периоде</p>
						<div class="afRow">
							<div class="afC">Регистрационный номер в СФР</div>
							<div class="afC">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 3, 1)" /></td>
										<td>&#160;-&#160;</td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 5, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 6, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 7, 1)" /></td>
										<td>&#160;-&#160;</td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 9, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 10, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 11, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 12, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 13, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORRPeriod, 14, 1)" /></td>
									</tr>
								</table>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">ИНН</div>
							<div class="afC">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 3, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 4, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 5, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 6, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 7, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 8, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 9, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 10, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 11, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORRPeriod, 12, 1)" /></td>
									</tr>
								</table>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">КПП</div>
							<div class="afC">
								<table class="afTableCollapse">
									<xsl:choose>
										<xsl:when test="ns1:КорректируемыйПериод/ns1:Страхователь/УТ6:КПП">
											<tr>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 1, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 2, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 3, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 4, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 5, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 6, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 7, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 8, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORRPeriod, 9, 1)" /></td>
											</tr>
										</xsl:when>
										<xsl:otherwise>
											<tr>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
											</tr>
										</xsl:otherwise>
									</xsl:choose>
								</table>
							</div>
						</div>	
					</div>
				</div>
				<div class="afRow50">
					<div class="afC">Наименование (краткое)</div>
					<div class="afCol-1-2 afValue afUnderlinedBlock">
						<xsl:value-of select="ns1:Страхователь/ИС6:Наименование"/>
					</div>
				</div>
				<p class="afP afValue">2. Сведения о застрахованном лице</p>
				<table class="afTable afTable100 afSmallSize">
					<tr class="afCenter">
						<td>Фамилия</td>
						<td>Имя</td>
						<td>Отчество</td>
						<td>СНИЛС</td>
					</tr>
					<tr class="afCenter afHeightRow afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
					</tr>
					<tr>
						<td>
							<xsl:value-of select="ns1:ЗЛ/ns1:ФИО/УТ6:Фамилия"/>
						</td>
						<td>
							<xsl:value-of select="ns1:ЗЛ/ns1:ФИО/УТ6:Имя"/>
						</td>
						<td>
							<xsl:value-of select="ns1:ЗЛ/ns1:ФИО/УТ6:Отчество"/>
						</td>
						<td>
							<xsl:value-of select="ns1:ЗЛ/ns1:СНИЛС"/>
						</td>
					</tr>
				</table>
				<p class="afInterval"/>
				<p class="afP afValue">3. Сведения о корректировке данных</p>
				<table class="afTable afTable100 afSmallSize">
					<tr class="afCenter">
						<td>Код категории застрахованного лица</td>
						<td>Тип договора</td>
						<td>Номер договора</td>
						<td>Дата заключения договора</td>
						<td>Код дополнительного тарифа</td>
					</tr>
					<tr class="afCenter afHeightRow afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
						<td>5</td>
					</tr>
					<xsl:choose>
						<xsl:when test="ns1:ДанныеЗЛ">
							<tr>
								<td>
									<xsl:value-of select="ns1:ДанныеЗЛ/ns1:Категория"/>
								</td>
								<td>
									<xsl:call-template name="TypeContract">
										<xsl:with-param name="pTypeContract" select="ns1:ДанныеЗЛ/ns1:Договор/ns1:Тип"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="ns1:ДанныеЗЛ/ns1:Договор/ns1:Реквизиты/УТ6:Номер"/>
								</td>
								<td>
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate">
											<xsl:value-of select="ns1:ДанныеЗЛ/ns1:Договор/ns1:Реквизиты/УТ6:Дата"/>
										</xsl:with-param>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="ns1:ДанныеЗЛ/ns1:КодДТ"/>
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<tr class="afHeightBlankRow">
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</table>
				<p class="afInterval"/>
				<p class="afP afValue">4. Сведения о корректировке данных о заработке (вознаграждении), доходе, сумме выплат и иных вознаграждений, начисленных и уплаченных страховых взносах</p>
				<table class="afTable afTableSmallSize">
					<tr class="afCenter">
						<td colspan="6">Сведения о корректировке данных о заработке (вознаграждении), доходе, сумме выплат и иных вознаграждений, начисленных в пользу застрахованного лица</td>
						<td colspan="5">Сведения о доначисленных страховых взносах</td>
						<td colspan="2" rowspan="2">Сведения об уплаченных страховых взносах</td>
					</tr>
					<tr class="afCenter">
						<td rowspan="3">Код месяца, сумма выплат за который корректируется</td>
						<td rowspan="3">Сумма выплат, всего, руб. коп.</td>
						<td colspan="4">в том числе</td>
						<td colspan="2">За периоды по 2001 г. включительно</td>
						<td colspan="2">За периоды с 2002 г.</td>
						<td rowspan="3">По тарифу страховых взносов на сумму выплат и иных вознаграждений, входящих в базу, не превышающую предельную</td>
					</tr>
					<tr class="afCenter">
						<td colspan="2">на которую начислены страховые взносы, входящая в базу для начисления страховых взносов, не превышающую предельную</td>
						<td colspan="2">Входящая в базу для начисления страховых взносов, превышающую предельную</td>
						<td rowspan="2">Уплачиваемые страхователем</td>
						<td rowspan="2">Уплачиваемые из заработка ЗЛ</td>
						<td rowspan="2">На страховую пенсию</td>
						<td rowspan="2">На накопительную пенсию</td>
						<td rowspan="2">На страховую пенсию</td>
						<td rowspan="2">На накопительную пенсию</td>
					</tr>
					<tr class="afCenter">
						<td>всего:</td>
						<td>В том числе по гражданско-правовым договорам</td>
						<td>всего:</td>
						<td>В том числе по гражданско-правовым договорам</td>
					</tr>
					<tr class="afCenter afHeightRow afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
						<td>5</td>
						<td>6</td>
						<td>7</td>
						<td>8</td>
						<td>9</td>
						<td>10</td>
						<td>11</td>
						<td>12</td>
						<td>13</td>
					</tr>
					<xsl:choose>
						<xsl:when test="ns1:Суммы">
							<xsl:for-each select="ns1:Суммы">
								<tr>
									<td>
										<xsl:value-of select="./ns1:Месяц"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:СуммаВыплат"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:НеПревышающие/ns1:Всего"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:НеПревышающие/ns1:ПоГПД"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:Превышающие/ns1:Всего"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:Превышающие/ns1:ПоГПД"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:СВстрахователя"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:СВизЗаработка"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:Страховая"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:Накопительная"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:СВпоТарифу"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Уплата/ns1:Страховая"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Уплата/ns1:Накопительная"/>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr class="afHeightBlankRow">
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</table>
				<p class="afInterval"/>
				<p class="afP afValue">5. Сведения о корректировке данных о сумме выплат и иных вознаграждений в пользу физического лица, занятого на соответствующих видах работ, с которых начислены
					страховые взносы по дополнительному тарифу</p>
				<table class="afTable afSmallSize">
					<tr class="afCenter">
						<td>Код месяца, сумма выплат за который корректируется</td>
						<td>Код специальной оценки условий труда</td>
						<td>Сумма выплат и иных вознаграждений, начисленных в пользу физического лица, занятого на видах работ, указанных в пункте 1 части 1 статьи 30 Федерального закона от 28 декабря
							2013 года № 400-ФЗ "О страховых пенсиях"</td>
						<td>Сумма выплат и иных вознаграждений, начисленных в пользу физического лица, занятого на видах работ, указанных в пунктах 2-18 части 1 статьи 30 Федерального закона от 28 декабря
							2013 года № 400-ФЗ "О страховых пенсиях"</td>
					</tr>
					<tr class="afCenter afHeightRow afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
					</tr>
					<xsl:choose>
						<xsl:when test="ns1:ВыплатыДТ">
							<xsl:for-each select="ns1:ВыплатыДТ">
								<tr>
									<td>
										<xsl:value-of select="./ns1:Месяц"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:КодСОУТ"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:ДопТарифП1"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:ДопТарифП2_18"/>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr class="afHeightBlankRow">
								<td/>
								<td/>
								<td/>
								<td/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</table>
	
				<p class="afInterval"/>
				<p class="afP afValue">6. Сведения о корректировке периодов работы застрахованного лица</p>
				<table class="afTable afSmallSize">
					<tr class="afCenter">
						<td rowspan="2">Начало периода с (дд.мм.гггг.)</td>
						<td rowspan="2">Конец периода по (дд.мм.гггг)</td>
						<td rowspan="2">Территориальные условия (код)</td>
						<td rowspan="2">Особые условия труда (код)</td>
						<td colspan="2">Исчисление страхового стажа</td>
						<td colspan="2">Условия досрочного назначения страховой пенсии</td>
						<td rowspan="2" class="afOverflowWordBreak">Сведения об увольнении застрахованного лица/сведения о периодах, засчитываемых в страховой стаж безработным</td>
					</tr>
					<tr class="afCenter">
						<td>Основание (код)</td>
						<td>Дополнительные сведения</td>
						<td>Основание (код)</td>
						<td>Дополнительные сведения</td>
					</tr>
					<tr class="afCenter afHeightRow afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
						<td>5</td>
						<td>6</td>
						<td>7</td>
						<td>8</td>
						<td>9</td>
					</tr>
					<xsl:choose>
						<xsl:when test="ns1:СтажевыйПериод">
							<xsl:for-each select="ns1:СтажевыйПериод">
								<xsl:variable name="vLines" select="count(ИС6:ЛьготныйСтаж)"/>
								<xsl:variable name="vPos" select="position()"/>
								<xsl:choose>
									<xsl:when test="$vLines > 1">
										<xsl:for-each select="ИС6:ЛьготныйСтаж">
											<tr>
												<xsl:if test="position() = 1">	
													<td rowspan="{$vLines}">
														<xsl:call-template name="DateShortStr">
															<xsl:with-param name="pDate"
																select="../ИС6:Период/УТ6:С"/>
														</xsl:call-template>
													</td>
													<td rowspan="{$vLines}">
														<xsl:call-template name="DateShortStr">
															<xsl:with-param name="pDate"
																select="../ИС6:Период/УТ6:По"/>
														</xsl:call-template>
													</td>
												</xsl:if>
												<td>
													<p class="afP">
														<xsl:value-of
															select="concat(./ИС6:ТУ/ИС6:Основание, ' ', ./ИС6:ТУ/ИС6:Коэффициент)"
														/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:value-of select="./ИС6:ОУТ"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:value-of select="./ИС6:ИС/ИС6:Основание"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:call-template name="УТ6:ProductionStr">
															<xsl:with-param name="pProduction"
																select="./ИС6:ИС"/>
														</xsl:call-template>
														<xsl:value-of select="./ИС6:ДопСведенияИС"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:value-of select="./ИС6:ВЛ/ИС6:Основание"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:call-template name="УТ6:ProductionStr">
															<xsl:with-param name="pProduction" select="ИС6:ЛьготныйСтаж/ИС6:ВЛ"/>
														</xsl:call-template>
														<xsl:value-of select="./ИС6:ВЛ/ИС6:ДоляСтавки"/>
													</p>
												</td>
												<xsl:if test="position() = 1">	
													<td rowspan="{$vLines}">
													<p class="afP">
														<xsl:value-of select="../ns1:КатегорияЗЛ"/>
													</p>
													<p class="afP">
														<xsl:call-template name="DateShortStr">
															<xsl:with-param name="pDate"
																select="//ns1:ДатаУвольнения"/>
														</xsl:call-template>
													</p>
												</td>
												</xsl:if>
											</tr>
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise>
										<tr>
											<td>
												<xsl:call-template name="DateShortStr">
													<xsl:with-param name="pDate" select="ИС6:Период/УТ6:С"/>
												</xsl:call-template>
											</td>
											<td>
												<xsl:call-template name="DateShortStr">
													<xsl:with-param name="pDate" select="ИС6:Период/УТ6:По"/>
												</xsl:call-template>
											</td>
											<td>
												<p class="afP">
													<xsl:value-of select="concat(ИС6:ЛьготныйСтаж/ИС6:ТУ/ИС6:Основание, ' ', ИС6:ЛьготныйСтаж/ИС6:ТУ/ИС6:Коэффициент)"/>
												</p>
											</td>
											<td>
												<p class="afP">
													<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ОУТ"/>
												</p>
											</td>
											<td>
												<p class="afP">
													<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ИС/ИС6:Основание"/>
												</p>
											</td>
											<td>
												<p class="afP">
													<xsl:call-template name="УТ6:ProductionStr">
														<xsl:with-param name="pProduction"
															select="ИС6:ЛьготныйСтаж/ИС6:ИС"/>
													</xsl:call-template>
													<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ДопСведенияИС"/>
												</p>
											</td>
											<td>
												<p class="afP">
													<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ВЛ/ИС6:Основание"/>
												</p>
											</td>
											<td>
												<p class="afP">
													<xsl:call-template name="УТ6:ProductionStr">
														<xsl:with-param name="pProduction"
															select="ИС6:ЛьготныйСтаж/ИС6:ВЛ"/>
													</xsl:call-template>
													<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ВЛ/ИС6:ДоляСтавки"/>
												</p>
											</td>
											<td>
												<p class="afP">
													<xsl:value-of select="./ns1:КатегорияЗЛ"/>
												</p>
												<p class="afP">
													<xsl:call-template name="DateShortStr">
														<xsl:with-param name="pDate"
															select="../ns1:ДатаУвольнения"/>
													</xsl:call-template>
												</p>
											</td>
										</tr>
									</xsl:otherwise>
								</xsl:choose>
								
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr class="afHeightBlankRow">
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</table>

            </xsl:for-each>
            
            
            

            
            
            <div class="afNoBreakBefore afNoBreakInside">
                <p class="afInterval"/>
                <div class="afRow">
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
						</p>
						<p class="afCenter afSubscriptNormal">Наименование должности руководителя</p>
					</div>
					<div class="afCol-2">&#160;</div>
					<div class="afCol-1-5">
						<p class="afBlankUnderlinedBlock"/>
						<p class="afCenter afSubscriptNormal">Подпись</p>
					</div>
					<div class="afCol-2">&#160;</div>
					<div class="afCol-4-10">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="УТ6:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afCenter afSubscriptNormal">Ф.И.О.</p>
					</div>
				</div>
<!--                
                <div class="afSign">
                    <div class="afPadding afCenter">
                        <p class="afValue afUnderlinedBlock">
                            <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
                        </p>
                        <p>Наименование должности руководителя</p>
                    </div>
                    <div class="afPadding afCenter">
                        <p class="afBlankUnderlinedBlock"/>
                        <p>Подпись</p>
                    </div>
                    <div class="afPadding afCenter">
                        <p class="afUnderlinedBlock afValue">
                            <xsl:call-template name="УТ6:NameStr">
                                <xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
                            </xsl:call-template>
                        </p>
                        <p>Ф.И.О.</p>
                    </div>
                </div>
-->
                <p class="afInterval"/>
                <div class="afSign">
                    <div class="afPadding">
                        <p class="afUnderlinedBlock afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ДатаЗаполнения"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </p>
                        <p class="afP afCenter">Дата (дд.мм.гггг)</p>
                    </div>
                    <div class="afPadding">М.П. (при наличии)</div>
                    <div class="afPadding"></div>
                </div>
                 <p class="afInterval"/>
            <div class="afNoBreakInside">
                <xsl:if test="/ns1:ЭДСФР/sig:SignInfo">
                    <xsl:call-template name="PrintSignInfo">
                        <xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
                    </xsl:call-template>
                </xsl:if>
            </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template name="TypeContract">
        <xsl:param name="pTypeContract"/>
        <xsl:choose>
            <xsl:when test="$pTypeContract = '1'">трудовой</xsl:when>
            <xsl:when test="$pTypeContract = '2'">гражданско-правовой</xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="TypeInformation">
        <xsl:param name="pTypeInformation"/>
        <xsl:choose>
            <xsl:when test="$pTypeInformation = '0'">корректирующая</xsl:when>
            <xsl:when test="$pTypeInformation = '1'">отменяющая</xsl:when>
            <xsl:when test="$pTypeInformation = '2'">особая</xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- Выработка -->
    <xsl:template name="УТ6:ProductionStr">
        <xsl:param name="pProduction"/>
        <xsl:if test="$pProduction">
            <xsl:if test="$pProduction//ВС2:ВыработкаВчасах/ВС2:Часы">
                <xsl:value-of select="$pProduction//ВС2:ВыработкаВчасах/ВС2:Часы"/> ч.&#160;</xsl:if>
            <xsl:if test="$pProduction/ВС2:ВыработкаВчасах/ВС2:Минуты">
                <xsl:value-of select="$pProduction/ВС2:ВыработкаВчасах/ВС2:Минуты"/> мин.&#160;</xsl:if>
            <xsl:if test="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеМесяцы">
                <xsl:value-of select="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеМесяцы"/> мес.&#160;</xsl:if>
            <xsl:if test="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеДни">
                <xsl:value-of select="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеДни"/> д.&#160; </xsl:if>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
