<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ДС6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ДС6="http://пф.рф/ВС/ДоСВ/типы/2023-01-10" xmlns:ns1="http://пф.рф/ЗОДСВ/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<div class="afWrap">
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRight-1-3">
				<div class="afC">В</div>
				<div class="afMarginLeft20 afUnderlinedBlock afValue">
					<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ТОСФР/УТ6:Наименование"/>
				</div>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<p class="afInterval"/>
			<h1 class="afHeader afCenter">Заявление</h1>
			<h1 class="afHeader afCenter">о вступлении в правоотношения</h1>
			<h1 class="afHeader afCenter">по обязательному пенсионному страхованию</h1>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afParagraph afJustify">Добровольно вступаю в правоотношения по обязательному пенсионному страхованию в соответствии c</div>
			</div>
			<div class="afRow">
				<div class="afC">подпунктом&#160;</div>
				<p class="afValue afUnderlinedBlock afMarginLeft80">
					<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Подпункт"/>&#160;</p>
				<p class="afSubscript afCenter afMarginLeft80">(указывается один из подпунктов 1, 2, 3, 5, 6 или 7 пункта 1 статьи 29 Федерального закона
от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации»)</p>
				<p class="afJustify">пункта 1 статьи 29 Федерального закона от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации» и прошу зарегистрировать меня в качестве страхователя.
			</p>
			</div>
			<div class="afRow">
				<div class="afCenter">I. Сведения о заявителе</div>
			</div>
			<div class="afRow">
				<div class="afC">Фамилия, имя, отчество (при наличии)</div>
				<div class="afMarginLeft250 afUnderlinedBlock afValue">
					<xsl:call-template name="УТ6:NameStr">
						<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:ФИО"/>
					</xsl:call-template>
				</div>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock"/>
			</div>
			<div class="afRow">
				<div class="afCol-1-2">
					<div class="afC">Дата рождения</div>
					<div class="afCol-2-3">
						<div class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:ДатаРождения"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год)</p>
					</div>
				</div>
				<div class="afCol-1-2">
					<div class="afC">Место рождения</div>
					<div class="afMarginLeft100">
						<div class="afUnderlinedBlock afValue">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Город">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Город"/>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Район">
										<xsl:value-of select="concat(', ', /ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Район)"/>
									</xsl:if>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион or /ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна">,</xsl:if>
								</xsl:when>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Район">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Район"/>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион or /ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна">,</xsl:if>
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
				</div>
			</div>
			<div class="afRow">
				<div class="afUnderlinedLeftBlock afValue">
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион"/>
							<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна">
								<xsl:value-of select="concat(', ', /ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна)"/>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна"/>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-2">Страховой номер индивидуального лицевого счета застрахованного лица</div>
				<div class="afCol-1-2">
					<div class="afValue afMarginLeft100">
						<xsl:choose>
							<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:СНИЛС">
								<xsl:variable name="snils" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:СНИЛС"/>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 1, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 2, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 3, 1)"/>&#160;
                                </div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 5, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 6, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 7, 1)"/>&#160;
                                </div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 9, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 10, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 11, 1)"/>&#160;
                                </div>
								<div class="afFloatLeft">&#160;&#160;&#160;</div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 13, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 14, 1)"/>&#160;
                                </div>
							</xsl:when>
							<xsl:otherwise>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-2">
					<div class="afCol-4-10">ИНН (при наличии)</div>
					<div class="afCol-6-10">
						<div class="afValue">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:ИНН">
									<xsl:variable name="inn" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:ИНН"/>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 1, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 2, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 3, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 4, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 5, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 6, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 7, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 8, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 9, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 10, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 11, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 12, 1)"/>&#160;
                                    </div>
								</xsl:when>
								<xsl:otherwise>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
				</div>
				<div class="afCol-1-2">
					<div class="afCol-6-10">
						<p class="afCenter">Код ИФНС</p>
						<p class="afSubscript afCenter">(по месту жительства физического лица, добровольно вступающего в правоотношения)</p>
					</div>
					<div class="afCol-4-10">
						<div class="afValue">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ДС6:КодНО">
									<xsl:variable name="ifns" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ДС6:КодНО"/>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($ifns, 1, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($ifns, 2, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($ifns, 3, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($ifns, 4, 1)"/>&#160;
                                    </div>
								</xsl:when>
								<xsl:otherwise>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Гражданство</div>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft90">
					<xsl:call-template name="NationalityStr">
						<xsl:with-param name="pNationalityType" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:Гражданства/УТ6:Гражданство/УТ6:Тип"/>
					</xsl:call-template>
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:Гражданства/УТ6:Гражданство/УТ6:Тип = '2'"> (
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:Гражданства/УТ6:Гражданство/УТ6:Государство/УТ6:Наименование"/>
							) 
						</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Адрес места жительства в Российской Федерации</div>
				<div class="afMarginLeft350 afUnderlinedBlock"/>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock afValue">
					<xsl:choose>
						<xsl:when test="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:АдресРегистрации/УТ6:Иностранный">
							<xsl:call-template name="УТ6:AddressForeignStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:АдресРегистрации"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:АдресРегистрации/УТ6:Неструктурированный">
							<xsl:value-of select="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:АдресРегистрации/УТ6:Неструктурированный"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="УТ6:AddressStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:АдресРегистрации"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afSubscript afCenter">(почтовый адрес)</p>
			</div>
			<div class="afRow">
				<div class="afC">Страна   постоянного   проживания   до прибытия в Российскую Федерацию (для иностранных граждан)</div>
				<div class="afCol-1-9 afUnderlinedBlock"/>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock afValue">
					<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:ПроживаниеЗаПределамиРФ/ns1:Страна"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Дата предполагаемого выезда за пределы территории Российской Федерации (для иностранных граждан)</div>
				<div class="afCol-1-10 afUnderlinedBlock"/>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock afValue">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:ПроживаниеЗаПределамиРФ/ns1:ДатаВыезда"/>
					</xsl:call-template>
				</div>
				<p class="afSubscript afCenter">(число, месяц, год)</p>
			</div>
			<div class="afRow">
				<div class="afJustify">Почтовый адрес для направления уведомления о регистрации страхователя, добровольно вступившего в правоотношения по обязательному пенсионному страхованию:</div>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock afValue">
					<xsl:choose>
						<xsl:when test="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:АдресУведомления/УТ6:Иностранный">
							<xsl:call-template name="УТ6:AddressForeignStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:АдресУведомления"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:АдресУведомления/УТ6:Неструктурированный">
							<xsl:value-of select="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:АдресУведомления/УТ6:Неструктурированный"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="УТ6:AddressStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:АдресУведомления"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Номер контактного телефона:</div>
				<div class="afMarginLeft200 afUnderlinedBlock afValue">
					<xsl:call-template name="Phone2Text">
						<xsl:with-param name="pNumber" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Заявитель/УТ6:Телефон"/>
					</xsl:call-template>
				</div>
			</div>
			<p class="afPageBreakAfter"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCenter">II. Основания для постановки на учет</div>
				<div class="afCenter">в качестве страхователя</div>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '1'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Гражданин Российской Федерации, работающий за пределами территории Российской Федерации, в целях уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за себя</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '2'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Физическое лицо, в целях уплаты страховых взносов за другое физическое лицо, за которое не осуществляется уплата страховых взносов страхователем в соответствии с Федеральным законом от 15 декабря 2001 г. № 167-ФЗ ФЗ «Об обязательном пенсионном страховании в Российской Федерации»  и частью второй Налогового кодекса Российской Федерации</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '3'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Индивидуальный предприниматель, осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '4'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Нотариус, занимающийся частной практикой и осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '5'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Адвокат, осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '6'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Арбитражный управляющий, осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '7'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Иные лица, занимающиеся частной практикой и осуществляющие уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '8'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Физическое лицо в целях уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за себя, постоянно или временно проживающее на территории Российской Федерации, на которое не распространяется обязательное пенсионное страхование в соответствии с Федеральным законом от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации», за исключением лиц, указанных в подпунктах 6 и 7 пункта 1 статьи 29 данного закона</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '9'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Физическое лицо в целях уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за себя, применяющее специальный налоговый режим «Налог на профессиональный доход», постоянно или временно проживающее на территории Российской Федерации</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '10'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Физическое лицо из числа индивидуальных предпринимателей, адвокатов, арбитражных управляющих, нотариусов, занимающихся частной практикой, и иных лиц, занимающихся частной практикой и не являющихся индивидуальными предпринимателями, являющихся получателями пенсии за выслугу лет или пенсии по  инвалидности в соответствии с Законом Российской Федерации от 12 февраля 1993 г. № 4468-1 «О пенсионном обеспечении лиц, проходивших военную службу, службу в органах внутренних дел, Государственной противопожарной службе, органах по контролю за оборотом наркотических средств и психотропных веществ, учреждениях и органах уголовно-исполнительной системы, войсках национальной гвардии Российской Федерации, органах принудительного исполнения Российской Федерации, и их семей» в целях уплаты  страховых  взносов в Фонд пенсионного и социального страхования Российской Федерации за себя</div>
			</div>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '11'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">Глава крестьянского (фермерского) хозяйства, осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
			</div>
			<p class="afPageBreakAfter"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCenter">III. Сведения о правоустанавливающем документе</div>
			</div>
			<div class="afRow">Вид документа:</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:КодДокумента = '663'">V</xsl:when>
						<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:КодДокумента = '664'">V</xsl:when>
					</xsl:choose>
				</div>
				<div class="afMarginLeft50 afJustify">документ, подтверждающий факт работы за пределами территории Российской Федерации, либо документ, подтверждающий факт приглашения на работу за пределы территории Российской Федерации:</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:КодДокумента = '663'">
							<div class="afUnderlinedBlock afValue">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:НаименованиеДокумента"/>
							</div>
						</xsl:when>
						<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:КодДокумента = '664'">
							<div class="afUnderlinedBlock afValue">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:НаименованиеДокумента"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<p>;</p>
				<p class="afSubscript afCenter">(наименование документа)</p>
			</div>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:КодДокумента = '665'">V</xsl:if>
				</div>
				<div class="afFloatLeft">&#160;&#160;&#160;&#160;&#160;иной документ</div>
				<div class="afMarginLeft150 afUnderlinedBlock afValue">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:КодДокумента = '665'">
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:НаименованиеДокумента"/>
					</xsl:if>
				</div>
				<p class="afSubscript afCenter">(наименование документа)</p>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afUnderlinedBlock afValue">
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/УТ6:КемВыдан"/>
					</div>
					<p class="afSubscript afCenter">(наименование  органа, выдавшего правоустанавливающий документ)</p>
				</div>
				<p>,</p>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">регистрационный номер документа</div>
					<div class="afMarginLeft250 afUnderlinedBlock afValue">
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:Реквизиты/УТ6:Номер"/>
					</div>
				</div>
				<p>,</p>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">дата регистрации документа</div>
					<div class="afMarginLeft200">
						<div class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:Реквизиты/УТ6:Дата"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год)</p>
					</div>
				</div>
				<p>,</p>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">дата окончания срока действия документа</div>
					<div class="afMarginLeft300">
						<div class="afUnderlinedBlock afValue">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/УТ6:СрокДействия">
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/УТ6:СрокДействия"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="not(/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/УТ6:СрокДействия) and /ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Категория = '1' and (/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:КодДокумента = '663' or /ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:КодДокумента = '664')">бессрочно</xsl:when>
							</xsl:choose>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год или «бессрочно»)</p>
					</div>
				</div>
				<p>,</p>
			</div>
			<div class="afRow">
				<div class="afC afJustify">дата  заключения  трудового договора (контракта) на работу за пределами территории</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">Российской Федерации</div>
					<div class="afMarginLeft150">
						<div class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:СрокДоговора/УТ6:С"/>
							</xsl:call-template>
						</div>
					</div>
					<p class="afSubscript afCenter">(число, месяц, год)</p>
				</div>
				<p>,</p>
			</div>
			<div class="afRow">
				<div class="afC afJustify">дата окончания срока действия трудового договора (контракта) на работу  за  пределами территории</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">Российской Федерации</div>
					<div class="afMarginLeft150">
						<div class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:СрокДоговора/УТ6:По"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год)</p>
					</div>
				</div>
				<p>;</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:НалогНаПрофессиональныйДоход/ns1:Сведения">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">сведения (информация), подтверждающие факт постановки на учет в налоговом органе в качестве налогоплательщика, применяющего специальный налоговый режим «Налог на профессиональный доход» (полученные посредством мобильного приложения «Мой налог», используемого в соответствии с Федеральным законом от 27 ноября 2018 г. № 422-ФЗ «О проведении эксперимента по установлению специального налогового режима «Налог на профессиональный доход»):</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afUnderlinedBlock afValue">
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:НалогНаПрофессиональныйДоход/ns1:Сведения"/>
					</div>
				</div>
				<p>,</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-2">дата постановки на учет в налоговом органе в качестве налогоплательщика, применяющего специальный налоговый режим «Налог на профессиональный доход»</div>
				<div class="afCol2-1-2">
					<div class="afValue afMarginLeft50 afUnderlinedBlock">
						<br/>
						<br/>
						<br/>
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:НалогНаПрофессиональныйДоход/ns1:Дата"/>
						</xsl:call-template>
					</div>
					<p class="afSubscript afCenter">(число, месяц, год)</p>
				</div>
				<p>
					<br/>
					<br/>;</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоАдвокат/ns1:Сведения">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">сведения (информация), подтверждающие факт постановки на учет в налоговом органе физического лица в качестве индивидуального предпринимателя, адвоката, арбитражного управляющего, нотариуса, занимающегося частной практикой, и иного лица, занимающегося частной практикой и не являющегося индивидуальным предпринимателем  (полученные территориальным органом Фонда пенсионного и социального страхования Российской Федерации из налоговых органов):</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afUnderlinedBlock afValue">
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоАдвокат/ns1:Сведения"/>
					</div>
				</div>
				<p>,</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-2">дата постановки на учет в налоговом органе в качестве индивидуального предпринимателя, адвоката, арбитражного управляющего, нотариуса, занимающегося частной практикой, и иного лица, занимающегося частной практикой и не являющегося индивидуальным предпринимателем</div>
				<div class="afCol2-1-2">
					<div class="afValue afMarginLeft50 afUnderlinedBlock">
						<br/>
						<br/>
						<br/>
						<br/>
						<br/>
						<br/>
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоАдвокат/ns1:Дата"/>
						</xsl:call-template>
					</div>
					<p class="afSubscript afCenter">(число, месяц, год)</p>
				</div>
				<p>
					<br/>
					<br/>
					<br/>
					<br/>
					<br/>;</p>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<div class="afRow">
					<div class="afC afCheck">
						<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ДокументОПенсии/ns1:Сведения">V</xsl:if>
					</div>
					<div class="afMarginLeft50 afJustify">сведения (информация), подтверждающие факт получения пенсии за выслугу лет или пенсии по  инвалидности в соответствии с Законом Российской Федерации от 12 февраля 1993 г. № 4468-1 «О пенсионном обеспечении лиц, проходивших военную службу, службу в органах внутренних дел, Государственной противопожарной службе, органах по контролю за оборотом наркотических средств и психотропных веществ, учреждениях и органах уголовно-исполнительной системы, войсках национальной гвардии Российской Федерации, органах принудительного исполнения Российской Федерации, и их семей» (представленные физическим лицом или полученные территориальным органом Фонда пенсионного и социального страхования Российской Федерации  в органах, осуществляющих выплату пенсии за выслугу лет или пенсии по инвалидности):</div>
				</div>
				<div class="afRow">
					<div class="afCol-98">
						<div class="afUnderlinedBlock afValue">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ДокументОПенсии/ns1:Сведения"/>
						</div>
					</div>
					<p>,</p>
				</div>
				<div class="afRow">
					<div class="afCol-1-2">дата установления пенсии</div>
					<div class="afCol-1-2">
						<div class="afValue afMarginLeft50 afUnderlinedBlock">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ДокументОПенсии/ns1:Дата"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год)</p>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			
			<div class="afRow">
				<div class="afCenter">IV. Сведения о физическом лице, за которое осуществляется</div>
				<div class="afCenter">уплата страховых взносов</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afUnderlinedBlock afValue">
					<xsl:call-template name="УТ6:NameStr">
						<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:ФИО"/>
					</xsl:call-template>
				</div>
				<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии))</p>
			</div>
			<div class="afRow">
				<div class="afC">Адрес места жительства</div>
				<p class="afMarginLeft170 afUnderlinedBlock afValue">
					<xsl:choose>
						<xsl:when test="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:АдресРегистрации/УТ6:Иностранный">
							<xsl:call-template name="УТ6:AddressForeignStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:АдресРегистрации"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:АдресРегистрации/УТ6:Неструктурированный">
							<xsl:value-of select="ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:АдресРегистрации/УТ6:Неструктурированный"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="УТ6:AddressStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:АдресРегистрации"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</p>
				<p class="afMarginLeft170 afSubscript afCenter">(почтовый адрес)</p>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock"/>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock"/>
			</div>
			<div class="afRow">
				<div class="afC">Документ, удостоверяющий личность</div>
				<div class="afMarginLeft250">
					<div class="afUnderlinedBlock afValue">
						<xsl:if test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:УдостоверяющийДокумент">
							<xsl:call-template name="УТ6:CodDocumentStr">
								<xsl:with-param name="pCodDocument" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:УдостоверяющийДокумент"/>
							</xsl:call-template>
						</xsl:if>
					</div>
					<p class="afSubscript afCenter">(вид документа)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-3">
					<div class="afC">серия</div>
					<div class="afCol-2-3">
						<div class="afUnderlinedBlock afValue">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:УдостоверяющийДокумент/УТ6:Серия"/>
						</div>
					</div>
				</div>
				<div class="afCol-1-3">
					<div class="afC">номер</div>
					<div class="afCol-2-3">
						<div class="afUnderlinedBlock afValue">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:УдостоверяющийДокумент/УТ6:Номер"/>
						</div>
					</div>
				</div>
				<div class="afCol-1-3">
					<div class="afC">дата выдачи</div>
					<div class="afMarginLeft100">
						<div class="afUnderlinedBlock afValue">
							<xsl:call-template name="Date2Text">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:УдостоверяющийДокумент/УТ6:ДатаВыдачи"/>
								<xsl:with-param name="pNo2000YearWhenEmpty">1</xsl:with-param>
							</xsl:call-template>г.
						</div>
					</div>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">кем и когда выдан</div>
				<div class="afMarginLeft150">
					<div class="afUnderlinedBlock afValue">
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:УдостоверяющийДокумент/УТ6:КемВыдан"/>
					</div>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-2">Страховой номер индивидуального лицевого счета застрахованного лица</div>
				<div class="afCol-1-2">
					<div class="afValue afMarginLeft100">
						<xsl:choose>
							<xsl:when test="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:СНИЛС">
								<xsl:variable name="snils" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ6:СНИЛС"/>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 1, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 2, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 3, 1)"/>&#160;
                                </div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 5, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 6, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 7, 1)"/>&#160;
                                </div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 9, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 10, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 11, 1)"/>&#160;
                                </div>
								<div class="afFloatLeft">&#160;&#160;&#160;</div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 13, 1)"/>&#160;
                                </div>
								<div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 14, 1)"/>&#160;
                                </div>
							</xsl:when>
							<xsl:otherwise>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCenter">V. Сведения об уплате страховых взносов</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afParagraph afJustify">Размер страховых взносов и порядок их уплаты определяются в соответствии со статьей 29 Федерального закона от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации».</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div>Достоверность и полноту сведений, указанных в настоящем заявлении, подтверждаю.</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-2">
					<div class="afC">Подпись заявителя</div>
					<div class="afMarginLeft150 afUnderlinedBlock afValue"/>
				</div>
				<div class="afCol-1-2">
					<div class="afC">Дата</div>
					<div class="afMarginLeft50">
						<div class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗОДСВ/ns1:Дата"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год)</p>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			
			<div class="afRow">
				<div class="afCenter">VI. Сведения о регистрации страхователя</div>
			</div>
			
			
			<table class="afTable afTable100">
				<tbody>
					<tr class="afVerticalTop">
						<td class="afTable25 afTDCol-A">Регистрационный номер в Фонде пенсионного и социального страхования Российской Федерации</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
						</td>
						<td class="afTable25 afCenter afTDCol-A">
							Дата постановки на учет
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(число, месяц, год)</p>
						</td>
					</tr>
					<tr class="afVerticalTop">
						<td class="afTable25 afTDCol-A">Уведомление выдал</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(должность)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(подпись)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
						</td>
					</tr>
					<tr class="afVerticalTop">
						<td class="afTable25 afTDCol-A">Уведомление получил </td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(подпись)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(дата)</p>
						</td>
					</tr>
					<tr class="afVerticalTop">
						<td class="afTable25 afTDCol-A">Уведомление направлено с использованием услуг почтовой связи</td>
						<td class="afTable25 afTDCol-A">
							<div class="afCol-1-2">
								<p class="afBlankUnderlinedBlock"/>
								<p class="afSubscript afCenter">(должность)</p>
							</div>
							<div class="afCol-1-2">
								<p class="afBlankUnderlinedBlock"/>
								<p class="afSubscript afCenter">(подпись)</p>
							</div>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(дата)</p>
						</td>
					</tr>
				</tbody>
			</table>
			
			
			
			
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
					</xsl:call-template>
				</xsl:if>
			</div>
			
		</div>
	</xsl:template>
</xsl:stylesheet>
