<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ДС ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:ДС="http://пф.рф/ВС/ДоСВ/типы/2023-01-10" xmlns:ns1="http://пф.рф/ЗПДСВ/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<div class="afWrap">
			
			<p class="afInterval"/>
			<div class="afRight-1-3">
				<div class="afC">В</div>
				<div class="afMarginLeft20 afUnderlinedBlock afValue">
					<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:ТОСФР/УТ6:Наименование"/>
				</div>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<div class="afRow">
				<div class="afCol-27">
					<div class="afC">
						Код категории страхователя
					</div>
				</div>
				<div class="afCol-2-3">
					<div class="afValue">
						<xsl:variable name="pCode" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Категория"/>
									<div class="afFrame">
            &#160;<xsl:value-of select="substring($pCode, 1, 1)"/>&#160;
            </div>
			<div class="afFrame">
                 &#160;<xsl:value-of select="substring($pCode, 2, 1)"/>&#160;
            </div>
			<div class="afFrame">
                &#160;<xsl:value-of select="substring($pCode, 3, 1)"/>&#160;
            </div>
			<div class="afFrame">
                &#160;<xsl:value-of select="substring($pCode, 4, 1)"/>&#160;
            </div>
					</div>
				</div>
			</div>
			
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader afCenter">Заявление</h1>
			<h1 class="afHeader afCenter">о прекращении правоотношений</h1>
			<h1 class="afHeader afCenter">по обязательному пенсионному страхованию</h1>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afParagraph afJustify">Прекращаю правоотношения по обязательному пенсионному страхованию в соответствии с пунктом 3 статьи 29 Федерального закона от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации» и прошу снять меня с регистрационного учета в качестве страхователя.</div>
			</div>
			<div class="afRow">
				<div class="afCenter">I. Сведения о заявителе</div>
			</div>
			<div class="afRow">
				<div class="afC">Фамилия, имя, отчество (при наличии)</div>
				<div class="afCol-6-10 afUnderlinedBlock afValue">
					<xsl:call-template name="УТ6:NameStr">
						<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:ФИО"/>
					</xsl:call-template>
				</div>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock"/>
			</div>
			<div class="afRow">
				<div class="afCol-1-2">
					<div class="afC">Дата рождения</div>
					<div class="afCol-2-3">
						<div class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:ДатаРождения"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год)</p>
					</div>
				</div>
				<div class="afCol-1-2">
					<div class="afC">Место рождения</div>
					<div class="afCol-2-3">
						<div class="afUnderlinedBlock afValue">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Город">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Город"/>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Район">
										<xsl:value-of select="concat(', ', /ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Район)"/>
									</xsl:if>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион">
										<xsl:value-of select="concat(', ', /ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион)"/>
									</xsl:if>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна">
										<xsl:value-of select="concat(', ', /ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна)"/>
									</xsl:if>
								</xsl:when>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Район">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Район"/>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион">
										<xsl:value-of select="concat(', ', /ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион)"/>
									</xsl:if>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна">
										<xsl:value-of select="concat(', ', /ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна)"/>
									</xsl:if>
								</xsl:when>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Регион"/>
									<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна">
										<xsl:value-of select="concat(', ', /ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна)"/>
									</xsl:if>
								</xsl:when>
								<xsl:when test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:МестоРождения/УТ6:Страна"/>
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-2">Страховой номер индивидуального лицевого счета застрахованного лица</div>
				<div class="afCol-1-2">
					<div class="afValue afMarginLeft100">
						<xsl:variable name="snils" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:СНИЛС"/>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 1, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 2, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 3, 1)"/>&#160;
                        </div>
						<div class="afFloatLeft">&#160;-&#160;</div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 5, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 6, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 7, 1)"/>&#160;
                        </div>
						<div class="afFloatLeft">&#160;-&#160;</div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 9, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 10, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 11, 1)"/>&#160;
                        </div>
						<div class="afFloatLeft">&#160;&#160;</div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 13, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 14, 1)"/>&#160;
                        </div>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-55">
					<div class="afCol-1-3">
						<div class="afC">ИНН (при наличии)</div>
					</div>
					<div class="afCol-2-3">
						<div class="afValue">
							<xsl:variable name="inn" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:ИНН"/>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 1, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 2, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 3, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 4, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 5, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 6, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 7, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 8, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 9, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 10, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 11, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 12, 1)"/>&#160;
                            </div>
						</div>
					</div>
				</div>
				<div class="afCol-9-20">
					<div class="afCol-7-10">
						<div class="afCenter">Код ИФНС</div>
						<p class="afSubscript afCenter">(по месту жительства физического<br/>лица, добровольно вступающего в правоотношения)</p>
					</div>
					<div class="afCol-1-4">
						<div class="afValue">
							<xsl:variable name="ifns" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/ДС:КодНО"/>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($ifns, 1, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($ifns, 2, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($ifns, 3, 1)"/>&#160;
                            </div>
							<div class="afFrame">
                                &#160;<xsl:value-of select="substring($ifns, 4, 1)"/>&#160;
                            </div>
						</div>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afJustify">Почтовый адрес для направления уведомления о снятии с регистрационного учета страхователя, прекратившего правоотношения по обязательному пенсионному страхованию</div>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock afValue">
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/ns1:АдресУведомления/УТ6:Неструктурированный">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/ns1:АдресУведомления/УТ6:Неструктурированный"/>
						</xsl:when>
						<xsl:when test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/ns1:АдресУведомления/УТ6:Иностранный">
							<xsl:call-template name="УТ6:AddressForeignStr">
										<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/ns1:АдресУведомления"/>
									</xsl:call-template>
						</xsl:when>
						<xsl:when test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/ns1:АдресУведомления">
							<xsl:call-template name="УТ6:AddressStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/ns1:АдресУведомления"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Номер контактного телефона:</div>
				<div class="afMarginLeft200 afUnderlinedBlock afValue">
					<xsl:call-template name="Phone2Text">
						<xsl:with-param name="pNumber" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:Заявитель/УТ6:Телефон"/>
					</xsl:call-template>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCenter">II. Основания для снятия с учета в качестве страхователя</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '1'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации гражданином Российской Федерации, работающим за пределами территории Российской Федерации</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '2'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за другое физическое лицо, за которое не осуществляется уплата в соответствии с Федеральным законом от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации» и частью второй Налогового кодекса Российской Федерации</div>
			</div>
			
			
			<p class="afInterval"/>
			<div class="afRow ">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '9'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением индивидуальным предпринимателем уплаты страховых взносов в фиксированном размере в части, превышающей этот размер</div>
			</div>
		
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '10'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением нотариусом уплаты страховых взносов в фиксированном размере в части, превышающей этот размер</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '11'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением адвокатом уплаты страховых взносов в фиксированном размере в части, превышающей этот размер</div>
			</div>
			<p class="afPageBreakAfter"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '12'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением арбитражным управляющим уплаты страховых взносов в фиксированном размере в части, превышающей этот размер</div>
			</div>
			
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '13'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением главой крестьянского (фермерского) хозяйства уплаты страховых взносов в фиксированном размере в части, превышающей этот размер</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '14'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением иных лиц, занимающихся частной практикой, уплаты страховых взносов в фиксированном размере в части, превышающей этот размер</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '4'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением уплаты страховых взносов за себя физическим лицом, постоянно или временно проживающим на территории Российской Федерации, на которого не распространяется обязательное пенсионное страхование в соответствии с Федеральным законом от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации», за исключением лиц, указанных в подпунктах 6 и 7 пункта 1 статьи 29 данного закона</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '5'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением физическим лицом уплаты страховых взносов за себя, применяющим специальный налоговый режим «Налог на профессиональный доход», постоянно или временно проживающим на территории Российской Федерации</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '6'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с изменением регистрации по месту жительства</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afCheck">
					<xsl:if test="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:КодСнятия = '7'">V</xsl:if>
				</div>
				<div class="afMarginLeft50 afJustify">В связи с прекращением уплаты страховых взносов за себя физическим  лицом из числа индивидуальных предпринимателей, адвокатов, арбитражных управляющих, нотариусов, занимающихся частной практикой, и иных лиц, занимающихся частной практикой и не являющихся индивидуальными предпринимателями, являющихся получателями пенсии за выслугу лет или пенсии по  инвалидности в соответствии с Законом Российской Федерации от 12 февраля 1993 г. № 4468-1 «О пенсионном обеспечении лиц, проходивших военную службу, службу в органах внутренних дел, Государственной противопожарной службе, органах по контролю за оборотом наркотических средств и психотропных веществ, учреждениях и органах уголовно-исполнительной системы, войсках национальной гвардии Российской Федерации, органах принудительного исполнения Российской Федерации, и их семей»</div>
			</div>
			<p class="afInterval"/>
				<div class="afRow">
				<div class="afCenter">III. Сведения  о физическом лице, за которое осуществлялась <br/>уплата страховых взносов</div>
			</div>
			<div class="afRow">			
				<div class="afMarginLeft afUnderlinedBlock afValue">
						<xsl:call-template name="УТ6:NameStr">
						<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:УплатаСтрахВзносов/УТ6:ФИО"/>
					</xsl:call-template>
				</div>
				<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
			</div>
				<div class="afRow">
				<div class="afCol-1-2">Страховой номер индивидуального лицевого счета застрахованного лица</div>
				<div class="afCol-1-2">
					<div class="afValue afMarginLeft100">
						<xsl:variable name="snils" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:УплатаСтрахВзносов/УТ6:СНИЛС"/>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 1, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 2, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 3, 1)"/>&#160;
                        </div>
						<div class="afFloatLeft">&#160;-&#160;</div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 5, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 6, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 7, 1)"/>&#160;
                        </div>
						<div class="afFloatLeft">&#160;-&#160;</div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 9, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 10, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 11, 1)"/>&#160;
                        </div>
						<div class="afFloatLeft">&#160;&#160;</div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 13, 1)"/>&#160;
                        </div>
						<div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 14, 1)"/>&#160;
                        </div>
					</div>
				</div>
			</div>
				<p class="afInterval"/>
			<div class="afRow">
				<div>Достоверность и полноту сведений, указанных в настоящем заявлении, подтверждаю.</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-2">
					<div class="afC">Подпись заявителя</div>
					<div class="afMarginLeft150 afUnderlinedBlock afValue"/>
				</div>
				<div class="afCol-1-2">
					<div class="afC">Дата</div>
					<div class="afMarginLeft50">
						<div class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЗПДСВ/ns1:ДатаЗаполнения"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год)</p>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCenter">IV. Отметка о снятии с учета страхователя</div>
			</div>
			
			
			<table class="afTable afTable100">
				<tbody>
					<tr class="afVerticalTop">
						<td class="afTable25 afTDCol-A">Регистрационный номер в Фонде пенсионного и социального страхования Российской Федерации</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
						</td>
						<td class="afTable25 afCenter afTDCol-A">
							Дата снятия с учета
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(число, месяц, год)</p>
						</td>
					</tr>
					<tr class="afVerticalTop">
						<td class="afTable25 afTDCol-A">Уведомление выдал</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(должность)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(подпись)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
						</td>
					</tr>
					<tr class="afVerticalTop">
						<td class="afTable25 afTDCol-A">Уведомление получил </td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(подпись)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(дата)</p>
						</td>
					</tr>
					<tr class="afVerticalTop">
						<td class="afTable25 afTDCol-A">Уведомление направлено с использованием услуг почтовой связи</td>
						<td class="afTable25 afTDCol-A">
							<div class="afCol-1-2">
								<p class="afBlankUnderlinedBlock"/>
								<p class="afSubscript afCenter">(должность)</p>
							</div>
							<div class="afCol-1-2">
								<p class="afBlankUnderlinedBlock"/>
								<p class="afSubscript afCenter">(подпись)</p>
							</div>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
						</td>
						<td class="afTable25 afTDCol-A">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afSubscript afCenter">(дата)</p>
						</td>
					</tr>
				</tbody>
			</table>
			
			

		</div>
	</xsl:template>
</xsl:stylesheet>
