<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/УРДСВ/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<div class="afWrap">
			<div class="afRight-1-3 afSubscriptNormal afCenter">
				Приложение № 3 <br/>
к Правилам подачи заявления
о добровольном вступлении в правоотношения по обязательному пенсионному страхованию и заявления о прекращении правоотношений по обязательному пенсионному страхованию, утвержденным приказом Министерства труда и социальной защиты Российской Федерации от 31 мая 2017 г. № 462н	</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader afCenter">Уведомление</h1>
			<h1 class="afHeader afCenter">о регистрации в территориальном органе Фонда пенсионного и социального</h1>
			<h1 class="afHeader afCenter">страхования Российской Федерации страхователя, добровольно вступившего</h1>
			<h1 class="afHeader afCenter">в правоотношения по обязательному пенсионному страхованию</h1>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Уважаемый(ая)</div>
				<p class="afMarginLeft100 afUnderlinedBlock afValue">
					<xsl:call-template name="УТ6:NameStr">
						<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:УРДСВ/ns1:Заявитель/УТ6:ФИО"/>
					</xsl:call-template>
				</p>
				<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
			</div>
			<div class="afRow">
				<div class="afC">Проживающий(ая) по адресу</div>
				<p class="afMarginLeft180 afUnderlinedBlock afValue">
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:УРДСВ/ns1:Заявитель/УТ6:АдресРегистрации and not (/ns1:ЭДСФР/ns1:УРДСВ/ns1:Заявитель/УТ6:АдресРегистрации/УТ6:Иностранный)">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:УРДСВ/ns1:Заявитель/УТ6:АдресРегистрации/УТ6:Неструктурированный">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:УРДСВ/ns1:Заявитель/УТ6:АдресРегистрации/УТ6:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ6:AddressStr">
										<xsl:with-param name="pAddress" select="/ns1:ЭДСФР/ns1:УРДСВ/ns1:Заявитель/УТ6:АдресРегистрации"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</p>
				<p class="afSubscript afCenter">(почтовый адрес)</p>
			</div>
			<div class="afRow">
				<div class="afC afJustify">сообщаем, что на основании Вашего заявления в соответствии с законодательством Российской Федерации об обязательном пенсионном страховании Вы зарегистрированы</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-3">
					<div class="afUnderlinedBlock afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:УРДСВ/ns1:ДатаРегистрации"/>
						</xsl:call-template>
					</div>
					<p class="afSubscript afCenter">(число, месяц, год)</p>
				</div>
				<div class="afC">в качестве страхователя в</div>
				<div class="afCol-1-3">
					<div class="afUnderlinedBlock afValue"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afRow afUnderlinedBlock afValue">
					<xsl:value-of select="/ns1:ЭДСФР/ns1:УРДСВ/ns1:ТОСФР/УТ6:Наименование"/>
					
				</div>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации, его код)</p>
			</div>
			<div class="afC">по месту Вашего жительства.</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-7-10">
					<div class="afCol-1-2">ИНН (идентификационный номер налогоплательщика (при наличии)</div>
					<div class="afCol-1-2">
						<div class="afValue">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:УРДСВ/ns1:Заявитель/УТ6:ИНН">
									<xsl:variable name="inn" select="/ns1:ЭДСФР/ns1:УРДСВ/ns1:Заявитель/УТ6:ИНН"/>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 1, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 2, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 3, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 4, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 5, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 6, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 7, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 8, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 9, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 10, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 11, 1)"/>&#160;
                                    </div>
									<div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 12, 1)"/>&#160;
                                    </div>
								</xsl:when>
								<xsl:otherwise>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">С присвоением регистрационного номера</div>
				<div class="afCol-2-5 afUnderlinedBlock afValue">
					<xsl:value-of select="/ns1:ЭДСФР/ns1:УРДСВ/УТ6:РегНомер"/>
				</div>
			</div>
			<div class="afNoBreakInside afNoBreakBefore">
				<p class="afInterval"/>
				<div class="afCol-1-4 afValue">
					<p class="afValue">
						<xsl:choose>
							<xsl:when test="/ns1:ЭДСФР/ns1:УРДСВ/ns1:УполномоченноеЛицо">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:УРДСВ/ns1:УполномоченноеЛицо/УТ6:Должность"/>
							</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</p>
				</div>
				<div class="afCol-1-4">
					<p class="afBlankUnderlinedBlock"/>
					<p class="afCenter afSubscript">(подпись)</p>
				</div>
				<div class="afCol-1-2">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:call-template name="УТ6:NameStr">
							<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:УРДСВ/ns1:УполномоченноеЛицо/УТ6:ФИО"/>
						</xsl:call-template>
					</p>
					<p class="afCenter afSubscript">(фамилия, имя, отчество (при наличии))</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afMarginLeft50">М.П.</div>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
					</xsl:call-template>
				</xsl:if>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
