<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/РСДОСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:РСДОСС"/>
		<div class="afWrap pfrAfRSDOSS">
			<div class="afRight-1-2 afCenter">
				Приложение № 2 <br/>
к Порядку регистрации и снятия
с учета в территориальных органах
Фонда пенсионного и социального
страхования Российской Федерации
лиц, добровольно вступивших
в правоотношения по обязательному
социальному страхованию на случай
временной нетрудоспособности
и в связи с материнством,
утвержденному приказом
Министерства труда и социальной
защиты Российской Федерации
от 7 декабря 2022 г. N 768н
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader">Решение<br/>о прекращении со страхователем правоотношений<br/>по обязательному социальному страхованию на случай<br/>временной нетрудоспособности и в связи с материнством</h1>
			<p class="afInterval"/>
			<p class="afCenter afValue">№<span class="afValue afUnderline">
					<xsl:value-of select="$vForm/ns1:Решение/УТ6:Номер"/>
				</span> от <span class="afValue afUnderline">
					<xsl:call-template name="Date2Text">
						<xsl:with-param name="pDate" select="$vForm/ns1:Решение/УТ6:Дата"/>
					</xsl:call-template>
				</span>г.
			</p>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<div class="afRow afJustify">сообщает, что правоотношения по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством с физическим лицом</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-3-10">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:ФИО/УТ6:Фамилия"/>
					</p>
					<p class="afCenter afSubscript">(Фамилия)</p>
				</div>
				<div class="afCol-5">&#160;</div>
				<div class="afCol-3-10">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:ФИО/УТ6:Имя"/>
					</p>
					<p class="afCenter afSubscript">(Имя)</p>
				</div>
				<div class="afCol-5">&#160;</div>
				<div class="afCol-3-10">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/УТ6:ФИО/УТ6:Отчество">
							<p class="afValue afBlankUnderlinedBlock">
								<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:ФИО/УТ6:Отчество"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afBlankUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">регистрационный номер страхователя  </div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/ns1:Страхователь/УТ6:РегНомер">
						<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:РегНомер"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">код территориального органа Фонда  </div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
					&#160;
				</p>
			</div>
			<p class="afС">с <span class="afValue afUnderline">
					<xsl:call-template name="Date2Text">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:ДатаПрекращения"/>
						</xsl:with-param>
					</xsl:call-template>
				</span> г. считаются прекратившимися
			</p>		
			<div class="afRow">
				<div class="afC">Указанное лицо снято с регистрационного учета в</div>
				<p class="afValue afUnderlinedBlock afMarginLeft320">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter afMarginLeft320">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<div class="afRow">
				<div class="afC">Дата снятия с регистрационного учета:</div>
				<p class="afCol-1-4 afValue afUnderlinedBlock afMarginLeft250">
					<xsl:call-template name="Date2Text">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:ДатаСнятия"/>
						</xsl:with-param>
					</xsl:call-template>г.
				</p>
			</div>
			<table class="afTable afTable100">
				<tbody>
					<tr class="afVerticalBottom">
						<td class="afTable40 afTDCol-A ">
							<div class="afC">Уполномоченное должностное лицо<br/>территориального органа Фонда<br/>пенсионного и социального страхования<br/>Российской Федерации<br/></div>
						</td>
						<td class="afTable20 afTDCol-A ">
							<div class="afRow">
								<div class="afValue afUnderlinedBlock"></div>
								<p class="afSubscript afCenter">(подпись)</p>
							</div>
						</td>
						<td class="afTable40 afCenter afTDCol-A ">
							<div class="afNoBreakInside">
								<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
									<xsl:call-template name="PrintSignInfo">
										<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
									</xsl:call-template>
								</xsl:if>
							</div>
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">
									<xsl:call-template name="УТ6:NameStr">
										<xsl:with-param name="pName" select="$vForm/ns1:УполномоченноеЛицо/УТ6:ФИО"/>
										<xsl:with-param name="pInitialFirst" select="1"/>
									</xsl:call-template>
									
								</div>
								<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии))</p>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
			<div class="afC afMarginLeft50">М.П.</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
