<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/УРДОСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УРДОСС"/>
		<div class="afWrap pfrAfURDOSS">
			<div class="afRight-1-2 afCenterBlock afSubscriptNormal">
				Приложение № 1 <br/>
к Порядку регистрации и снятия
с учета в территориальных органах
Фонда пенсионного и социального
страхования Российской Федерации
лиц, добровольно вступивших
в правоотношения по обязательному
социальному страхованию на случай
временной нетрудоспособности
и в связи с материнством,
утвержденному приказом
Министерства труда и социальной
защиты Российской Федерации
от 7 декабря 2022 г. N 768н
			</div>
		<div class="afInterval"/>
			<div class="afRight-1-3 afRight afSubscriptNormal">форма</div>
		<div class="afInterval"/>
			<h1 class="afHeader">Уведомление<br/>о регистрации лица, добровольно вступившего в правоотношенияпо обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством</h1>
			<div class="afRow afJustify afParagraph">Настоящее уведомление выдано в соответствии с Федеральным законом от 29 декабря 2006 г. № 255-ФЗ «Об обязательном социальном страховании на случай временной нетрудоспособности и в связи с материнством» физическому лицу</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:call-template name="УТ6:NameStr">
						<xsl:with-param name="pName" select="$vForm/ns1:Заявитель/УТ6:ФИО"/>
					</xsl:call-template>
				</p>
				<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
			</div>
			<div class="afRow">
				<div class="afC">состоящему на учете в</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:Заявитель/ns1:ОрганФНС">
						<xsl:value-of select="$vForm/ns1:Заявитель/ns1:ОрганФНС"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft210 afSubscript">(Наименование налогового органа, поставившего физическое лицо на учет)</p>
			</div>
			<div class="afRow">
				<div class="afC">ИНН</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft50">
					<xsl:if test="$vForm/ns1:Заявитель/УТ6:ИНН">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:ИНН"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow afJustify">и подтверждает вступление в правоотношения по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством и регистрацию в</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			
			<div class="afRow">
				<div class="afC afParagraph">Доводим также до Вашего сведения, что лицо, добровольно вступившее в правоотношения по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством, уплачивает страховые взносы в Фонд пенсионного и социального страхования Российской Федерации в соответствии со статьей 4.5 Федерального закона от 29 декабря 2006 г. № 255-ФЗ “Об обязательном социальном  страховании  на случай временной нетрудоспособности и в связи с материнством” в</div>
			</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:ТОСФР/ns1:Адрес/УТ6:Неструктурированный">
							<xsl:value-of select="$vForm/ns1:ТОСФР/ns1:Адрес/УТ6:Неструктурированный"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:ТОСФР/ns1:Адрес">
							<xsl:call-template name="УТ6:AddressStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:ТОСФР/ns1:Адрес"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</p>
				<p class="afSubscript afCenter">(адрес территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			
			<div class="afRow">
				<div class="afC afParagraph">В случае неуплаты либо неполной уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за соответствующий календарный год в срок до 31 декабря текущего года правоотношения по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством считаются прекратившимися с 1 января следующего года.</div>
			</div>
			<div class="afRow">
				<div class="afC">Регистрационный номер страхователя  </div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/УТ6:РегНомер">
						<xsl:value-of select="$vForm/УТ6:РегНомер"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Код территориального органа Фонда  </div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
					&#160;
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Дата регистрации</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft130">
					<xsl:if test="$vForm/ns1:ДатаРегистрации">
						<xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:ДатаРегистрации"/>
							</xsl:with-param>
						</xsl:call-template>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft250 afSubscript">(Число, месяц, год)</p>
			</div>
			<div class="afRow">
				<div class="afC">Дата выдачи уведомления </div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:ДатаВыдачи">
						<xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft250 afSubscript">(Число, месяц, год)</p>
			</div>
			
			<table class="afTable afTable100">
				<tbody>
					<tr class="afVerticalBottom">
						<td class="afTable40 afTDCol-A ">
							<div class="afC">Руководитель территориального органа Фонда пенсионного и социального страхования Российской Федерации<br/><br/>
							М.П.
							</div>
						</td>
						<td class="afTable20 afTDCol-A ">
							<div class="afRow">
								<div class="afValue afUnderlinedBlock"></div>
								<p class="afSubscript afCenter">(подпись)</p>
							</div>
						</td>
						<td class="afTable40 afCenter afTDCol-A ">
							<div class="afNoBreakInside">
								<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
									<xsl:call-template name="PrintSignInfo">
										<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
									</xsl:call-template>
								</xsl:if>
							</div>
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">
									<xsl:call-template name="УТ6:NameStr">
										<xsl:with-param name="pName" select="$vForm/ns1:УполномоченноеЛицо/УТ6:ФИО"/>
										<xsl:with-param name="pInitialFirst" select="1"/>
									</xsl:call-template>
									
								</div>
								<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии))</p>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		

		</div>
	</xsl:template>
</xsl:stylesheet>
