<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ8 ns1" version="1.0" xmlns:УТ8="http://пф.рф/УТ/2025-01-01" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/УРДОССВН/2025-05-01">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2025-01-01.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УРДОССВН"/>
		<div class="afWrap pfrAfURDOSSVN">
			
			<div class="afInterval"/>
		
			<div class="afInterval"/>
			<h1 class="afHeader">Уведомление<br/>о регистрации лица, добровольно вступившего в правоотношения<br/>по обязательному социальному страхованию на случай временной нетрудоспособности</h1>
			<div class="afInterval"/><div class="afInterval"/>
			
		
			<div class="afRow">
				<div class="afCol-98">
				<div class="afC">Уважаемый(ая)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft120">
					<xsl:call-template name="УТ8:NameStr">
						<xsl:with-param name="pName" select="$vForm/ns1:Заявитель/УТ8:ФИО"/>
					</xsl:call-template>
				</p>
				<p class="afSubscript afCenter afMarginLeft120">(фамилия, имя, отчество (при наличии)</p>
				</div><p>,</p>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">проживающий(ая) по адресу</div>
					<p class="afValue afBlankUnderlinedBlock afMarginLeft200">
						<xsl:call-template name="АдресРФ">
							<xsl:with-param name="pAddressRF"
								select="$vForm/ns1:Заявитель/УТ8:АдресРФ"/>
							<xsl:with-param name="pType"
								select="$vForm/ns1:Заявитель/УТ8:АдресРФ/УТ8:ТипАдреса"/>
						</xsl:call-template>
					</p>
					<p class="afCenter afMarginLeft210 afSubscript">(почтовый адрес)</p>
				</div><p>,</p>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC afJustify">сообщаем, что на основании Вашего заявления в соответствии с законодательством
						Российской Федерации об обязательном социальном страховании Вы зарегистрированы
						<span class="afValue afUnderline">
							<xsl:call-template name="Date2GOST">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$vForm/ns1:ДатаРегистрации"/>
								</xsl:with-param>
							</xsl:call-template>&#160;
						</span>
					в качестве страхователя в
					</div>
					<p class=" afSubscript afMarginLeft380">(число, месяц, год)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<p class="afValue afUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:ТОСФР/УТ8:Наименование"/>
					</p>
					<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afRight-1-4">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="$vForm/ns1:ТОСФР/УТ8:Код"/>
						</p>
						<p class="afSubscript afCenter">(Код территориального органа Фонда)</p>
					</div>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">по месту Вашего жительства.</div>
			</div>
			
			<div class="afRow">
				<div class="afCol-98">
					<div class="afCol-6-10">
					<div class="afC">Идентификационный номер налогоплательщика (ИНН)</div>
					</div>
					<div class="afRight-3-10">
						<div class="afValue">
							<xsl:choose>
								<xsl:when test="$vForm/ns1:Заявитель/УТ8:ИНН">
									<xsl:variable name="inn" select="$vForm/ns1:Заявитель/УТ8:ИНН"/>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 1, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 2, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 3, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 4, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 5, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 6, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 7, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 8, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 9, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 10, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 11, 1)"
										/>&#160;
										</div>
									<div class="afFrame">
											&#160;<xsl:value-of select="substring($inn, 12, 1)"
										/>&#160;
										</div>
								</xsl:when>
								<xsl:otherwise>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
									<div class="afFrame">&#160;&#160;&#160;</div>
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">Регистрационный номер страхователя  </div>
					<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
						<xsl:if test="$vForm/УТ8:РегНомер">
							<xsl:value-of select="$vForm/УТ8:РегНомер"/>&#160;</xsl:if>
					</p>
				</div>
			</div>
			<div class="afInterval"/><div class="afInterval"/>
			<table class="afTable afTable98">
				<tbody>
					<tr class="afVerticalBottom">
						<td class="afTable40 afTDCol-A afVerticalTop">
							Уполномоченное лицо территориального
								органа Фонда пенсионного 
								и социального страхования Российской Федерации
						</td>
						<td class="afTable20 afTDCol-A ">
							<br/><br/>
								<p class="afValue afUnderlinedBlock"></p>
								<p class="afSubscript afCenter">(подпись)</p>
						</td>
						<td class="afTable40 afCenter afTDCol-A ">
							
							<br/><br/>
								<p class="afValue afUnderlinedBlock">
									<xsl:call-template name="УТ8:NameStr">
										<xsl:with-param name="pName" select="$vForm/ns1:УполномоченноеЛицо/УТ8:ФИО"/>
										<xsl:with-param name="pInitialFirst" select="1"/>
									</xsl:call-template>
									
								</p>
								<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии))</p>
						</td>
					</tr>
				</tbody>
			</table>
			<div class="afInterval"/>
			<div class="afRow">
				<div class="afC">М.П.</div>
			</div>
			<div class="afNoBreakInside">
				<div class="afCol-98">
					<xsl:if test="/ns1:ЭДСФР/sig:SignInfo">
						<xsl:call-template name="PrintSignInfo">
							<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
						</xsl:call-template>
					</xsl:if>
				</div>
			</div>
			<div class="afRow afStickToBottom">
				<div class="afCol-98">
					<div class="afC afSubscript afJustify">Доводим также до Вашего сведения, что лицо, добровольно вступившее в правоотношения по обязательному социальному страхованию на случай временной нетрудоспособности, уплачивает страховые взносы в Фонд пенсионного и социального страхования Российской Федерации в соответствии со статьей 5 Федерального закона  от               №…… «О проведении эксперимента по добровольному вступлению отдельных категорий граждан в правоотношения по обязательному социальному страхованию на случай временной нетрудоспособности».</div>
				</div>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
