<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ВС/УРОПСОСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УРОПСОСС"/>
		<div class="afWrap pfrAfUROPSOSS">
			<p class="afInterval"/>
			<div class="afRight-1-2 afRight afSubscriptNormal">
				Приложение № 1 <br/>
				к Порядку регистрации и снятия<br/>
				с учета страхователей в Фонде<br/>
				пенсионного и социального<br/>
				страхования Российской Федерации,<br/>
				утвержденному приказом<br/>
				Министерства труда и социальной<br/>
				защиты Российской Федерации<br/>
                от 7 декабря 2022 г. № 768н
			</div>
			<p class="afInterval"/>
			<div class="afRight-1-3 afRight afSubscriptNormal">форма</div>
			
			<p class="afInterval"/>

			<h1 class="afHeader afCenter">УВЕДОМЛЕНИЕ</h1>
			<h1 class="afHeader afCenter">о регистрации в качестве страхователя в территориальном органе</h1>
			<h1 class="afHeader afCenter">Фонда пенсионного и социального страхования Российской Федерации</h1>
			<p class="afInterval"/>

			<div class="afRow">
				<div class="afC">Настоящее уведомление выдано в соответствии с законодательством Российской Федерации об обязательном пенсионном страховании и обязательном социальном страховании
				</div>
			</div>
			<div class="afRow">
				<div class="afRow afUnderlinedBlock afValue">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:ЮЛ">
							<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ6:Наименование"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afSubscript afCenter">(полное наименование юридического лица)</p>
			</div>
			<div class="afRow">
				<div class="afRow afUnderlinedBlock afValue">
					<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП">
						<xsl:call-template name="УТ6:NameStr">
							<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/ns1:ИП/УТ6:ФИО"/>
						</xsl:call-template>
					</xsl:if>&#160;
				</div>
				<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) физического лица)</p>
			</div>
			<xsl:variable name="OGRN" select="$vForm/ns1:Страхователь/ns1:ОГРН"/>
			<div class="afRow">
				<div class="afC">ОГРН (ОГРНИП)</div>
				<div class="afValue  afMarginLeft450">
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 7, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 8, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 12, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 13, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 14, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 15, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>
			<xsl:variable name="NumINN" select="$vForm/ns1:Страхователь/УТ6:ИНН"/>
			<xsl:variable name="NumKPP" select="$vForm/ns1:Страхователь/УТ6:КПП"/>
			<div class="afRow">
				<div class="afC">ИНН</div>
				<div class="afValue afCol-3-10">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 3, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 4, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 5, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 6, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 7, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 8, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 9, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 10, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 11, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 12, 1)"/>
							</td>
						</tr>
					</table>
				</div>
				<div class="afValue afCol-1-5">&#160;</div>
				<div class="afCol-1-10">&#160;</div>
				<div class="afCol-1-10">&#160;</div>
				<div class="afC">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</div>
				<div class="afC">КПП</div>
				<div class="afC afValue">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 3, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 4, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 5, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 6, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 7, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 8, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 9, 1)"/>
							</td>
						</tr>
					</table>
				</div>
			</div>
			
			<div class="afRow">
				<div class="afC">Адрес</div>
				<p class="afUnderlinedBlock afValue afMarginLeft70">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:Адрес/УТ6:Неструктурированный">
							<xsl:value-of select="$vForm/ns1:Страхователь/ns1:Адрес/УТ6:Неструктурированный"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:Адрес/УТ6:Иностранный">
							<xsl:call-template name="УТ6:AddressForeignStr">
								<xsl:with-param name="pAddress" select="$vForm/Страхователь/ns1:Адрес"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:Адрес">
							<xsl:call-template name="УТ6:AddressStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:Страхователь/ns1:Адрес"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</p>
				<p class="afSubscript afCenter afMarginLeft170">(адрес юридического лица/адрес места жительства физического лица)</p>
			</div>
		
			<div class="afRow">
				<div class="afC">и подтверждает регистрацию в качестве страхователя (отметить вид страхования):</div>
			</div>
			<p class="afInterval"/>
			<table class="afTable afTable100 afNoBreakInside">
				<thead class="afWordBreak ">
					<tr class="afCenter">
						<td class="afTable10">&#160;</td>
						<td class="afTable60">ВИД СТРАХОВАНИЯ</td>
						<td class="afTable30">
							Дата регистрации <br/>(число, месяц, год)	
						</td>
					</tr>
				</thead>
				<tbody>
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:ЮЛ">
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОПС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному пенсионному страхованию</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОПС">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОПС"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССВН">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССВН">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССВН"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССНС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию от несчастных случаев на производстве и профессиональных заболеваний</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССНС">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССНС"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП">
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОПС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному пенсионному страхованию</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОПС">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОПС"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством</td>
								<td class="afValue afCenter">
									<xsl:choose>
										<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД and not($vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД) ">
											ТД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="not($vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД) and $vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД ">
											ГПД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД and $vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД ">
											ТД/ГПД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД "/>
												</xsl:with-param>
											</xsl:call-template>/
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>&#160;</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию от несчастных случаев на производстве и профессиональных заболеваний</td>
								<td class="afValue afCenter">
									<xsl:choose>
										<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД and not($vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД) ">
											ТД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="not($vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД) and $vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД ">
											ГПД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД and $vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД ">
											ТД/ГПД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД "/>
												</xsl:with-param>
											</xsl:call-template>/
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>&#160;</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</tbody>
			</table>
			<p class="afInterval"/>
			
			<div class="afRow">
				<div class="afC">Присвоен регистрационный номер</div>
				<div class="afValue afUnderlinedBlock afMarginLeft450">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:РегНомер"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">в</div>
				<div class="afValue afUnderlinedBlock afMarginLeft50">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</div>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<div class="afRow">
				<div class="afValue afUnderlinedBlock afMarginLeft450">
					&#160;
				</div>
				<p class="afSubscript afMarginLeft450">(код территориального органа Фонда)</p>
			</div>
			
			<div class="afRow">
				<div class="afC">Дата направления (выдачи) уведомления</div>
				<div class="afCol-1-5">
					<p class="afUnderlinedBlock afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="$vForm/ns1:ДатаВыдачи"/>
						</xsl:call-template>
					</p>
					<p class="afSubscript afCenter">(число, месяц, год)</p>
				</div>
			</div>
			
			
			<table class="afTable afTable100">
				<tbody>
					<tr class="afVerticalBottom">
						<td class="afTable40 afTDCol-A ">
							<div class="afC">Уполномоченное должностное лицо<br/>территориального органа Фонда<br/>пенсионного и социального страхования<br/>Российской Федерации<br/></div>
						</td>
						<td class="afTable20 afTDCol-A ">
							<div class="afRow">
								<div class="afValue afUnderlinedBlock"></div>
								<p class="afSubscript afCenter">(подпись)</p>
							</div>
						</td>
						<td class="afTable40 afCenter afTDCol-A ">
							<div class="afNoBreakInside">
								<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
									<xsl:call-template name="PrintSignInfo">
										<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
									</xsl:call-template>
								</xsl:if>
							</div>
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">
									<xsl:call-template name="УТ6:NameStr">
										<xsl:with-param name="pName" select="$vForm/ns1:УполномоченноеЛицо/УТ6:ФИО"/>
										<xsl:with-param name="pInitialFirst" select="1"/>
									</xsl:call-template>
									
								</div>
								<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии))</p>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
			<div class="afC afMarginLeft50">М.П.</div>

		</div>
	</xsl:template>
</xsl:stylesheet>
