<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:ns1="http://пф.рф/ВС/УСОПСОСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УСОПСОСС"/>
		<div class="afWrap">
			<div class="afRight-1-2 afRight afSubscriptNormal">
				Приложение № 1 <br/>
				к Порядку регистрации и снятия<br/>
				с учета страхователей в Фонде<br/>
				пенсионного и социального<br/>
				страхования Российской Федерации,<br/>
				утвержденному приказом<br/>
				Министерства труда и социальной<br/>
				защиты Российской Федерации<br/>
                от 7 декабря 2022 г. № 768н
			</div>
			<p class="afInterval"/>
			<div class="afRight afSubscriptNormal">форма</div>
			<h1 class="afHeader afCenter">УВЕДОМЛЕНИЕ</h1>
			<h1 class="afHeader afCenter">о снятии с учета<br/>в территориальном органе	Фонда пенсионного<br/>и социального страхования Российской Федерации</h1>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<div class="afRow">
				<div class="afRight-1-3">
					<p class="afValue afUnderlinedBlock">
						&#160;
					</p>
					<p class="afSubscript afCenter">(код территориального органа Фонда)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">уведомляет о снятии с учета страхователя</div>
			</div>
			<div class="afRow">
				<div class="afRow afUnderlinedBlock afValue">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:ЮЛ">
							<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ6:Наименование"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:ОП">
							<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ОП/УТ6:Наименование"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afSubscript afCenter">(наименование юридического лица/обособленного подразделения юридического лица )</p>
			</div>
			<div class="afRow">
				<div class="afRow afUnderlinedBlock afValue">
					<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП">
						<xsl:call-template name="УТ6:NameStr">
							<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/ns1:ИП/УТ6:ФИО"/>
						</xsl:call-template>
					</xsl:if>&#160;
					
				</div>
				<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) физического лица)</p>
			</div>
			<!-- Регистрационный номер -->
			<div class="afRow">
				<div class="afCol-1-2">Регистрационный номер</div>
				<div class="afRight-1-3">
					<p class="afValue afUnderlinedBlock">
						<xsl:value-of  select="$vForm/ns1:Страхователь/УТ6:РегНомер"/>
					</p>
				</div>
			</div>
			<!-- ОГРН (ОГРНИП) -->
			<div class="afRow">
				<div class="afCol-1-2">ОГРН (ОГРНИП)</div>
				<div class="afCol-1-2">
					<div class="afValue afMarginLeft100">
						<xsl:variable name="ogrn" select="$vForm/ns1:Страхователь/ns1:ОГРН"/>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 1, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 2, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 3, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 4, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 5, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 6, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 7, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 8, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 9, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 10, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 11, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 12, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 13, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 14, 1)"/>&#160;
						</div>
						<div class="afFrame">
							&#160;<xsl:value-of select="substring($ogrn, 15, 1)"/>&#160;
						</div>
					</div>
				</div>
			</div>
			<!-- ИНН КПП -->
			<xsl:variable name="inn" select="$vForm/ns1:Страхователь/УТ6:ИНН"/>
			<xsl:variable name="kpp" select="$vForm/ns1:Страхователь/УТ6:КПП"/>
			<div class="afRow">
				<div class="afCol-1-5">ИНН</div>
				<div class="afCol-3-10">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 3, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 4, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 5, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 6, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 7, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 8, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 9, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 10, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 11, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($inn, 12, 1)"/>
							</td>
						</tr>
					</table>
				</div>
				<div class="afCol-1-5">КПП</div>
				<div class="afCol-3-10">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 3, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 4, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 5, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 6, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 7, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 8, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($kpp, 9, 1)"/>
							</td>
						</tr>
					</table>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">и подтверждает снятие с учета в качестве страхователя (отметить вид страхования):</div>
			</div>
			<table class="afTable afTable100">
				<tr class="afCenter">
					<td class="afTable5 afCenter">
						&#160;
                    </td>
					<td>ВИД СТРАХОВАНИЯ</td>
					<td>Дата снятия с учета <br/>
						(число, месяц, год)
					</td>
				</tr>
						<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:ЮЛ">
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОПС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному пенсионному страхованию</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОПС">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОПС"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССВН">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССВН">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССВН"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССНС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию от несчастных случаев на производстве и профессиональных заболеваний</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССНС">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/ns1:ВидСтрахования/ns1:ОССНС"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
						</xsl:when>
							<xsl:when test="$vForm/ns1:Страхователь/ns1:ОП">
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОПС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному пенсионному страхованию</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОПС">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОПС"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОССВН">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОССВН">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОССВН"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОССНС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию от несчастных случаев на производстве и профессиональных заболеваний</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОССНС">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ОП/ns1:ВидСтрахования/ns1:ОССНС"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП">
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОПС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному пенсионному страхованию</td>
								<td class="afValue afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОПС">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОПС"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством</td>
								<td class="afValue afCenter">
									<xsl:choose>
										<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД and not($vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД) ">
											ТД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="not($vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД) and $vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД ">
											ГПД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД and $vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД ">
											ТД/ГПД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаТД "/>
												</xsl:with-param>
											</xsl:call-template>/
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССВН/ns1:ДатаГПД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>&#160;</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
							<tr>
								<td class=" afCenter">
									<xsl:if test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС">V</xsl:if>
								</td>
								<td class=" afAlignLeft">по обязательному социальному страхованию от несчастных случаев на производстве и профессиональных заболеваний</td>
								<td class="afValue afCenter">
									<xsl:choose>
										<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД and not($vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД) ">
											ТД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="not($vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД) and $vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД ">
											ГПД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД and $vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД ">
											ТД/ГПД<br/>
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаТД "/>
												</xsl:with-param>
											</xsl:call-template>/
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/ns1:ВидСтрахования/ns1:ОССНС/ns1:ДатаГПД "/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>&#160;</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
			</table>
			<div class="afRow">
				<div class="afC">Основание снятия с учета</div>
				<div class="afC">
					<p class="afValue afUnderlinedBlock ">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:Страхователь/ns1:ЮЛ">
								Сведения о прекращении юридического лица
							</xsl:when>
							<xsl:when test="$vForm/ns1:Страхователь/ns1:ОП">
								<xsl:choose>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ОснованиеСнятия = '2'">Сведения о снятии с учета обособленного подразделения российской организации</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ОснованиеСнятия = '3'">Сведения о снятии с учета иностранной (международной) организации в налоговых органах</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ОснованиеСнятия = '4'">Закрытие счета в банке (иной кредитной организации), открытого для совершения операций обособленным подразделением</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ОснованиеСнятия = '5'">Прекращение полномочий обособленного подразделения по начислению выплат и иных вознаграждений в пользу физических лиц</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ОП/ns1:ОснованиеСнятия = '6'">Сведения о прекращении юридического лица (головного предприятия)</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП">
								<xsl:choose>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ОснованиеСнятия = '7'">Сведения о прекращении деятельности в качестве индивидуального предпринимателя или о прекращении КФХ</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ОснованиеСнятия = '8'">Cведения о снятии с учета физического лица в налоговых органах</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ОснованиеСнятия = '9'">Прекращение трудового договора с последним работником</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ОснованиеСнятия = '10'">Расторжение либо окончание срока действия гражданско-правового договора</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ОснованиеСнятия = '14'">Прекращение правоотношений в связи со смертью страхователя</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ОснованиеСнятия = '15'">Сведения об отмене трудовых отношений</xsl:when>
									<xsl:when test="$vForm/ns1:Страхователь/ns1:ИП/ns1:ОснованиеСнятия = '17'">Сведения о смене главы КФХ</xsl:when>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
					</p>
				</div>
			</div>
			
			<div class="afRow">
				<div class="afC">Дата выдачи (направления) уведомления</div>
				<div class="afCol-1-5">
					<p class="afUnderlinedBlock afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="$vForm/ns1:ДатаВыдачи"/>
						</xsl:call-template>
					</p>
					<p class="afSubscript afCenter">(число, месяц, год)</p>
				</div>
			</div>
			<table class="afTable afTable100">
				<tbody>
					<tr class="afVerticalBottom">
						<td class="afTable40 afTDCol-A ">
							<div class="afC">Уполномоченное должностное лицо<br/>территориального органа Фонда<br/>пенсионного и социального страхования<br/>Российской Федерации<br/></div>
						</td>
						<td class="afTable20 afTDCol-A ">
							<div class="afRow">
								<div class="afValue afUnderlinedBlock"></div>
								<p class="afSubscript afCenter">(подпись)</p>
							</div>
						</td>
						<td class="afTable40 afCenter afTDCol-A ">
							<div class="afNoBreakInside">
								<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
									<xsl:call-template name="PrintSignInfo">
										<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
									</xsl:call-template>
								</xsl:if>
							</div>
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">
									<xsl:call-template name="УТ6:NameStr">
										<xsl:with-param name="pName" select="$vForm/ns1:УполномоченноеЛицо/УТ6:ФИО"/>
										<xsl:with-param name="pInitialFirst" select="1"/>
									</xsl:call-template>
									
								</div>
								<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии))</p>
							</div>
						</td>
					</tr>
					<tr>
						<td class="afTable40 afTDCol-A">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;М.П.</td>
						<td class="afTDCol-A" colspan="2">&#160;</td>
					</tr>
				</tbody>
			</table>
		</div>
	</xsl:template>
	<xsl:template name="RegInfSrc">
		<xsl:param name="pRegInfSrc"/>
		<xsl:choose>
			<xsl:when test="$pRegInfSrc = '1'">ФНС (ЕГРН ОП)</xsl:when>
			<xsl:when test="$pRegInfSrc = '2'">ФНС (ЕГРН ИО)</xsl:when>
			<xsl:when test="$pRegInfSrc = '3'">ФНС (ЕГРН ФЛ)</xsl:when>
			<xsl:when test="$pRegInfSrc = '4'">ФНС (ЕГРИП)</xsl:when>
			<xsl:when test="$pRegInfSrc = '5'">ФНС (ЕГРЮЛ)</xsl:when>
			<xsl:when test="$pRegInfSrc = '6'">ЦБ</xsl:when>
			<xsl:when test="$pRegInfSrc = '7'">Экспертный центр</xsl:when>
			<xsl:when test="$pRegInfSrc = '8'">Офис клиентского обслуживания</xsl:when>
			<xsl:when test="$pRegInfSrc = '9'">ЕПГУ</xsl:when>
			<xsl:when test="$pRegInfSrc = '10'">РасчОПС</xsl:when>
			<xsl:when test="$pRegInfSrc = '11'">Заявление</xsl:when>
			<xsl:when test="$pRegInfSrc = '12'">Мой налог</xsl:when>
			<xsl:when test="$pRegInfSrc = '13'">СЗВ-ТД из РПУ</xsl:when>
			<xsl:when test="$pRegInfSrc = '14'">СЗВ-М из РПУ</xsl:when>
			<xsl:when test="$pRegInfSrc = '15'">МФЦ</xsl:when>
			<xsl:when test="$pRegInfSrc = '16'">ЛС</xsl:when>
			<xsl:when test="$pRegInfSrc = '17'">РПУ (ЗАГС)</xsl:when>
			<xsl:when test="$pRegInfSrc = '18'">Почта России</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
