<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ВС ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:ВС="http://пф.рф/ВС/типы/2023-01-10" xmlns:ns1="http://пф.рф/ВС/УСРС/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УСРС"/>
		<div class="afWrap pfrAfUSRS">
			<p class="afInterval"/>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:value-of select="$vForm/ns1:ТерриториальныйОрганСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального
                    страхования Российской Федерации)
                </p>
			</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:value-of select="$vForm/ns1:ТерриториальныйОрганСФР/УТ6:Адрес"/>
				</p>
				<p class="afSubscript afCenter">(адрес территориального органа Фонда пенсионного и социального
                    страхования Российской Федерации)
                </p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader">Уведомление<br/>об устранении ошибок и (или) несоответствий между представленными<br/>
                страхователем сведениями и сведениями, имеющимисяу Фонда<br/>
        пенсионного и социального страхования Российской Федерации<br/>
                       в том числе полученными от налоговых органов
            </h1>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Страхователю</div>
				<p class="afValue afUnderlinedBlock afMarginLeft250">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/УТ6:ФИО">
							<xsl:call-template name="УТ6:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ6:ФИО"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ВС:Наименование">
							<xsl:value-of select="$vForm/ns1:Страхователь/ВС:Наименование"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Регистрационный номер в СФР</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/ns1:Страхователь/УТ6:РегНомер">
						<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:РегНомер"/>&#160;
                    </xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">ИНН</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/ns1:Страхователь/УТ6:ИНН">
						<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:ИНН"/>&#160;
                    </xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">КПП</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/ns1:Страхователь/УТ6:КПП">
						<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:КПП"/>&#160;
                    </xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afCol-1-3 afJustify afMarginLeft5">адрес в пределах места нахождения юридического лица (обособленного подразделения)/адрес регистрации индивидуального предпринимателя, физического лица</div>
				<div class="afValue afUnderlinedBlock afMarginLeft250">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ВС:Адрес/УТ6:Неструктурированный">
							<xsl:value-of select="$vForm/ns1:Страхователь/ВС:Адрес/УТ6:Неструктурированный"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ВС:Адрес">
							<xsl:call-template name="УТ6:AddressStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:Страхователь/ВС:Адрес"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>
			<div class="afRow">
				<div class="afC afJustify afParagraph">В представленных сведениях выявлены ошибки и (или) несоответствия между
представленными  сведениями  и сведениями, имеющимися у Фонда пенсионного и
социального страхования Российской Федерации, в том числе полученными от
налоговых органов.</div>
			</div>
			<div class="afRow">
				<div class="afC afJustify afParagraph">  Протокол проверки прилагается. </div>
			</div>
			<div class="afRow">
				<div class="afC afJustify afParagraph">В   случае   представления   страхователем   уточненных (исправленных)
сведений,  в  отношении  которых территориальным органом Фонда пенсионного и социального  страхования  Российской  Федерации 
страхователю вручено уведомление об устранении имеющихся ошибок и несоответствий, в
течение пяти рабочих дней со дня получения данного уведомления<sup class="afSubscript">1</sup>
к такому страхователю финансовые санкции не применяются<sup class="afSubscript">2</sup>. </div>
			</div>
			<div class="afRow">
				<div class="afC afJustify afParagraph">Страхователь представляет сведения для индивидуального (персонифицированного) учета в органы Фонда пенсионного и социального  страхования  Российской  Федерации по месту своей регистрации <sup class="afSubscript">3</sup>. </div>
			</div>
			
			<p class="afInterval"/>
			
			<div class="afRow">
				<div class="afC afJustify afParagraph">Уведомление получил<sup class="afSubscript">4</sup>. </div>
			</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ6:ФИО"/>
				</p>
				<p class="afCenter afMarginLeft5 afSubscript">(дата, подпись, Ф.И.О. лица, получившего документ, для
                    представителя указывается основание представительства (наименование и иные реквизиты документа,
                    подтверждающего полномочия)
                </p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afParagraph">Дата формирования уведомления:</div>
				<p class="afValue">
					<xsl:if test="$vForm/ns1:ДатаФормирования">
						<xsl:call-template name="Date2Text">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:ДатаФормирования"/>
							</xsl:with-param>
						</xsl:call-template>&#160;
                    </xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Протокол проверки:</div>
			</div>
			<div class="afRow">
				<div class="afC">Застрахованное лицо, сведения которого подлежат корректировке:</div>
			</div>
			<div class="afRow">
				<p class="afValue afBlankUnderlinedBlock afMarginLeft5">
					<xsl:if test="$vForm/ns1:ЗастрахованноеЛицо">
						<xsl:value-of select="$vForm/ns1:ЗастрахованноеЛицо/УТ6:ФИО"/>&#160;
                    </xsl:if>
				</p>
				<p class="afCenter afSubscript">(фамилия, имя, отчество (при наличии)</p>
			</div>
			<div class="afRow">
				<div class="afC">страховой номер индивидуального лицевого счета</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft350">
					<xsl:if test="$vForm/ns1:ЗастрахованноеЛицо">
						<xsl:value-of select="$vForm/ns1:ЗастрахованноеЛицо/УТ6:СНИЛС"/>&#160;
                    </xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Уведомление сформировано в отношении периодов работы</div>
				<xsl:for-each select="$vForm/ns1:ЗастрахованноеЛицо/ns1:Период">
					<p class="afValue afBlankUnderlinedBlock afMarginLeft400">
                        c

                        <xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="УТ6:С"/>
							</xsl:with-param>
						</xsl:call-template>
                        по

                        <xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="УТ6:По"/>
							</xsl:with-param>
						</xsl:call-template>
					</p>
				</xsl:for-each>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
					</xsl:call-template>
				</xsl:if>
			</div>
			<p class="afInterval"/>
			<p>_____________________________________________</p>
			<p class="afFootnote">
				<sup>1</sup>
                В случае направления уведомления по почте заказным письмом датой вручения этого уведомления считается шестой день считая с даты отправления заказного письма.
            </p>
			<p class="afFootnote">
				<sup>2</sup>
                Часть 25 статьи 17 Федерального закона от 1 апреля 1996 г. N 27-ФЗ "Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования" (Собрание законодательства Российской Федерации, 1996, N 14, ст. 1401; 2016, N 27, ст. 4183).
            </p>
			<p class="afFootnote">
				<sup>3</sup>
                 статья 11 Федерального закона от 1 апреля 1996 г. N 27-ФЗ "Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования" (Собрание законодательства Российской Федерации, 1996, N 14, ст. 1401; 2016, N 27, ст. 4183).
            </p>
            <p class="afFootnote">
				<sup>4</sup>
                Заполняется в случае вручения документа на бумажном носителе лично.
            </p>
		</div>
	</xsl:template>
</xsl:stylesheet>
