<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ7 АФ7 sig ns1" version="1.0"
    xmlns:УТ7="http://пф.рф/УТ/2023-04-03"  xmlns:АФ7="http://пф.рф/АФ/2023-04-03" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ЗПЭД/2024-01-01">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:include href="../../Общие/УнифТипы_2023-04-03.xsl"/>
    <xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
    <xsl:template match="/" name="inc">
        <xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:ЗПЭД"/>
        <div class="afWrap">
            
            <h1 class="afHeader afCenter">Заявление на подключение страхователя к электронному документообороту СФР</h1>
            <p class="afInterval"/>
            
            <div class="afRow afParagraph">Прошу подключить в качестве участника электронного документооборота Фонда пенсионного и социального страхования Российской Федерации по телекоммуникационным каналам связи через Оператора.</div>
            <p class="afInterval"/>
            
            <div class="afRow afParagraph">
                <div class="afBold">Сведения о страхователе<span class="afSup">1</span>:</div>
            </div>
            <p class="afInterval"/>
            
            <table class="afTable afTable100">
                <tr>
                    <th colspan="2" class="afBold afCenter">Юридическое лицо</th>
                </tr>
                <tr>
                    <td class="afTable40">Регистрационный номер в СФР</td>
                    <td class="afValue">
                        <xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ7:РегНомер"/>
                    </td>
                </tr>
                <tr>
                    <td>Полное наименование</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ7:Наименование"/></td>
                </tr>
                <tr>
                    <td>Краткое наименование</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ7:НаименованиеКраткое"/></td>
                </tr>
                <tr>
                    <td>ИНН</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ7:ИНН"/></td>
                </tr>
                <tr>
                    <td>КПП</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ7:КПП"/></td>
                </tr>
                <tr>
                    <td>Телефон</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ7:Телефон"/></td>
                </tr>
                <tr>
                    <td>Адрес электронной почты</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ЮЛ/УТ7:АдресЭлПочты"/></td>
                </tr>
            </table>
            <p class="afInterval"/>
            
            <table class="afTable afTable100">
                <tr>
                    <th colspan="2" class="afBold afCenter">Индивидуальный предприниматель</th>
                </tr>
                <tr>
                    <td class="afTable40">Регистрационный номер в СФР</td>
                    <td class="afValue">
                        <xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/УТ7:РегНомер"/>
                    </td>
                </tr>
                <tr>
                    <td>ФИО</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/УТ7:ФИО"/></td>
                </tr>
                <tr>
                    <td>СНИЛС</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/УТ7:СНИЛС"/></td>
                </tr>
                <tr>
                    <td>ИНН</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/УТ7:ИНН"/></td>
                </tr>
                <tr>
                    <td>Телефон</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/УТ7:Телефон"/></td>
                </tr>
                <tr>
                    <td>Адрес электронной почты</td>
                    <td class="afValue"><xsl:value-of select="$vForm/ns1:Страхователь/ns1:ИП/УТ7:АдресЭлПочты"/></td>
                </tr>
            </table>
            <p class="afInterval"/>
            
            <div class="afNoBreakInside">
                <div class="afRow afParagraph">
                    <div class="afBold">Сведения об операторе ЭДО СФР:</div>
                </div>
                <p class="afInterval"/>

                <table class="afTable afTable100">
                    <tr>
                        <td class="afTable40">Регистрационный номер в СФР</td>
                        <td class="afValue"><xsl:value-of select="$vForm/ns1:Оператор/УТ7:РегНомер"/></td>
                    </tr>
                    <tr>
                        <td>Краткое наименование</td>
                        <td class="afValue"><xsl:value-of select="$vForm/ns1:Оператор/УТ7:НаименованиеКраткое"/></td>
                    </tr>
                    <tr>
                        <td>ИНН</td>
                        <td class="afValue"><xsl:value-of select="$vForm/ns1:Оператор/УТ7:ИНН"/></td>
                    </tr>
                    <tr>
                        <td>КПП</td>
                        <td class="afValue"><xsl:value-of select="$vForm/ns1:Оператор/УТ7:КПП"/></td>
                    </tr>
                </table>
                <p class="afInterval"/>
                <p class="afInterval"/>

                <div class="afRow">
                    <div class="afCol-1-2">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:value-of select="$vForm/ns1:ПредставительСотрудник/УТ7:Должность"/>
                        </div>
                        <p class="afCenter afP afSubscript">(Должность)</p>
                    </div>
                    <div class="afCol-1-4">
                        <div class="afValue afUnderlinedBlock"></div>
                        <p class="afCenter afP afSubscript">(Подпись)</p>
                    </div>
                    <div class="afCol-1-4">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:value-of select="$vForm/ns1:ПредставительСотрудник/УТ7:ФИО"/>
                        </div>
                        <p class="afCenter afP afSubscript">(Ф.И.О)</p>
                    </div>
                </div>
                <p class="afInterval"/>
                <p class="afInterval"/>

                <div class="afRow">
                    <div class="afCol-1-3">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:variable name="dateTimeText" select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/АФ7:ДатаВремя"/>
                            <xsl:call-template name="Date2Text">
                                <xsl:with-param name="pDate" select="substring($dateTimeText, 1, 10)"/>                                     
                            </xsl:call-template>&#160;г.
                        </div>
                    </div>
                    <div class="afCol-1-3">
                        <div class="afCenter">М.П. (при наличии)</div>
                    </div>
                </div>
                <p class="afInterval"/>
                <div class="afNoBreakInside">
					<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
						<xsl:call-template name="PrintSignInfo">
							<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
						</xsl:call-template>
					</xsl:if>
				</div>
                <p class="afInterval"/>
                <p class="afInterval"/>
                <p class="afInterval"/>
				<p class="afInterval"/>
                <p class="afStickToBottom">
                    <p>_____________________________________________</p>
                    <p class="afFootnote">
						<sup>1</sup>&#160;Заполняется только один раздел: «Юридическое лицо» или «Индивидуальный предприниматель».</p>
                </p>
            </div>
            
        </div>
    </xsl:template>
</xsl:stylesheet>
