<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ7 АФ7 sig ns1" version="1.0" xmlns:УТ7="http://пф.рф/УТ/2023-04-03" xmlns:АФ7="http://пф.рф/АФ/2023-04-03" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/УОНД/2024-01-01">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/УнифТипы_2023-04-03.xsl"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УОНД"/>
		<div class="afWrap pfrAfUOND">
			<h1 class="afHeader afCenter">Уведомление о невозможности доставки документа через систему ЭДО с СФР</h1>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Наименование страхователя</div>
				<div class="afMarginLeft200 afUnderlinedBlock"/>
				<p class="afInterval"/>
				<div class="afUnderlinedBlock afWordBreak afValue">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/УТ7:НаименованиеКраткое">
							<xsl:value-of select="$vForm/ns1:Страхователь/УТ7:НаименованиеКраткое"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/УТ7:ФИО">
							<xsl:call-template name="УТ7:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ7:ФИО"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afJustify">регистрационный номер страхователя <span class="afUnderline afValue">
						<xsl:value-of select="$vForm/ns1:Страхователь/УТ7:РегНомер"/>
					</span>, имеется исходящий документ СФР в адрес страхователя, который невозможно доставить через систему ЭДО с СФР.
				</div>
			</div>
			<div class="afRow">
				<div class="afC">
					Причина невозможности доставки через ЭДО с СФР:
				</div>
			</div>
			<div class="afRow">
				<div class="afC afValue">
					<xsl:value-of select="$vForm/ns1:Причина"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">
					Просим оператора электронного документооборота проверить причины не направления уведомления о доставке в адрес СФР.
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Реквизиты документа:</div>
			</div>
			<div class="afRow">
				<div class="afCol-5">&#160;</div>
				<div class="afCol-1-4">Наименование:</div>
				<div class="afCol-2-3 afValue">
					<xsl:value-of select="$vForm/ns1:Документ/ns1:Наименование"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-5">&#160;</div>
				<div class="afCol-1-4 afC">Код документа по АФ:</div>
				<div class="afCol-2-3 afValue">
					<xsl:value-of select="$vForm/ns1:Документ/ns1:Код"/>
				</div>
			</div>
			<xsl:if test="$vForm/ns1:Документ/ns1:ВОтветНа">
				<div class="afRow">
					<div class="afCol-5">&#160;</div>
					<div class="afCol-1-4 afC">В ответ на: </div>
					<div class="afCol-2-3 afValue">
						<xsl:value-of select="$vForm/ns1:Документ/ns1:ВОтветНа"/>
					</div>
				</div>
			</xsl:if>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-5">&#160;</div>
				<div class="afCol-4-10 afC">Регистрационный номер обращения СФР: </div>
				<div class="afCol-1-2 afValue">
					<xsl:value-of select="$vForm/ns1:Документ/ns1:РегНомерОбращ"/>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Дата и время уведомления:&#160;</div>
				<div class="afCol-1-4 afUnderlinedBlock afValue">
					<xsl:variable name="dateTimeText" select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/АФ7:ДатаВремя"/>
					<xsl:value-of select="concat(substring($dateTimeText, 1, 10), ' ', substring($dateTimeText, 12, 5))"/>
				</div>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
					</xsl:call-template>
				</xsl:if>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
