<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xs="http://www.w3.org/2001/XMLSchema" 
                exclude-result-prefixes="xs" 
                version="1.0">
    
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
    
    <!-- Универсальные переменные для доступа к элементам независимо от неймспейса -->
    <xsl:variable name="root" select="/*"/>
    <xsl:variable name="УОПП" select="$root/*[local-name() = 'УОПП']"/>
    <xsl:variable name="Оператор" select="$УОПП/*[local-name() = 'Оператор']"/>
    <xsl:variable name="Страхователь" select="$УОПП/*[local-name() = 'Страхователь']"/>
    <xsl:variable name="ВходящийПакет" select="$УОПП/*[local-name() = 'ВходящийПакет']"/>
    <xsl:variable name="Причина" select="$УОПП/*[local-name() = 'Причина']"/>
    <xsl:variable name="СлужебнаяИнформация" select="$root/*[local-name() = 'СлужебнаяИнформация']"/>
    
    <xsl:template match="/" name="inc">
        
        <div class="afWrap">
            <xsl:apply-templates select="/*[local-name() = 'ЭДСФР' or local-name() = 'ЭДПФР']"/>
            <a name="top"/>
        </div>
    </xsl:template>
    
    <!-- Основной шаблон для корневого элемента -->
    <xsl:template match="*[local-name() = 'ЭДСФР' or local-name() = 'ЭДПФР']">
            
        <h1 class="afHeader afCenter">Уведомление об отказе в приеме пакета</h1>
        <p class="afInterval"/>
        
        <!-- Блок информации об операторе -->
        <div class="afSection">
            <h2 class="afSectionHeader">Сведения об операторе электронного документооборота</h2>
            
            <div class="afRow">
                <div class="afCol-1-3 afLabel">Регистрационный номер оператора:</div>
                <div class="afCol-2-3 afUnderlinedBlock afValue">
                    <xsl:value-of select="$Оператор/*[local-name() = 'РегНомер']"/>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-1-3 afLabel">Краткое наименование оператора:</div>
                <div class="afCol-2-3 afUnderlinedBlock afValue">
                    <xsl:value-of select="$Оператор/*[local-name() = 'НаименованиеКраткое']"/>
                </div>
            </div>
        </div>
        
        <p class="afInterval"/>
        
        <!-- Блок информации о страхователе (если есть) -->
        <xsl:if test="$Страхователь">
            <div class="afSection">
                <h2 class="afSectionHeader">Сведения о страхователе</h2>
                
                <div class="afRow">
                    <div class="afCol-1-3 afLabel">Регистрационный номер:</div>
                    <div class="afCol-2-3 afUnderlinedBlock afValue">
                        <xsl:value-of select="$Страхователь/*[local-name() = 'РегНомер']"/>
                    </div>
                </div>
                
                <p class="afInterval"/>
                
                <div class="afRow">
                    <div class="afCol-1-3 afLabel">Наименование/ФИО:</div>
                    <div class="afCol-2-3 afUnderlinedBlock afValue">
                        <xsl:choose>
                            <xsl:when test="$Страхователь/*[local-name() = 'НаименованиеКраткое']">
                                <xsl:value-of select="$Страхователь/*[local-name() = 'НаименованиеКраткое']"/>
                            </xsl:when>
                            <xsl:when test="$Страхователь/*[local-name() = 'ФИО']">
                                <xsl:value-of select="$Страхователь/*[local-name() = 'ФИО']"/>
                            </xsl:when>
                            <xsl:otherwise> </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                
                <p class="afInterval"/>
                
                <div class="afRow">
                    <div class="afCol-1-3 afLabel">ИНН:</div>
                    <div class="afCol-2-3 afUnderlinedBlock afValue">
                        <xsl:value-of select="$Страхователь/*[local-name() = 'ИНН']"/>
                    </div>
                </div>
                
                <xsl:if test="$Страхователь/*[local-name() = 'КПП']">
                    <p class="afInterval"/>
                    <div class="afRow">
                        <div class="afCol-1-3 afLabel">КПП:</div>
                        <div class="afCol-2-3 afUnderlinedBlock afValue">
                            <xsl:value-of select="$Страхователь/*[local-name() = 'КПП']"/>
                        </div>
                    </div>
                </xsl:if>
            </div>
            
            <p class="afInterval"/>
        </xsl:if>
        
        <!-- Блок информации о входящем пакете -->
        <div class="afSection">
            <h2 class="afSectionHeader">Сведения о входящем пакете</h2>
            
            <div class="afRow">
                <div class="afCol-1-3 afLabel">Идентификатор пакета (GUID):</div>
                <div class="afCol-2-3 afUnderlinedBlock afWordBreak afValue">
                    <xsl:value-of select="$ВходящийПакет/*[local-name() = 'Идентификатор']"/>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-1-3 afLabel">Дата и время доставки пакета:</div>
                <div class="afCol-2-3 afUnderlinedBlock afValue">
                    <xsl:variable name="dateTimeText" select="$ВходящийПакет/*[local-name() = 'ДатаВремя']"/>
                    <xsl:value-of select="concat(substring($dateTimeText, 1, 10), ' ', substring($dateTimeText, 12, 8))"/>
                </div>
            </div>
        </div>
        
        <p class="afInterval"/>
        
        <!-- Блок информации о причине отказа -->
        <div class="afSection">
            <h2 class="afSectionHeader">Причина отказа в приеме пакета</h2>
            
            <div class="afRow">
                <div class="afCol-1-3 afLabel">Код ошибки:</div>
                <div class="afCol-2-3 afUnderlinedBlock afValue">
                    <xsl:value-of select="$Причина/*[local-name() = 'КодОшибки']"/>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-1-3 afLabel">Описание ошибки:</div>
                <div class="afCol-2-3 afUnderlinedBlock afValue afWordBreak">
                    <xsl:value-of select="$Причина/*[local-name() = 'Описание']"/>
                </div>
            </div>
        </div>
        
        <p class="afInterval"/>
        
        <!-- Служебная информация -->
        <xsl:if test="$СлужебнаяИнформация">
            <div class="afSection">
                <h2 class="afSectionHeader">Служебная информация</h2>
                
                <div class="afRow">
                    <div class="afCol-1-3 afLabel">Дата и время формирования:</div>
                    <div class="afCol-2-3 afUnderlinedBlock afValue">
                        <xsl:variable name="serviceDateTime" select="$СлужебнаяИнформация/*[local-name() = 'ДатаВремя']"/>
                        <xsl:if test="$serviceDateTime">
                            <xsl:value-of select="concat(substring($serviceDateTime, 1, 10), ' ', substring($serviceDateTime, 12, 8))"/>
                        </xsl:if>
                    </div>
                </div>
                
                <xsl:if test="$СлужебнаяИнформация/*[local-name() = 'ИдентификаторДокумента']">
                    <p class="afInterval"/>
                    <div class="afRow">
                        <div class="afCol-1-3 afLabel">Идентификатор документа:</div>
                        <div class="afCol-2-3 afUnderlinedBlock afWordBreak afValue">
                            <xsl:value-of select="$СлужебнаяИнформация/*[local-name() = 'ИдентификаторДокумента']"/>
                        </div>
                    </div>
                </xsl:if>
            </div>
        </xsl:if>
        
    </xsl:template>
    
    <!-- Универсальный шаблон для форматирования даты -->
    <xsl:template name="formatDateTime">
        <xsl:param name="dateTime"/>
        <xsl:if test="$dateTime">
            <xsl:value-of select="concat(substring($dateTime, 1, 10), ' ', substring($dateTime, 12, 8))"/>
        </xsl:if>
    </xsl:template>
    
    <!-- Универсальный шаблон для получения значения элемента -->
    <xsl:template name="getValue">
        <xsl:param name="element"/>
        <xsl:value-of select="$element"/>
    </xsl:template>
    
</xsl:stylesheet>