<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ7 АФ7 sig ns1" version="1.0" xmlns:УТ7="http://пф.рф/УТ/2023-04-03" xmlns:АФ7="http://пф.рф/АФ/2023-04-03" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/УОРР/2024-01-01">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/УнифТипы_2023-04-03.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УОРР"/>
		<div class="afWrap">
			<h1 class="afHeader afCenter">Уведомление о результате рассмотрения</h1>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Настоящим уведомляем</div>
				<div class="afMarginLeft200 afUnderlinedBlock"/>
				<p class="afInterval"/>
				<div class="afUnderlinedBlock afWordBreak afValue">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/УТ7:НаименованиеКраткое">
							<xsl:value-of select="$vForm/ns1:Страхователь/УТ7:НаименованиеКраткое"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/УТ7:ФИО">
							<xsl:value-of select="$vForm/ns1:Страхователь/УТ7:ФИО"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">регистрационный номер страхователя</div>
				<div class="afCol-6-10 afUnderlinedBlock afValue">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ7:РегНомер"/>
				</div>
				<div>, что</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afUnderlinedBlock afValue">
					<xsl:value-of select="$vForm/ns1:Документ/ns1:НаименованиеДокумента"/>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">№</div>
				<div class="afCol-1-4 afUnderlinedBlock afValue">
					<xsl:value-of select="$vForm/ns1:Документ/ns1:РегистрационныйНомерОбращения"/>
				</div>
				<div class="afFloatLeft">от</div>
				<div class="afCol-1-4 afUnderlinedBlock afValue">
					<xsl:value-of select="$vForm/ns1:Документ/ns1:ДатаРегистрацииОбращения"/>
				</div>
				<div>года рассмотрено Фондом пенсионного и социального страхования</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div>Российской Федерации.</div>
			</div>
			<p class="afInterval"/>
			<p class="afParagraph">По результату рассмотрения принято решение:</p>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-10">
					<div class="afCheck afC">
						<xsl:if test="$vForm/ns1:СведенияОРезультатеРассмотрения/ns1:РезультатРассмотрения[text() = '1']">V</xsl:if>
					</div>
				</div>
				<div class="afCol-9-10">в удовлетворении заявления (уведомления).</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-10">
					<div class="afCheck afC">
						<xsl:if test="$vForm/ns1:СведенияОРезультатеРассмотрения/ns1:РезультатРассмотрения[text() = '2']">V</xsl:if>
					</div>
				</div>
				<div class="afCol-9-10">об отказе в удовлетворении заявления (уведомления) по следующей причине:</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Код причины отказа:&#160;</div>
				<div class="afCol-1-4 afUnderlinedBlock afValue">
					<xsl:value-of select="$vForm/ns1:СведенияОРезультатеРассмотрения/ns1:КодПричиныОтказа"/>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Причина отказа:&#160;</div>
				<div class="afMarginLeft150 afUnderlinedBlock afValue">
					<xsl:value-of select="$vForm/ns1:СведенияОРезультатеРассмотрения/ns1:ПричинаОтказа"/>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Дата и время уведомления:&#160;</div>
				<div class="afCol-1-4 afUnderlinedBlock afValue">
					<xsl:variable name="dateTimeText" select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/АФ7:ДатаВремя"/>
					<xsl:value-of select="concat(substring($dateTimeText, 1, 10), ' ', substring($dateTimeText, 12, 5))"/>
				</div>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
					</xsl:call-template>
				</xsl:if>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
