<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="1.0">
           
    <xsl:template name="PrintSignInfo">
        <xsl:param name="pSignature"/>
        <table>
			<tr>
				<td class="afTable60"/>
				<td>
					<xsl:choose>
						<xsl:when test="$pSignature">
							<xsl:variable name="dateStartText" select="$pSignature/sig:CertValid/sig:From"/>
							<xsl:variable name="dateEndText" select="$pSignature/sig:CertValid/sig:To"/> 
							<div class="afSignature">
								<p>Документ подписан <br/>
									усиленной квалифицированной электронной <br/>
									подписью. </p>
								
								<xsl:if test="$pSignature/sig:Name">
									Организация: <xsl:value-of select="$pSignature/sig:Name"/> <br/>    
								</xsl:if>
								Сертификат: <xsl:value-of select="$pSignature/sig:CertID"/> <br/>
								 <xsl:if test="$pSignature/sig:Owner">
									Кому выдан: <xsl:if test="$pSignature/sig:Owner/sig:Surname">
										<xsl:value-of select="$pSignature/sig:Owner/sig:Surname"/>&#160;</xsl:if>
									<xsl:if test="$pSignature/sig:Owner/sig:Name">
										<xsl:value-of select="$pSignature/sig:Owner/sig:Name"/>&#160;</xsl:if>
									<xsl:if test="$pSignature/sig:Owner/sig:Patronymic">
										<xsl:value-of select="$pSignature/sig:Owner/sig:Patronymic"/>
									</xsl:if> <br/>
								</xsl:if>
								Издатель: <xsl:value-of select="$pSignature/sig:Issuer"/> <br/>
								Действителен: c <xsl:value-of select="concat(substring($dateStartText, 9, 2), '.', substring($dateStartText, 6, 2), '.', substring($dateStartText, 1, 4))"/> по <xsl:value-of select="concat(substring($dateEndText, 9, 2), '.', substring($dateEndText, 6, 2), '.', substring($dateEndText, 1, 4))"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afSignature">
								<p>Документ подписан <br/>
									усиленной квалифицированной электронной <br/>
									подписью. </p>
								Организация: МИЦ СФР <br/>
								Сертификат: 01d727b2de9d945000000000298e0001<br/>
								Кому выдан: Тестов Тест Тестович<br/>
								Издатель: СФР<br/>
								Действителен: с 02.07.2024 по 10.01.2026
							</div>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
    </xsl:template>
    
</xsl:stylesheet>
