<?xml version='1.0' encoding="UTF-8"?>
<!--Базовые (атомарные) шаблоны для форматирования вывода значений элементов, не зависящие от пространства имен-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- =================================================== ТИПЫ СВЯЗАННЫЕ С ДАТОЙ =================================================== -->
	<!-- Дата в формате 17 декабря 2018-->
	<xsl:template name="Date2Text">
		<xsl:param name="pDate"/>
		<!-- Если равно 1 и дата пустая, то "пустое" значение принимает вид "  "           -->
		<!-- Если равно 0 и дата пустая, то "пустое" значение принимает вид "  "    20     -->
		<xsl:param name="pNo2000YearWhenEmpty" select="0"/>
        <xsl:param name="style" select="''"/>
		<xsl:param name="plain"/>
		<xsl:choose>
			<!--Если дата пустая, то выводим "пустое" значение-->
			<xsl:when test="translate($pDate, ' ', '') = ''">
				<xsl:choose>
					<xsl:when test="$pNo2000YearWhenEmpty = '1'">
                        <span class="{$style}">&quot;&#160;&#160;&#160;&#160;&#160;&quot;</span>
                        <span class="{$style}">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</span>
                        <span class="{$style}">&#160;&#160;&#160;&#160;&#160;&#160;&#160;</span>	
					</xsl:when>
					<xsl:otherwise>
                        <span class="{$style}">&quot;&#160;&#160;&#160;&#160;&#160;&quot;</span>
                        <span class="{$style}">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</span>
                        <span class="{$style}">20&#160;&#160;&#160;&#160;&#160;</span>	
					</xsl:otherwise>
				</xsl:choose>				
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="dateText" select="string($pDate)"/>
				<xsl:variable name="month" select="substring($dateText, 6, 2)"/>
				<xsl:choose>
					<xsl:when test="$plain = '1'">
						<span class="{$style}"><xsl:value-of select="substring($dateText, 9, 2)"/></span>
					</xsl:when>
					<xsl:otherwise>
						<span class="{$style}"><xsl:value-of select="concat('&quot;', substring($dateText, 9, 2), '&quot;')"/></span>
					</xsl:otherwise>
				</xsl:choose>
				
                <span class="{$style}">
                    <xsl:choose>
                        <xsl:when test="$month = '01'"> января </xsl:when>
                        <xsl:when test="$month = '02'"> февраля </xsl:when>
                        <xsl:when test="$month = '03'"> марта </xsl:when>
                        <xsl:when test="$month = '04'"> апреля </xsl:when>
                        <xsl:when test="$month = '05'"> мая </xsl:when>
                        <xsl:when test="$month = '06'"> июня </xsl:when>
                        <xsl:when test="$month = '07'"> июля </xsl:when>
                        <xsl:when test="$month = '08'"> августа </xsl:when>
                        <xsl:when test="$month = '09'"> сентября </xsl:when>
                        <xsl:when test="$month = '10'"> октября </xsl:when>
                        <xsl:when test="$month = '11'"> ноября </xsl:when>
                        <xsl:when test="$month = '12'"> декабря </xsl:when>
                    </xsl:choose>
                </span>
                <span class="{$style}">
                    <xsl:value-of select="substring($dateText, 1, 4)"/>
                </span>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Дата в формате 17.12.2018 по ГОСТ Р 6.30-2003 -->
	<xsl:template name="Date2GOST">
		<xsl:param name="pDate"/>
		<!-- Если равно 1, то значение выводится без подчеркивания, включая до и после -->
		<xsl:param name="pNoUnderline" select="0"/>
		<!-- Если равно 1, то значение (в случае присутствия) выводится без неразрывных пробелов, включая до и после -->
		<xsl:param name="pNoUnbreakSpaces" select="0"/>
		<xsl:choose>
			<xsl:when test="$pDate = '' or not($pDate)"> &#160; </xsl:when>
			<xsl:otherwise>
				<xsl:variable name="dateText" select="string($pDate)"/>
				<xsl:choose>
					<xsl:when test="$pNoUnderline = '1'">
						<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$pNoUnbreakSpaces">
								<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat('&#160;&#160;', substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4), '&#160;&#160;')"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Название месяца по его номеру -->
	<xsl:template name="Month2Text">
		<xsl:param name="pMonth"/>
		<xsl:param name="pCapital"/>
		<xsl:choose>
			<xsl:when test="$pCapital = 1">
				<xsl:choose>
					<xsl:when test="$pMonth = '01' or $pMonth = '1'">Январь</xsl:when>
					<xsl:when test="$pMonth = '02' or $pMonth = '2'">Февраль</xsl:when>
					<xsl:when test="$pMonth = '03' or $pMonth = '3'">Март</xsl:when>
					<xsl:when test="$pMonth = '04' or $pMonth = '4'">Апрель</xsl:when>
					<xsl:when test="$pMonth = '05' or $pMonth = '5'">Май</xsl:when>
					<xsl:when test="$pMonth = '06' or $pMonth = '6'">Июнь</xsl:when>
					<xsl:when test="$pMonth = '07' or $pMonth = '7'">Июль</xsl:when>
					<xsl:when test="$pMonth = '08' or $pMonth = '8'">Август</xsl:when>
					<xsl:when test="$pMonth = '09' or $pMonth = '9'">Сентябрь</xsl:when>
					<xsl:when test="$pMonth = '10'">Октябрь</xsl:when>
					<xsl:when test="$pMonth = '11'">Ноябрь</xsl:when>
					<xsl:when test="$pMonth = '12'">Декабрь</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$pMonth = '01' or $pMonth = '1'">январь</xsl:when>
					<xsl:when test="$pMonth = '02' or $pMonth = '2'">февраль</xsl:when>
					<xsl:when test="$pMonth = '03' or $pMonth = '3'">март</xsl:when>
					<xsl:when test="$pMonth = '04' or $pMonth = '4'">апрель</xsl:when>
					<xsl:when test="$pMonth = '05' or $pMonth = '5'">май</xsl:when>
					<xsl:when test="$pMonth = '06' or $pMonth = '6'">июнь</xsl:when>
					<xsl:when test="$pMonth = '07' or $pMonth = '7'">июль</xsl:when>
					<xsl:when test="$pMonth = '08' or $pMonth = '8'">август</xsl:when>
					<xsl:when test="$pMonth = '09' or $pMonth = '9'">сентябрь</xsl:when>
					<xsl:when test="$pMonth = '10'">октябрь</xsl:when>
					<xsl:when test="$pMonth = '11'">ноябрь</xsl:when>
					<xsl:when test="$pMonth = '12'">декабрь</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	
	<!-- Название месяца по его номеру вариант2 -->
	<xsl:template name="Month2TextNumbers">
		<xsl:param name="pMonth"/>
		<xsl:choose>
			<xsl:when test="$pMonth = 1">январь</xsl:when>
			<xsl:when test="$pMonth = 2">февраль</xsl:when>
			<xsl:when test="$pMonth = 3">март</xsl:when>
			<xsl:when test="$pMonth = 4">апрель</xsl:when>
			<xsl:when test="$pMonth = 5">май</xsl:when>
			<xsl:when test="$pMonth = 6">июнь</xsl:when>
			<xsl:when test="$pMonth = 7">июль</xsl:when>
			<xsl:when test="$pMonth = 8">август</xsl:when>
			<xsl:when test="$pMonth = 9">сентябрь</xsl:when>
			<xsl:when test="$pMonth = 10">октябрь</xsl:when>
			<xsl:when test="$pMonth = 11">ноябрь</xsl:when>
			<xsl:when test="$pMonth = 12">декабрь</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Название месяца по его номеру -->
	<xsl:template name="Month2Text3">
		<xsl:param name="pMonth"/>
		<xsl:choose>
			<xsl:when test="$pMonth = '01' or $pMonth = '1'">января</xsl:when>
			<xsl:when test="$pMonth = '02' or $pMonth = '2'">февраля</xsl:when>
			<xsl:when test="$pMonth = '03' or $pMonth = '3'">марта</xsl:when>
			<xsl:when test="$pMonth = '04' or $pMonth = '4'">апреля</xsl:when>
			<xsl:when test="$pMonth = '05' or $pMonth = '5'">мая</xsl:when>
			<xsl:when test="$pMonth = '06' or $pMonth = '6'">июня</xsl:when>
			<xsl:when test="$pMonth = '07' or $pMonth = '7'">июля</xsl:when>
			<xsl:when test="$pMonth = '08' or $pMonth = '8'">августа</xsl:when>
			<xsl:when test="$pMonth = '09' or $pMonth = '9'">сентября</xsl:when>
			<xsl:when test="$pMonth = '10'">октября</xsl:when>
			<xsl:when test="$pMonth = '11'">ноября</xsl:when>
			<xsl:when test="$pMonth = '12'">декабря</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Месяц в формате ## -->
	<xsl:template name="Month2">
		<xsl:param name="pMonth"/>
		<xsl:choose>
			<xsl:when test="$pMonth = '01' or $pMonth = '1'">01</xsl:when>
			<xsl:when test="$pMonth = '02' or $pMonth = '2'">02</xsl:when>
			<xsl:when test="$pMonth = '03' or $pMonth = '3'">03</xsl:when>
			<xsl:when test="$pMonth = '04' or $pMonth = '4'">04</xsl:when>
			<xsl:when test="$pMonth = '05' or $pMonth = '5'">05</xsl:when>
			<xsl:when test="$pMonth = '06' or $pMonth = '6'">06</xsl:when>
			<xsl:when test="$pMonth = '07' or $pMonth = '7'">07</xsl:when>
			<xsl:when test="$pMonth = '08' or $pMonth = '8'">08</xsl:when>
			<xsl:when test="$pMonth = '09' or $pMonth = '9'">09</xsl:when>
			<xsl:when test="$pMonth = '10'">10</xsl:when>
			<xsl:when test="$pMonth = '11'">11</xsl:when>
			<xsl:when test="$pMonth = '12'">12</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--Дата время в строку по формату 2018-11-30 14:00:00-05:00-->
	<xsl:template name="DateTime2Text">
		<xsl:param name="pDTime"/>
		<xsl:value-of select="translate($pDTime, 'T', ' ')"/>
	</xsl:template>
	<xsl:template name="DateTime2GOST">
		<xsl:param name="pDateTime"/>
		<xsl:call-template name="Date2GOST">
			<xsl:with-param name="pDate" select="$pDateTime"/>
			<xsl:with-param name="pNoUnbreakSpaces" select="1"/>
		</xsl:call-template>&#160;
		<xsl:value-of select="substring($pDateTime, 12)"/>
	</xsl:template>
	<!-- ======================================================== ТИП - ДЕНЬГИ =======================================================  -->
	<!-- Сумма в формате  100 руб. 05 коп. -->
	<xsl:template name="Sum2RubKop">
		<xsl:param name="pSum"/>
		<!-- Если равно 1, то при отсутствии значения не выводить пустое ___ руб. ___коп -->
		<xsl:param name="pNoBlank" select="0"/>

		<xsl:choose>
			<!-- значения нет и пустые поля выводить не надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank = '1'"/>
			<!-- значения нет, но пустые поля выводить надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank != '1'">
				<span class="afValue afUnderline"> &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; </span> руб. <span class="afValue afUnderline"> &#160;&#160;&#160;&#160;&#160;
				</span> коп. </xsl:when>
			<xsl:when test="not(contains($pSum, '.'))">
				<span class="afValue afUnderline"> &#160;&#160;&#160;<xsl:value-of select="translate(format-number($pSum, '###,###,###,##0'), ',', ' ')"/>&#160;&#160; </span> руб. <span
					class="afValue afUnderline"> &#160;&#160;&#160;00&#160;&#160; </span> коп.
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="integerPart" select="floor($pSum)"/>
				<xsl:variable name="fraction" select="($pSum * 100 - $integerPart*100)"/>
<!--	
				<xsl:variable name="integerPart">
					<xsl:value-of select="substring-before($pSum, '.')"/>
				</xsl:variable>
				<xsl:variable name="fraction">
					<xsl:value-of select="substring-after($pSum, '.')"/>
				</xsl:variable>
-->					
				<span class="afValue afUnderline"> &#160;&#160;&#160;<xsl:value-of select="translate(format-number($integerPart, '###,###,###,##0'), ',', ' ')"/>&#160;&#160; </span> руб. <span
					class="afValue afUnderline"> &#160;&#160;&#160;<xsl:value-of select="format-number($fraction, '00')"/>&#160;&#160; </span> коп.</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	
	<!-- Сумма в формате  100 руб. 05 коп. без подчеркивания -->
	<xsl:template name="Sum2RubKopScript">
		<xsl:param name="pSum"/>
		<!-- Если равно 1, то при отсутствии значения не выводить пустое ___ рублей ___копеек -->
		<xsl:param name="pNoBlank" select="0"/>
		<xsl:variable name="vRub" select="floor($pSum)"/>
		<xsl:variable name="vKop" select="($pSum * 100 - $vRub*100)"/>
		
			<xsl:choose>
				<xsl:when test="$vRub mod 10 = 1">
					<span class="afValue"><xsl:value-of select="translate(format-number($vRub, '###,###,###,##0'), ',', '&#160;')"/></span>&#160;рубль&#160;<xsl:choose>
						<xsl:when test="$vKop mod 10 > 4 or $vKop mod 10 = 0 or $vKop = 11">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копеек</xsl:when>
						<xsl:when test="($vKop mod 10) > 1 and ($vKop mod 10) &lt; 5">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копейки</xsl:when>
						<xsl:when test="$vKop mod 10 = 1">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копейка</xsl:when>
					</xsl:choose>		
				</xsl:when>
				
				<xsl:when test="$vRub mod 10 > 1 and $vRub mod 10 &lt; 5">
					<span class="afValue"><xsl:value-of select="translate(format-number($vRub, '###,###,###,##0'), ',', '&#160;')"/></span>&#160;рубля&#160;<xsl:choose>
						<xsl:when test="$vKop mod 10 > 4 or $vKop mod 10 = 0 or $vKop = 11">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копеек</xsl:when>
						<xsl:when test="($vKop mod 10) > 1 and ($vKop mod 10) &lt; 5">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копейки</xsl:when>
						<xsl:when test="$vKop mod 10 = 1">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копейка</xsl:when>
					</xsl:choose>	
				</xsl:when>
				
				<xsl:when test="$vRub mod 10 > 4 or $vRub mod 10 = 0">
					<span class="afValue"><xsl:value-of select="translate(format-number($vRub, '###,###,###,##0'), ',', '&#160;')"/></span>рублей&#160;<xsl:choose>
						<xsl:when test="$vKop mod 10 > 4 or $vKop mod 10 = 0 or $vKop = 11">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копеек</xsl:when>
						<xsl:when test="($vKop mod 10) > 1 and ($vKop mod 10) &lt; 5">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копейки</xsl:when>
						<xsl:when test="$vKop mod 10 = 1">
							<span class="afValue"><xsl:value-of select="translate(format-number($vKop, '00'), ',', '&#160;')"/></span>копейка</xsl:when>
					</xsl:choose>		
				</xsl:when>
			</xsl:choose>
	</xsl:template>
	<!-- Сумма в формате  100 руб. 05 коп. без подчеркивания -->
	<xsl:template name="Sum2RubKopNoBoldUnderline">
		<xsl:param name="pSum"/>
		<!-- Если равно 1, то при отсутствии значения не выводить пустое ___ руб. ___коп -->
		<xsl:param name="pNoBlank" select="0"/>
		
		<xsl:choose>
			<!-- значения нет и пустые поля выводить не надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank = '1'"/>
			<!-- значения нет, но пустые поля выводить надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank != '1'">
				<span> </span>&#160;руб.&#160;<span> </span>&#160;коп.</xsl:when>
			<xsl:when test="not(contains($pSum, '.'))">
				<span > <xsl:value-of select="$pSum"/> </span>&#160;руб.&#160;<span>00</span>&#160;коп.
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="integerPart" select="floor($pSum)"/>
				<xsl:variable name="fraction" select="($pSum * 100 - $integerPart*100)"/>
<!--
				<xsl:variable name="integerPart">
					<xsl:value-of select="substring-before($pSum, '.')"/>
				</xsl:variable>
				<xsl:variable name="fraction">
					<xsl:value-of select="substring-after($pSum, '.')"/>
				</xsl:variable>
-->			
				<span> <xsl:value-of select="$integerPart"/> </span>&#160;руб.&#160;<span><xsl:value-of select="format-number($fraction, '00')"/> </span>&#160;коп.</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>

	<xsl:template name="Sum2RubKopNoUnderline">
		<xsl:param name="pSum"/>
		<!-- Если равно 1, то при отсутствии значения не выводить пустое ___ руб. ___коп -->
		<xsl:param name="pNoBlank" select="0"/>
		
		<xsl:choose>
			<!-- значения нет и пустые поля выводить не надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank = '1'"/>
			<!-- значения нет, но пустые поля выводить надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank != '1'">
				<span class="afValue"> </span>руб.<span class="afValue"> </span>коп.</xsl:when>
			<!-- значения есть, но нет дробной части -->
			<xsl:when test="not(contains($pSum, '.'))">
				<span class="afValue"> <xsl:value-of select="translate(format-number($pSum, '###,###,###,##0'), ',', ' ')"/> </span>руб.<span 
					class="afValue">00</span>коп.
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="integerPart">
					<xsl:choose>
						<xsl:when test="$pSum > 0">
							<xsl:value-of select="floor($pSum)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="ceiling($pSum)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:variable name="fraction" select="substring-after($pSum, '.')"/>
				
				<span class="afValue"><xsl:value-of select="translate(format-number($integerPart, '###,###,###,##0'), ',', ' ')"/> </span>руб.<span
					class="afValue"> <xsl:value-of select="format-number($fraction, '00')"/> </span>коп.</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	<xsl:template name="Percent">
		<xsl:param name="pPRC"/>
			<xsl:variable name="integerPart" select="floor($pPRC)"/>
			<xsl:variable name="fraction" select="($pPRC * 100 - $integerPart*100)"/>
			<xsl:choose>
				<xsl:when test="$fraction = 0">
					<span class="afValue"> <xsl:value-of select="format-number($integerPart, '#0')"/> </span>
				</xsl:when>
				<xsl:otherwise>
					<span class="afValue"> <xsl:value-of select="$pPRC"/> </span>
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	<xsl:template name="Rub">
		<xsl:param name="pSum"/>
		<xsl:variable name="integerPart" select="floor($pSum)"/>
		<xsl:value-of select="translate(format-number($integerPart, '###,###,###,##0'), ',', ' ')"/>
	</xsl:template>
	<xsl:template name="Kop">
		<xsl:param name="pSum"/>
		<xsl:variable name="integerPart" select="floor($pSum)"/>
		<xsl:variable name="fraction" select="($pSum * 100 - $integerPart*100)"/>
		<xsl:value-of select="format-number($fraction, '00')"/>
	</xsl:template>
	<!-- ======================================================== ТИП - СТРОКА =======================================================  -->
	<!-- Номер телефона из числового представления без пробелов в строку с разделителями -->
	<xsl:template name="Phone2Text">
		<xsl:param name="pNumber"/>
		<xsl:if test="$pNumber">
			<xsl:choose>
				<xsl:when test="string-length($pNumber) = 5">
					<xsl:value-of select="concat(substring($pNumber, 1, 1), '-', substring($pNumber, 2, 2), '-', substring($pNumber, 4, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 6">
					<xsl:value-of select="concat(substring($pNumber, 1, 2), '-', substring($pNumber, 3, 2), '-', substring($pNumber, 5, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 7">
					<xsl:value-of select="concat(substring($pNumber, 1, 3), '-', substring($pNumber, 4, 2), '-', substring($pNumber, 6, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 10">
					<xsl:value-of select="concat('(', substring($pNumber, 1, 3), ') ', substring($pNumber, 4, 3), '-', substring($pNumber, 7, 2), '-', substring($pNumber, 9, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 11">
					<xsl:value-of
						select="concat(substring($pNumber, 1, 1), ' (', substring($pNumber, 2, 3), ') ', substring($pNumber, 5, 3), '-', substring($pNumber, 8, 2), '-', substring($pNumber, 10, 2))"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pNumber"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- Склонение месяца от количества -->
	<xsl:template name="Месяц">
		<xsl:param name="pMonth"/>
		<xsl:choose>
			<xsl:when test="number($pMonth) = 1">месяц</xsl:when>
			<xsl:when test="number($pMonth) &gt; 1 and (number($pMonth) &lt; 5)">месяца</xsl:when>
			<xsl:when test="number($pMonth) &gt; 4 ">месяцев</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Год">
		<xsl:param name="pYear"/>
		<xsl:choose>
			<xsl:when test="number($pYear) = 1">год</xsl:when>
			<xsl:when test="number($pYear) &gt; 1 and number($pYear) &lt; 5">года</xsl:when>
			<xsl:when test="number($pYear) &gt; 4 and number($pYear) &lt; 21">лет</xsl:when>
			<xsl:when test="number($pYear) = 21">год</xsl:when>
			<xsl:when test="number($pYear) &gt; 21 and number($pYear) &lt; 25">года</xsl:when>
			<xsl:when test="number($pYear) &gt; 24 and number($pYear) &lt; 31">лет</xsl:when>
			<xsl:when test="number($pYear) = 31">год</xsl:when>
			<xsl:when test="number($pYear) &gt; 31 and number($pYear) &lt; 35">года</xsl:when>
			<xsl:when test="number($pYear) &gt; 34 and number($pYear) &lt; 41">лет</xsl:when>
			<xsl:when test="number($pYear) = 41">год</xsl:when>
			<xsl:when test="number($pYear) &gt; 41 and number($pYear) &lt; 45">года</xsl:when>
			<xsl:when test="number($pYear) &gt; 44 and number($pYear) &lt; 51">лет</xsl:when>
			<xsl:when test="number($pYear) = 51">год</xsl:when>
			<xsl:when test="number($pYear) &gt; 51 and number($pYear) &lt; 55">года</xsl:when>
			<xsl:when test="number($pYear) &gt; 54 and number($pYear) &lt; 61">лет</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
		В основном преобразовании будут доступны переменные lowercase и uppercase, которые можно будет использовать в функции translate и шаблоны с именами lower и upper.

	Использовать функцию translate с переменными lowercase и uppercase можно следующим образом:


		translate('Дом', $uppercase, $lowercase) ? 'дом'
		translate('Дом', $lowercase, $uppercase) ? 'ДОМ'
	Именованные шаблоны можно вызывать элементом xsl:call-template, передавая параметр при помощи xsl:with-param. Например, следующий фрагмент шаблона
		<xsl:call-template name="lower">
		  <xsl:with-param name="str" select="'Дом'" />
		</xsl:call-template>
	создаст в выходящем дереве текстовый узел со значением "дом".
	-->
	<xsl:variable name="uppercase" select="concat('АБВГ', 'ДЕЁЖЗ', 'ИЙКЛ', 'МНОП', 'РСТУ', 'ФХЦЧ', 'ШЩЪЫ', 'ЬЭЮЯ')"/>
	<xsl:variable name="lowercase" select="concat('абвг', 'деёжз', 'ийкл', 'мноп', 'рсту', 'фхцч', 'шщъы', 'ьэюя')"/>
	<xsl:template name="lower">
		<xsl:param name="str"/>
		<xsl:value-of select="translate($str, $uppercase, $lowercase)"/>
	</xsl:template>
	<xsl:template name="upper">
		<xsl:param name="str"/>
		<xsl:value-of select="translate($str, $lowercase, $uppercase)"/>
	</xsl:template>
	<!-- Шаблоны для перевода 1 буквы строки в верхний или нижний регистр -->
	<xsl:template name="fLUP">
		<xsl:param name="str" />
		<xsl:value-of select="concat(translate(substring($str,1,1), $lowercase, $uppercase), translate(substring($str,2), $uppercase, $lowercase))"/>
	 </xsl:template>
	 <xsl:template name="fLLW">
		<xsl:param name="str" />
		<xsl:value-of select="concat(translate(substring($str,1,1), $uppercase, $lowercase), translate(substring($str,2), $uppercase, $lowercase))"/>
	 </xsl:template>
</xsl:stylesheet>
