<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="1.0">
    <!-- Тип категории -->
    <xsl:template name="CategoryStr">
        <xsl:param name="pCategoryType"/>
        <xsl:choose>
			 <xsl:when test="$pCategoryType = 1">Герой Советского Союза (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 2">Герой Российской Федерации (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 3">Полный кавалер ордена Славы (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 4">Член семьи умершего (погибшего) Героя Советского Союза, Героя Российской Федерации или полного кавалера ордена Славы (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 5">Герой Социалистического Труда (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 6">Полный кавалер ордена Трудовой Славы (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 7">Герой Труда Российской Федерации (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 10">Инвалиды войны (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 11">Участники Великой Отечественной войны, ставшие инвалидами (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 12">Военнослужащие и лица рядового и начальствующего состава органов внутренних дел, Государственной противопожарной службы, учреждений и органов уголовно-исполнительной системы, ставших инвалидами вследствие ранения, контузии или увечья, полученных при исполнении обязанностей военной службы (служебных обязанностей) (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 20">Участники Великой Отечественной войны (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 30">Ветераны боевых действий из числа лиц, указанных в пп.1-4 п. 1 ст. 3 Федерального закона от 12.01.1995 № 5-ФЗ «О ветеранах» (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 40">Военнослужащие, проходившие военную службу в воинских частях, учреждениях, военно-учебных заведениях, не входивших в состав действующей армии, в период с 22 июня 1941 года по 3 сентября 1945 года не менее шести месяцев, военнослужащие, награжденные орденами или медалями СССР за службу в указанный период (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 50">Лица, награжденные знаком «Жителю блокадного Ленинграда» (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 60">Члены семей погибших (умерших) инвалидов войны, участников Великой Отечественной войны и ветеранов боевых действий (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 61">Члены семей погибших в Великой Отечественной войне лиц из числа личного состава групп самозащиты объектовых и аварийных команд местной противовоздушной обороны, а также члены семей погибших работников госпиталей и больниц города Ленинграда (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 62">Члены семей военнослужащих, лиц рядового и начальствующего состава органов внутренних дел, Государственной противопожарной службы, учреждений и органов уголовно-исполнительной системы и органов государственной безопасности, погибших при исполнении обязанностей военной службы (служебных обязанностей) (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 63">Члены семей военнослужащих, погибших в плену, признанных в установленном порядке пропавшими без вести в районах боевых действий, со времени исключения указанных военнослужащих из списков воинских частей (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 64">Родители и жены погибших военнослужащих погибших вследствие ранения, контузии или увечья, полученных при защите СССР или при исполнении обязанностей военной службы, либо вследствие заболевания, связанного с пребыванием на фронте (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 81">Инвалиды III группы (п. 1, ст. 28.1 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 82">Инвалиды II группы (п. 1, ст. 28.1 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 83">Инвалиды I группы (п. 1, ст. 28.1 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 84">Дети-инвалиды (п. 1, ст. 28.1 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 85">Инвалиды, не имеющие степень ограничения к трудовой деятельности (до 2009г) (п.1, ст.28 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 91">Граждане, получившие или перенесшие лучевую болезнь и другие заболевания, связанные с радиационным воздействием вследствие чернобыльской катастрофы или с работами по ликвидации последствий катастрофы на Чернобыльской АЭС (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 92">Инвалиды вследствие чернобыльской катастрофы (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 93">Граждане, принимавшие в 1986–1987 г. участие в работах по ликвидации последствий катастрофы на ЧАЭС, из числа лиц, указанных в пункте 3 части первой статьи 13 Закона Российской Федерации от 15.05.1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие катастрофы на Чернобыльской АЭС»  (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 94">Граждане, принимавшие участие в 1988-1990 г. участие в работах по ликвидации последствий катастрофы на ЧАЭС, из числа лиц, указанных в пункте 4 части первой ст. 13 Закона Российской Федерации от 15.05.1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие катастрофы на Чернобыльской АЭС» (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 95">Граждане, постоянно проживающие (работающие) на территории зоны проживания с правом на отселение (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 96">Граждане, постоянно проживающие (работающие) на территории зоны проживания с льготным социально-экономическим статусом (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 97">Граждане, постоянно проживающие (работающие) в зоне отселения до их переселения в другие районы (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 98">Граждане, эвакуированные (в том числе выехавшие добровольно) в 1986 году из зоны отчуждения  (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 99">Дети и подростки в возрасте до 18 лет, проживающие в зоне отселения и зоне с правом на  отселение, эвакуированные и переселенные из зон отчуждения, отселения, с правом на отселение, включая находившихся на день эвакуации во внутриутробном состоянии, дети первого и последующих поколений граждан, указанных в пунктах 1, 2, 3 и 6 части первой статьи 13 Закона РФ от 15.05.1991 № 1244-1, родившиеся после облучения вследствие катастрофы на ЧАЭС одного из родителей  (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
			<xsl:when test="$pCategoryType = 01">Герой Советского Союза (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 02">Герой Российской Федерации (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 03">Полный кавалер ордена Славы (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 04">Член семьи умершего (погибшего) Героя Советского Союза, Героя Российской Федерации или полного кавалера ордена Славы (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 05">Герой Социалистического Труда (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 06">Полный кавалер ордена Трудовой Славы (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 07">Герой Труда Российской Федерации (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>

            <xsl:when test="$pCategoryType = 001">Герой Советского Союза (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 002">Герой Российской Федерации (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 003">Полный кавалер ордена Славы (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 004">Член семьи умершего (погибшего) Героя Советского Союза, Героя Российской Федерации или полного кавалера ордена Славы (п. 1, ст. 9.1 Закона Российской Федерации от 15.01.1993 № 4301-1)</xsl:when>
            <xsl:when test="$pCategoryType = 005">Герой Социалистического Труда (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 006">Полный кавалер ордена Трудовой Славы (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 007">Герой Труда Российской Федерации (п. 1, ст. 6.2 Федерального закона от 09.01.1997 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 010">Инвалиды войны (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 011">Участники Великой Отечественной войны, ставшие инвалидами (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 012">Военнослужащие и лица рядового и начальствующего состава органов внутренних дел, Государственной противопожарной службы, учреждений и органов уголовно-исполнительной системы, ставших инвалидами вследствие ранения, контузии или увечья, полученных при исполнении обязанностей военной службы (служебных обязанностей) (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 020">Участники Великой Отечественной войны (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 030">Ветераны боевых действий из числа лиц, указанных в пп.1-4 п. 1 ст. 3 Федерального закона от 12.01.1995 № 5-ФЗ «О ветеранах» (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 040">Военнослужащие, проходившие военную службу в воинских частях, учреждениях, военно-учебных заведениях, не входивших в состав действующей армии, в период с 22 июня 1941 года по 3 сентября 1945 года не менее шести месяцев, военнослужащие, награжденные орденами или медалями СССР за службу в указанный период (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 050">Лица, награжденные знаком «Жителю блокадного Ленинграда» (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 060">Члены семей погибших (умерших) инвалидов войны, участников Великой Отечественной войны и ветеранов боевых действий (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 061">Члены семей погибших в Великой Отечественной войне лиц из числа личного состава групп самозащиты объектовых и аварийных команд местной противовоздушной обороны, а также члены семей погибших работников госпиталей и больниц города Ленинграда (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 062">Члены семей военнослужащих, лиц рядового и начальствующего состава органов внутренних дел, Государственной противопожарной службы, учреждений и органов уголовно-исполнительной системы и органов государственной безопасности, погибших при исполнении обязанностей военной службы (служебных обязанностей) (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 063">Члены семей военнослужащих, погибших в плену, признанных в установленном порядке пропавшими без вести в районах боевых действий, со времени исключения указанных военнослужащих из списков воинских частей (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 064">Родители и жены погибших военнослужащих погибших вследствие ранения, контузии или увечья, полученных при защите СССР или при исполнении обязанностей военной службы, либо вследствие заболевания, связанного с пребыванием на фронте (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 081">Инвалиды III группы (п. 1, ст. 28.1 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 082">Инвалиды II группы (п. 1, ст. 28.1 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 083">Инвалиды I группы (п. 1, ст. 28.1 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 084">Дети-инвалиды (п. 1, ст. 28.1 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 085">Инвалиды, не имеющие степень ограничения к трудовой деятельности (до 2009г) (п.1, ст.28 Федерального закона от 24.11.1995 № 181-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 091">Граждане, получившие или перенесшие лучевую болезнь и другие заболевания, связанные с радиационным воздействием вследствие чернобыльской катастрофы или с работами по ликвидации последствий катастрофы на Чернобыльской АЭС (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 092">Инвалиды вследствие чернобыльской катастрофы (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 093">Граждане, принимавшие в 1986–1987 г. участие в работах по ликвидации последствий катастрофы на ЧАЭС, из числа лиц, указанных в пункте 3 части первой статьи 13 Закона Российской Федерации от 15.05.1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие катастрофы на Чернобыльской АЭС»  (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 094">Граждане, принимавшие участие в 1988-1990 г. участие в работах по ликвидации последствий катастрофы на ЧАЭС, из числа лиц, указанных в пункте 4 части первой ст. 13 Закона Российской Федерации от 15.05.1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие катастрофы на Чернобыльской АЭС» (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 095">Граждане, постоянно проживающие (работающие) на территории зоны проживания с правом на отселение (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 096">Граждане, постоянно проживающие (работающие) на территории зоны проживания с льготным социально-экономическим статусом (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 097">Граждане, постоянно проживающие (работающие) в зоне отселения до их переселения в другие районы (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 098">Граждане, эвакуированные (в том числе выехавшие добровольно) в 1986 году из зоны отчуждения  (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 099">Дети и подростки в возрасте до 18 лет, проживающие в зоне отселения и зоне с правом на  отселение, эвакуированные и переселенные из зон отчуждения, отселения, с правом на отселение, включая находившихся на день эвакуации во внутриутробном состоянии, дети первого и последующих поколений граждан, указанных в пунктах 1, 2, 3 и 6 части первой статьи 13 Закона РФ от 15.05.1991 № 1244-1, родившиеся после облучения вследствие катастрофы на ЧАЭС одного из родителей  (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 100">Дети и подростки в возрасте до 18 лет, постоянно проживающие в зоне с льготным социально-экономическим статусом (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 101">Дети и подростки, страдающие болезнями вследствие чернобыльской катастрофы или обусловленными генетическими последствиями радиоактивного облучения одного из родителей, а также последующие поколения детей в случае развития у них заболеваний вследствие чернобыльской катастрофы или обусловленных генетическими последствиями радиоактивного облучения одного из родителей, ставшие инвалидами (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 102">Дети и подростки, страдающие болезнями вследствие чернобыльской катастрофы или обусловленными генетическими последствиями радиоактивного облучения одного из родителей, а также последующие поколения детей в случае развития у них заболеваний вследствие чернобыльской катастрофы или обусловленных генетическими последствиями радиоактивного облучения одного из родителей (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 111">Граждане, получившие суммарную (накопительную) эффективную дозу облучения, превышающую 25 сЗв (бэр) (ст. 4.1 Федерального закона от 10.01.2002 № 2-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 112">Граждане, получившие суммарную (накопительную) эффективную дозу облучения более 5 сЗв (бэр), но не превышающую 25 сЗв (бэр) (ст. 4.1 Федерального закона от 10.01.2002 № 2-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 113">Дети в возрасте до 18 лет первого и второго поколения граждан, получившие суммарную (накопительную) эффективную дозу облучения более 5 сЗв (бэр), страдающих заболеваниями вследствие радиационного воздействия на одного из родителей (ст. 4.1 Федерального закона от 10.01.2002 № 2-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 120">Лица, работавшие в период Великой Отечественной войны на объектах противовоздушной обороны, местной противовоздушной обороны, на  строительстве оборонительных сооружений, военно-морских баз, аэродромов и других военных объектов в пределах тыловых границ действующих фронтов, операционных зон действующих флотов, на прифронтовых участках железных и автомобильных дорог, а также члены экипажей судов транспортного флота, интернированных в начале Великой Отечественной войны в портах других государств   (п. 1, ст. 23.1 Федерального закона от 12.01.1995 № 5-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 121">Граждане, получившие лучевую болезнь, другие заболевания, включенные в перечень заболеваний, возникновение или обострение которых обусловлены воздействием радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча (ст. 1 Федерального закона от 26.11.1998 № 175-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 122">Граждане, ставшие инвалидами в результате воздействия радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча (ст. 1 Федерального закона от 26.11.1998 № 175-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 123">Граждане, принимавшие в 1957 – 1958 г. непосредственное участие в работах по ликвидации последствий аварии в 1957 г. на ПО «Маяк», из числа лиц, указанных в пункте 1 статьи 1 Федерального закона от 26.11.1998 № 175-ФЗ «О социальной защите граждан Российской Федерации, подвергшихся воздействию радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча» (ст. 1 Федерального закона от 26.11.1998 № 175-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 124">Граждане, принимавшие в 1959 – 1961 г. непосредственное участие в работах по ликвидации последствий аварии в 1957 г. на ПО «Маяк», из числа лиц, указанных в пункте 2 статьи 1 Федерального закона от 26.11.1998 № 175-ФЗ «О социальной защите граждан Российской Федерации, подвергшихся воздействию радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча» (ст. 1 Федерального закона от 26.11.1998 № 175-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 125">Граждане, проживающие в населенных пунктах, подвергшихся радиоактивному загрязнению вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча, где средняя годовая эффективная доза облучения составляет в настоящее время свыше 1 мЗв (0,1 бэр) (дополнительно над уровнем естественного радиационного фона для данной местности) (ст. 1 Федерального закона от 26.11.1998 № 175-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 126">Дети, не достигшие возраста 18 лет, проживающие в населенных пунктах, подвергшихся радиоактивному загрязнению вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча, где средняя годовая эффективная доза облучения составляет в настоящее время свыше 1 мЗв (0,1 бэр) (дополнительно над уровнем естественного радиационного фона для данной местности) (ст. 1 Федерального закона от 26.11.1998 № 175-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 128">Граждане, эвакуированные (переселенные), а также добровольно выехавшие из населенных пунктов, подвергшихся радиационному загрязнению вследствие аварии в 1957 г. на ПО «Маяк», из числа лиц, указанных в пункте 3 статьи 1 Федерального закона от 26.11.1998 № 175-ФЗ «О социальной защите граждан Российской Федерации, подвергшихся воздействию радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча» (ст. 1 Федерального закона от 26.11.1998 № 175-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 129">Дети первого и второго поколения граждан, указанных в статье 1 Федерального закона от 26.11.98 № 175-ФЗ, страдающие заболеваниями вследствие воздействия радиации на их родителей (ст. 1 Федерального закона от 26.11.1998 № 175-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 131">Граждане из подразделений особого риска, не имеющие инвалидности (п. 2 Постановления Верховного Совета Российской Федерации от 27.12.1991 № 2123-1)</xsl:when>
            <xsl:when test="$pCategoryType = 132">Граждане из подразделений особого риска, имеющие инвалидность (п. 2 Постановления Верховного Совета Российской Федерации от 27.12.1991 № 2123-1)</xsl:when>
            <xsl:when test="$pCategoryType = 140">Бывшие несовершеннолетние узники концлагерей, гетто, других мест принудительного содержания, созданных фашистами и их союзниками в период второй мировой войны, признанные инвалидами вследствие общего заболевания, трудового увечья и других причин (за исключением лиц, инвалидность которых наступила вследствие их противоправных действий) (п. 8, ст. 154 Федерального закона от 22.08.2004 № 122-ФЗ)</xsl:when>
            <xsl:when test="$pCategoryType = 141">Рабочие и служащие, а также военнослужащих, лица начальствующего и рядового состава органов внутренних дел, Государственной противопожарной службы, получившие профессиональные заболевания, связанные с лучевым воздействием на работах в зоне отчуждения (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 142">Рабочие и служащие, а также военнослужащие, лица начальствующего и рядового состава органов внутренних дел, Государственной противопожарной службы, получивших профессиональные заболевания, связанные с лучевым воздействием на работах в зоне отчуждения, ставшие инвалидами (п. 1, ст. 27.1 Закона Российской Федерации от 15.05.1991 № 1244-1)</xsl:when>
            <xsl:when test="$pCategoryType = 150">Бывшие несовершеннолетние узники концлагерей, гетто, других мест принудительного содержания, созданных фашистами и их союзниками в период второй мировой войны (п. 8, ст. 154 Федерального закона от 22.08.2004 № 122-ФЗ)</xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <!-- Тип категории без основания-->
    <xsl:template name="CategoryShortStr">
        <xsl:param name="pCategoryType"/>
        <xsl:choose>
            <xsl:when test="$pCategoryType = '001'">Герой Советского Союза</xsl:when>
            <xsl:when test="$pCategoryType = '002'">Герой Российской Федерации</xsl:when>
            <xsl:when test="$pCategoryType = '003'">Полный кавалер ордена Славы</xsl:when>
            <xsl:when test="$pCategoryType = '004'">Член семьи умершего (погибшего) Героя Советского Союза, Героя Российской Федерации или полного кавалера ордена Славы</xsl:when>
            <xsl:when test="$pCategoryType = '005'">Герой Социалистического Труда</xsl:when>
            <xsl:when test="$pCategoryType = '006'">Полный кавалер ордена Трудовой Славы</xsl:when>
            <xsl:when test="$pCategoryType = '007'">Герой Труда Российской Федерации</xsl:when>
            <xsl:when test="$pCategoryType = '010'">Инвалиды войны</xsl:when>
            <xsl:when test="$pCategoryType = '011'">Участники Великой Отечественной войны, ставшие инвалидами</xsl:when>
            <xsl:when test="$pCategoryType = '012'">Военнослужащие и лица рядового и начальствующего состава органов внутренних дел, Государственной противопожарной службы, учреждений и органов уголовно-исполнительной системы, ставших инвалидами вследствие ранения, контузии или увечья, полученных при исполнении обязанностей военной службы (служебных обязанностей)</xsl:when>
            <xsl:when test="$pCategoryType = '020'">Участники Великой Отечественной войны </xsl:when>
            <xsl:when test="$pCategoryType = '030'">Ветераны боевых действий из числа лиц, указанных в пп.1-4 п. 1 ст. 3 Федерального закона от 12.01.1995 № 5-ФЗ «О ветеранах» </xsl:when>
            <xsl:when test="$pCategoryType = '040'">Военнослужащие, проходившие военную службу в воинских частях, учреждениях, военно-учебных заведениях, не входивших в состав действующей армии, в период с 22 июня 1941 года по 3 сентября 1945 года не менее шести месяцев, военнослужащие, награжденные орденами или медалями СССР за службу в указанный период</xsl:when>
            <xsl:when test="$pCategoryType = '050'">Лица, награжденные знаком «Жителю блокадного Ленинграда»</xsl:when>
            <xsl:when test="$pCategoryType = '060'">Члены семей погибших (умерших) инвалидов войны, участников Великой Отечественной войны и ветеранов боевых действий</xsl:when>
            <xsl:when test="$pCategoryType = '061'">Члены семей погибших в Великой Отечественной войне лиц из числа личного состава групп самозащиты объектовых и аварийных команд местной противовоздушной обороны, а также члены семей погибших работников госпиталей и больниц города Ленинграда </xsl:when>
            <xsl:when test="$pCategoryType = '062'">Члены семей военнослужащих, лиц рядового и начальствующего состава органов внутренних дел, Государственной противопожарной службы, учреждений и органов уголовно-исполнительной системы и органов государственной безопасности, погибших при исполнении обязанностей военной службы (служебных обязанностей)</xsl:when>
            <xsl:when test="$pCategoryType = '063'">Члены семей военнослужащих, погибших в плену, признанных в установленном порядке пропавшими без вести в районах боевых действий, со времени исключения указанных военнослужащих из списков воинских частей</xsl:when>
            <xsl:when test="$pCategoryType = '064'">Родители и жены погибших военнослужащих погибших вследствие ранения, контузии или увечья, полученных при защите СССР или при исполнении обязанностей военной службы, либо вследствие заболевания, связанного с пребыванием на фронте</xsl:when>
            <xsl:when test="$pCategoryType = '081'">Инвалиды III группы</xsl:when>
            <xsl:when test="$pCategoryType = '082'">Инвалиды II группы</xsl:when>
            <xsl:when test="$pCategoryType = '083'">Инвалиды I группы</xsl:when>
            <xsl:when test="$pCategoryType = '084'">Дети-инвалиды</xsl:when>
            <xsl:when test="$pCategoryType = '085'">Инвалиды, не имеющие степень ограничения к трудовой деятельности (до 2009г)</xsl:when>
            <xsl:when test="$pCategoryType = '091'">Граждане, получившие или перенесшие лучевую болезнь и другие заболевания, связанные с радиационным воздействием вследствие чернобыльской катастрофы или с работами по ликвидации последствий катастрофы на Чернобыльской АЭС</xsl:when>
            <xsl:when test="$pCategoryType = '092'">Инвалиды вследствие чернобыльской катастрофы</xsl:when>
            <xsl:when test="$pCategoryType = '093'">Граждане, принимавшие в 1986–1987 г. участие в работах по ликвидации последствий катастрофы на ЧАЭС, из числа лиц, указанных в пункте 3 части первой статьи 13 Закона Российской Федерации от 15.05.1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие катастрофы на Чернобыльской АЭС»</xsl:when>
            <xsl:when test="$pCategoryType = '094'">Граждане, принимавшие участие в 1988-1990 г. участие в работах по ликвидации последствий катастрофы на ЧАЭС, из числа лиц, указанных в пункте 4 части первой ст. 13 Закона Российской Федерации от 15.05.1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие катастрофы на Чернобыльской АЭС»</xsl:when>
            <xsl:when test="$pCategoryType = '095'">Граждане, постоянно проживающие (работающие) на территории зоны проживания с правом на отселение</xsl:when>
            <xsl:when test="$pCategoryType = '096'">Граждане, постоянно проживающие (работающие) на территории зоны проживания с льготным социально-экономическим статусом</xsl:when>
            <xsl:when test="$pCategoryType = '097'">Граждане, постоянно проживающие (работающие) в зоне отселения до их переселения в другие районы</xsl:when>
            <xsl:when test="$pCategoryType = '098'">Граждане, эвакуированные (в том числе выехавшие добровольно) в 1986 году из зоны отчуждения</xsl:when>
            <xsl:when test="$pCategoryType = '099'">Дети и подростки в возрасте до 18 лет, проживающие в зоне отселения и зоне с правом на  отселение, эвакуированные и переселенные из зон отчуждения, отселения, с правом на отселение, включая находившихся на день эвакуации во внутриутробном состоянии, дети первого и последующих поколений граждан, указанных в пунктах 1, 2, 3 и 6 части первой статьи 13 Закона РФ от 15.05.1991 № 1244-1, родившиеся после облучения вследствие катастрофы на ЧАЭС одного из родителей</xsl:when>
            <xsl:when test="$pCategoryType = '100'">Дети и подростки в возрасте до 18 лет, постоянно проживающие в зоне с льготным социально-экономическим статусом</xsl:when>
            <xsl:when test="$pCategoryType = '101'">Дети и подростки, страдающие болезнями вследствие чернобыльской катастрофы или обусловленными генетическими последствиями радиоактивного облучения одного из родителей, а также последующие поколения детей в случае развития у них заболеваний вследствие чернобыльской катастрофы или обусловленных генетическими последствиями радиоактивного облучения одного из родителей, ставшие инвалидами</xsl:when>
            <xsl:when test="$pCategoryType = '102'">Дети и подростки, страдающие болезнями вследствие чернобыльской катастрофы или обусловленными генетическими последствиями радиоактивного облучения одного из родителей, а также последующие поколения детей в случае развития у них заболеваний вследствие чернобыльской катастрофы или обусловленных генетическими последствиями радиоактивного облучения одного из родителей</xsl:when>
            <xsl:when test="$pCategoryType = '111'">Граждане, получившие суммарную (накопительную) эффективную дозу облучения, превышающую 25 сЗв (бэр)</xsl:when>
            <xsl:when test="$pCategoryType = '112'">Граждане, получившие суммарную (накопительную) эффективную дозу облучения более 5 сЗв (бэр), но не превышающую 25 сЗв (бэр)</xsl:when>
            <xsl:when test="$pCategoryType = '113'">Дети в возрасте до 18 лет первого и второго поколения граждан, получившие суммарную (накопительную) эффективную дозу облучения более 5 сЗв (бэр), страдающих заболеваниями вследствие радиационного воздействия на одного из родителей</xsl:when>
            <xsl:when test="$pCategoryType = '120'">Лица, работавшие в период Великой Отечественной войны на объектах противовоздушной обороны, местной противовоздушной обороны, на  строительстве оборонительных сооружений, военно-морских баз, аэродромов и других военных объектов в пределах тыловых границ действующих фронтов, операционных зон действующих флотов, на прифронтовых участках железных и автомобильных дорог, а также члены экипажей судов транспортного флота, интернированных в начале Великой Отечественной войны в портах других государств</xsl:when>
            <xsl:when test="$pCategoryType = '121'">Граждане, получившие лучевую болезнь, другие заболевания, включенные в перечень заболеваний, возникновение или обострение которых обусловлены воздействием радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча</xsl:when>
            <xsl:when test="$pCategoryType = '122'">Граждане, ставшие инвалидами в результате воздействия радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча</xsl:when>
            <xsl:when test="$pCategoryType = '123'">Граждане, принимавшие в 1957 – 1958 г. непосредственное участие в работах по ликвидации последствий аварии в 1957 г. на ПО «Маяк», из числа лиц, указанных в пункте 1 статьи 1 Федерального закона от 26.11.1998 № 175-ФЗ «О социальной защите граждан Российской Федерации, подвергшихся воздействию радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча»</xsl:when>
            <xsl:when test="$pCategoryType = '124'">Граждане, принимавшие в 1959 – 1961 г. непосредственное участие в работах по ликвидации последствий аварии в 1957 г. на ПО «Маяк», из числа лиц, указанных в пункте 2 статьи 1 Федерального закона от 26.11.1998 № 175-ФЗ «О социальной защите граждан Российской Федерации, подвергшихся воздействию радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча»</xsl:when>
            <xsl:when test="$pCategoryType = '125'">Граждане, проживающие в населенных пунктах, подвергшихся радиоактивному загрязнению вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча, где средняя годовая эффективная доза облучения составляет в настоящее время свыше 1 мЗв (0,1 бэр) (дополнительно над уровнем естественного радиационного фона для данной местности)</xsl:when>
            <xsl:when test="$pCategoryType = '126'">Дети, не достигшие возраста 18 лет, проживающие в населенных пунктах, подвергшихся радиоактивному загрязнению вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча, где средняя годовая эффективная доза облучения составляет в настоящее время свыше 1 мЗв (0,1 бэр) (дополнительно над уровнем естественного радиационного фона для данной местности)</xsl:when>
            <xsl:when test="$pCategoryType = '128'">Граждане, эвакуированные (переселенные), а также добровольно выехавшие из населенных пунктов, подвергшихся радиационному загрязнению вследствие аварии в 1957 г. на ПО «Маяк», из числа лиц, указанных в пункте 3 статьи 1 Федерального закона от 26.11.1998 № 175-ФЗ «О социальной защите граждан Российской Федерации, подвергшихся воздействию радиации вследствие аварии в 1957 году на производственном объединении «Маяк» и сбросов радиоактивных отходов в реку Теча»</xsl:when>
            <xsl:when test="$pCategoryType = '129'">Дети первого и второго поколения граждан, указанных в статье 1 Федерального закона от 26.11.98 № 175-ФЗ, страдающие заболеваниями вследствие воздействия радиации на их родителей</xsl:when>
            <xsl:when test="$pCategoryType ='131'">Граждане из подразделений особого риска, не имеющие инвалидности</xsl:when>
            <xsl:when test="$pCategoryType = '132'">Граждане из подразделений особого риска, имеющие инвалидность</xsl:when>
            <xsl:when test="$pCategoryType = '140'">Бывшие несовершеннолетние узники концлагерей, гетто, других мест принудительного содержания, созданных фашистами и их союзниками в период второй мировой войны, признанные инвалидами вследствие общего заболевания, трудового увечья и других причин (за исключением лиц, инвалидность которых наступила вследствие их противоправных действий)</xsl:when>
            <xsl:when test="$pCategoryType = '141'">Рабочие и служащие, а также военнослужащих, лица начальствующего и рядового состава органов внутренних дел, Государственной противопожарной службы, получившие профессиональные заболевания, связанные с лучевым воздействием на работах в зоне отчуждения</xsl:when>
            <xsl:when test="$pCategoryType = '142'">Рабочие и служащие, а также военнослужащие, лица начальствующего и рядового состава органов внутренних дел, Государственной противопожарной службы, получивших профессиональные заболевания, связанные с лучевым воздействием на работах в зоне отчуждения, ставшие инвалидами</xsl:when>
            <xsl:when test="$pCategoryType = '150'">Бывшие несовершеннолетние узники концлагерей, гетто, других мест принудительного содержания, созданных фашистами и их союзниками в период второй мировой войны</xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="ReasonStr">
        <xsl:param name="pReason"/>
        <xsl:choose>
            <xsl:when test="$pReason = '1'">уменьшением количества членов семьи, имеющих право на льготы</xsl:when>
            <xsl:when test="$pReason = '2'">увеличением количества членов семьи, имеющих право на льготы</xsl:when>
        </xsl:choose>
    </xsl:template>
    
  </xsl:stylesheet>