<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs" version="1.0">
    <xsl:template name="PensStr">
        <xsl:param name="pPensType"/>
        <xsl:choose>
            <xsl:when test="$pPensType = '7'">по старости</xsl:when>
            <xsl:when test="$pPensType = '5'">по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '6'">по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '24'">доля страховой пенсии по старости</xsl:when>
            <xsl:when test="$pPensType = '20'">накопительная пенсия</xsl:when>
            <xsl:when test="$pPensType = '12'">за выслугу лет по государственному пенсионному обеспечению</xsl:when>
            <xsl:when test="$pPensType = '13'">по старости по государственному пенсионному обеспечению</xsl:when>
            <xsl:when test="$pPensType = '14'">по инвалидности по государственному пенсионному обеспечению</xsl:when>
            <xsl:when test="$pPensType = '15'">по случаю потери кормильца по государственному пенсионному обеспечению
            </xsl:when>
            <xsl:when test="$pPensType = '18'">социальная пенсия по старости</xsl:when>
            <xsl:when test="$pPensType = '16'">социальная пенсия по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '17'">социальная пенсия по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '19'">социальная пенсия детям, оба родителя которых неизвестны</xsl:when>
            <xsl:when test="$pPensType = '8'">пенсия, предусмотренная Законом Российской Федерации от 19 апреля 1991 г.
                N 1032-1 "О занятости населения в Российской Федерации"
            </xsl:when>
            <xsl:when test="$pPensType = '35'">по старости</xsl:when>
            <xsl:when test="$pPensType = '21'">срочная социальная выплата</xsl:when>
            <xsl:when test="$pPensType = '22'">единовременная выплата средств пенсионных накоплений</xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="WithPensionStr">
        <xsl:param name="pPensType"/>
        <xsl:choose>
            <xsl:when test="$pPensType = '7'">страховая пенсия по старости</xsl:when>
            <xsl:when test="$pPensType = '5'">страховая пенсия по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '6'">страховая пенсия по случаю потери кормильца</xsl:when>
            <!--            <xsl:when test="$pPensType = '4'"> Страховая пенсия по старости досрочно </xsl:when> -->
            <xsl:when test="$pPensType = '24'">доля страховой пенсии по старости</xsl:when>
            <xsl:when test="$pPensType = '13'">пенсия по государственному пенсионному обеспечению по старости</xsl:when>
            <xsl:when test="$pPensType = '14'">пенсия по государственному пенсионному обеспечению по инвалидности
            </xsl:when>
            <xsl:when test="$pPensType = '15'">пенсия по государственному пенсионному обеспечению по потере кормильца
            </xsl:when>
            <xsl:when test="$pPensType = '12'">пенсия по государственному пенсионному обеспечению за выслугу лет
            </xsl:when>
            <xsl:when test="$pPensType = '18'">социальная пенсия по старости</xsl:when>
            <xsl:when test="$pPensType = '16'">социальная пенсия по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '17'">социальная пенсия по потере кормильца</xsl:when>
            <xsl:when test="$pPensType = '19'">социальная пенсия детям, оба родителя которых неизвестны</xsl:when>
            <xsl:when test="$pPensType = '20'">накопительная пенсия</xsl:when>
            <xsl:when test="$pPensType = '35'">пенсия по старости, предусмотренная Законом Российской Федерации от 15
                мая 1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие
                катастрофы на Чернобыльской АЭС»
            </xsl:when>
            <xsl:when test="$pPensType = '8'">пенсия, предусмотренная Законом Российской Федерации от 19 апреля 1991 г.
                № 1032-1 «О занятости населения в Российской Федерации»
            </xsl:when>
            <xsl:when test="$pPensType = '21'">срочная социальная выплата</xsl:when>
            <xsl:when test="$pPensType = '22'">единовременная выплата средств пенсионных накоплений</xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="IncreaseKindStr">
        <xsl:param name="pIncreaseKind"/>
        <xsl:choose>
            <xsl:when test="$pIncreaseKind = '1'">повышения(ий) фиксированной выплаты к страховой пенсии</xsl:when>
            <xsl:when test="$pIncreaseKind = '2'">повышения(ий) фиксированной выплаты к страховой пенсии,
                дополнительного увеличения повышения(ий) фиксированной выплаты к страховой пенсии
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- Вид пенсионного действия -->
    <xsl:template name="PensActStr">
        <xsl:param name="pPensActType"/>
        <xsl:choose>
            <xsl:when test="$pPensActType = 'ПЕНС'">новое назначение пенсии</xsl:when>
            <xsl:when test="$pPensActType = 'ПРСЧ'">перерасчет пенсии</xsl:when>
            <xsl:when test="$pPensActType = 'ОТКЗ'">отказ от страховой пенсии</xsl:when>
            <xsl:when test="$pPensActType = 'ОТКН'">конец периода отказа от СЧ пенсии</xsl:when>
            <xsl:when test="$pPensActType = 'ВОСТ'">восстановление (новое назначение) страховой пенсии (переход с ИНВЛ
                на СТАР)
            </xsl:when>
            <xsl:when test="$pPensActType = 'ДПВЛ'">назначение доли пенсии по выслуги лет</xsl:when>
            <xsl:when test="$pPensActType = 'КРСЧ'">корректировка 1 августа</xsl:when>
            <xsl:when test="$pPensActType = 'КР09'">корректировка на 01.08.2009</xsl:when>
            <xsl:when test="$pPensActType = 'КРПК'">расчет РПК на 31.12.2014 (конец РПК)</xsl:when>
            <xsl:when test="$pPensActType = 'СТОП'">прекращение пенсии</xsl:when>
            <xsl:when test="$pPensActType = 'ПРБЗ'">перерасчет 1 августа</xsl:when>
            <xsl:when test="$pPensActType = 'НПРА'">дата наступления права на установление выплаты за счет СПН
            </xsl:when>
            <xsl:when test="$pPensActType = 'НОБР'">дата обращения за установлением выплаты за счет СПН</xsl:when>
            <xsl:when test="$pPensActType = 'КСПН'">корректировка установленной выплаты за счет СПН на основании всех
                видов СПН
            </xsl:when>
            <xsl:when test="$pPensActType = 'КОПС'">корректировка установленной выплаты за счет ранее не учтенных
                ОПС-взносов для вида выплаты ОПС
            </xsl:when>
            <xsl:when test="$pPensActType = 'КСПВ'">корректировка установленной выплаты за счет ранее не учтенных
                взносов ДСВ и МСК для вида выплаты СПВ
            </xsl:when>
            <xsl:when test="$pPensActType = 'ЕВДП'">ката доплаты к установленной в прошлом году выплате вида ЕВ или ЕВО
                или ЕВДМ
            </xsl:when>
            <xsl:when test="$pPensActType = 'НАЗН'">пенсионное действие при установлении выплаты ранее даты обращения,
                но не более чем на месяц
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- Форма пенсионного действия -->
    <xsl:template name="PensFormStr">
        <xsl:param name="pPensFormType"/>
        <xsl:choose>
            <xsl:when test="$pPensFormType = 'НОВ'">новое пенсионное действие</xsl:when>
            <xsl:when test="$pPensFormType = 'ОТМН'">отменяющее пенсионное действие</xsl:when>
        </xsl:choose>
    </xsl:template>


    <!-- Тип запроса выписки -->
    <xsl:template name="InquiryStr">
        <xsl:param name="pInquiryType"/>
        <xsl:choose>
            <xsl:when test="$pInquiryType = 'ПЕНС'">для назначения трудовой пенсии</xsl:when>
            <xsl:when test="$pInquiryType = 'ПРСЧ'">для перерасчета трудовой пенсии на 1 августа, для уточнения
                страховых пенсий с 01.01.2015
            </xsl:when>
            <xsl:when test="$pInquiryType = 'ПЕНК'">случай необходимости проведения корректировки назначенной ранее
                трудовой пенсии
            </xsl:when>
            <xsl:when test="$pInquiryType = 'КРСЧ'">для беззаявительного перерасчета трудовой пенсии на 1 августа, для
                уточнения страховых пенсий с 01.01.2015
            </xsl:when>
            <xsl:when test="$pInquiryType = 'КОНВ'">для получения выписки по конвертации (выписка со сведениями до 2002
                года)
            </xsl:when>
            <xsl:when test="$pInquiryType = 'РАСЧ'">случай необходимости расчета размера трудовой пенсии на дату
                пенсионного действия с целью определения права на установление выплаты за счет средств
                пенсионных накоплений
            </xsl:when>
            <xsl:when test="$pInquiryType = 'СОЦД'">случай необходимости получения выписки для определения периодов
                работы пенсионера
            </xsl:when>
            <xsl:when test="$pInquiryType = 'СДПР'">для получения выписки по запросам судебных приставов</xsl:when>
            <xsl:when test="$pInquiryType = 'ПРБЧ'">для перерасчета базовой части трудовой пенсии пенсионерам, имеющим
                северный стаж
            </xsl:when>
            <xsl:when test="$pInquiryType = 'НПЕН'">Запрос на установление первой выплаты за счет СПН (НЧ, СПВ, ЕВ
                СПН)
            </xsl:when>
            <xsl:when test="$pInquiryType = 'НКОР'">Запрос на корректировку выплаты за счет СПН (за счет ранее не
                учтенных СПН по ранее учтенным источникам ОПС и/или ДСВ и МСК)
            </xsl:when>
            <xsl:when test="$pInquiryType = 'НДОП'">Запрос на доплату к ЕВ за счёт СПН</xsl:when>
            <xsl:when test="$pInquiryType = 'НВТР'">Запрос на установление второй/повторной выплаты СПН (за счет СПН по
                ранее не учтенным источникам ОПС и/или ДСВ и МСК)
            </xsl:when>
            <xsl:when test="$pInquiryType = 'НПРД'">Запрос на продолжение выплаты за счет СПН, прекращенной в НПФ в
                связи с ликвидацией
            </xsl:when>
            <xsl:when test="$pInquiryType = 'НИНФ'">Запрос информации о действиях СФР по осуществлению выплаты за счет
                СПН
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- Вид пенсии -->
    <xsl:template name="PensionStr">
        <xsl:param name="pPensionType"/>
        <xsl:choose>
            <xsl:when test="$pPensionType = 'СТАР'">по старости</xsl:when>
            <xsl:when test="$pPensionType = 'ИНВЛ'">по инвалидности</xsl:when>
        </xsl:choose>
    </xsl:template>


    <!-- Виды выплат -->
    <xsl:template name="PaymentType">
        <xsl:param name="pPayType"/>
        <xsl:choose>
            <xsl:when test="$pPayType = '01.101'">Страховая пенсия по старости</xsl:when>
            <xsl:when test="$pPayType = '01.102'">Страховая пенсия по инвалидности</xsl:when>
            <xsl:when test="$pPayType = '01.103'">Страховая пенсия по потере кормильца</xsl:when>
            <xsl:when test="$pPayType = '01.201'">Пенсия по государственному пенсионному обеспечению по старости
            </xsl:when>
            <xsl:when test="$pPayType = '01.202'">Пенсия по государственному пенсионному обеспечению по инвалидности
            </xsl:when>
            <xsl:when test="$pPayType = '01.203'">Пенсия по государственному пенсионному обеспечению по потере
                кормильца
            </xsl:when>
            <xsl:when test="$pPayType = '01.204'">Пенсия по государственному пенсионному обеспечению за выслугу лет
            </xsl:when>
            <xsl:when test="$pPayType = '01.301'">Социальная пенсия по старости</xsl:when>
            <xsl:when test="$pPayType = '01.302'">Социальная пенсия по инвалидности</xsl:when>
            <xsl:when test="$pPayType = '01.303'">Социальная пенсия по потере кормильца</xsl:when>
            <xsl:when test="$pPayType = '01.304'">Социальная пенсия детям, оба родителя которых неизвестны</xsl:when>
            <xsl:when test="$pPayType = '01.401'">Пенсия по старости, предусмотренная Законом Российской Федерации от 15
                мая 1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие
                катастрофы на Чернобыльской АЭС»
            </xsl:when>
            <xsl:when test="$pPayType = '01.402'">Пенсия, предусмотренная Законом Российской Федерации от 19 апреля 1991
                г. № 1032-1 «О занятости населения в Российской Федерации»
            </xsl:when>
            <xsl:when test="$pPayType = '01.403'">Пенсии депутатам последнего ВС РСФСР и их помощникам</xsl:when>
            <xsl:when test="$pPayType = '02.001'">Компенсация трудоспособным лицам, осуществляющим уход за
                нетрудоспособными лицами (В соответствии с Указом № 175)
            </xsl:when>
            <xsl:when test="$pPayType = '02.002'">Компенсация трудоспособным лицам, осуществляющим уход за
                нетрудоспособными лицами (В соответствии с Указом № 1455)
            </xsl:when>
            <xsl:when test="$pPayType = '03.001'">Ежемесячная денежная выплата (в соответствии с нормами Закона №
                5-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '03.002'">Ежемесячная денежная выплата (в соответствии с нормами Закона №
                122-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '03.003'">Ежемесячная денежная выплата (в соответствии с нормами Закона №
                181-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '03.004'">Ежемесячная денежная выплата (в соответствии с нормами Закона №
                1244-1-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '03.005'">Ежемесячная денежная выплата (в соответствии с нормами Закона №
                175-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '03.006'">Ежемесячная денежная выплата (в соответствии с нормами Закона №
                2123-1-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '03.007'">Ежемесячная денежная выплата (в соответствии с нормами Закона №
                2-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '04.001'">Дополнительное ежемесячное материальное обеспечение (в соответствии с
                Указом № 363)
            </xsl:when>
            <xsl:when test="$pPayType = '04.002'">Дополнительное ежемесячное материальное обеспечение (в соответствии с
                Указом № 887)
            </xsl:when>
            <xsl:when test="$pPayType = '05.001'">Федеральная социальная доплата</xsl:when>
            <xsl:when test="$pPayType = '06.001'">Дополнительное материальное обеспечение атомщикам</xsl:when>
            <xsl:when test="$pPayType = '06.002'">Дополнительное материальное обеспечение сотрудникам ООН</xsl:when>
            <xsl:when test="$pPayType = '06.003'">Дополнительное материальное обеспечение героям ВОВ и кавалерам ордена
                Славы (Указ № 1708)
            </xsl:when>
            <xsl:when test="$pPayType = '06.004'">Дополнительное материальное обеспечение за выдающиеся достижения
                21-ФЗ
            </xsl:when>
            <xsl:when test="$pPayType = '06.005'">Ежемесячная доплата к пенсии гражданам РФ, проживающим в республике
                Абхазия
            </xsl:when>
            <xsl:when test="$pPayType = '06.006'">Ежемесячная доплата к пенсии гражданам РФ, проживающим в республике Ю.
                Осетия
            </xsl:when>
            <xsl:when test="$pPayType = '06.007'">Дополнительное материальное обеспечение Указ № 995 от 28.08.2003
                года
            </xsl:when>
            <xsl:when test="$pPayType = '06.008'">Дополнительное материальное обеспечение по персональным распоряжениям
                (указам) Президента РФ
            </xsl:when>
            <xsl:when test="$pPayType = '07.001'">Дополнительное социальное обеспечение (в соответствии с Законом №
                84-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '07.002'">Дополнительное социальное обеспечение (в соответствии с Законом №
                155-ФЗ)
            </xsl:when>
            <xsl:when test="$pPayType = '08.001'">Единовременная выплата к 65-летию Победы ВОВ (Указ № 247 от
                24.02.2010)
            </xsl:when>
            <xsl:when test="$pPayType = '08.002'">Единовременная выплата к 67-летию Победы ВОВ (Указ № 595 от
                07.05.2012)
            </xsl:when>
            <xsl:when test="$pPayType = '08.003'">Единовременная выплата к 70-летию Победы ВОВ (Указ № 100 от
                26.02.2015)
            </xsl:when>
            <xsl:when test="$pPayType = '08.004'">Единовременная выплата к 73-летию Победы ВОВ (Указ № 195 от
                06.05.2018)
            </xsl:when>
            <xsl:when test="$pPayType = '08.005'">Ежегодная выплата к годовщине Победы ВОВ (Указ № 186 от 24.04.2019)
            </xsl:when>
            <xsl:when test="$pPayType = '08.100'">Единовременная выплата гражданам, получающим пенсию (5000)</xsl:when>
            <xsl:when test="$pPayType = '08.006'">Единовременная выплата к 75-летию Победы ВОВ</xsl:when>
            <xsl:when test="$pPayType = '09.001'">Накопительная пенсия</xsl:when>
            <xsl:when test="$pPayType = '09.002'">Срочная социальная выплата</xsl:when>
            <xsl:when test="$pPayType = '09.003'">Единовременная выплата</xsl:when>
            <xsl:when test="$pPayType = '10.001'">Средства пенсионных накоплений, выплачиваемые правопреемникам
            </xsl:when>
            <xsl:when test="$pPayType = '11.001'">Ежемесячные денежные выплаты, в повышенном размере пенсий (п.4 ч.1
                ст.18, п.3 ч.2 ст.19 и п.4 ч.1 ст.20 Закона РФ № 1244-1) (Экологическая выплата)
            </xsl:when>
            <xsl:when test="$pPayType = '12.001'">Доля страховой пенсии по старости</xsl:when>
            <xsl:when test="$pPayType = '13.001'">Компенсация проезда к месту отдыха (п.1 Постановления от 01.04.2005 №
                176)
            </xsl:when>
            <xsl:when test="$pPayType = '13.002'">Компенсация северного переезда (ст.35 Закон РФ от 19.02.1993 №
                4520-1)
            </xsl:when>
            <xsl:when test="$pPayType = '14.001'">Ежемесячная денежная выплата Героям и членам их семей (в соответствии
                с нормами Закона №4301-1 "О статусе Героев Советского Союза, Героев Российской Федерации и полных
                кавалеров ордена Славы")
            </xsl:when>
            <xsl:when test="$pPayType = '14.002'">Ежемесячная денежная выплата Героям и членам их семей (в соответствии
                с нормами Закона №5-ФЗ "О предоставлении социальных гарантий Героям Социалистического Труда, Героям
                Труда Российской Федерации и полным кавалерам ордена Трудовой Славы"")
            </xsl:when>
            <xsl:when test="$pPayType = '15.001'">Пособие на погребение, умершим пенсионерам, получавшим страховую или
                накопительную пенсию
            </xsl:when>
            <xsl:when test="$pPayType = '15.002'">Пособие на погребение, умершим пенсионерам, получавшим пенсию по
                государственному обеспечению
            </xsl:when>
            <xsl:when test="$pPayType = '15.003'">Пособие на погребение, умершим пенсионерам, оформившим пенсию
                досрочно, по предложению органов службы занятости
            </xsl:when>
            <xsl:when test="$pPayType = '16.001'">Пенсия, назначенная иностранным государством</xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="TypePensionStr">
        <xsl:param name="pPensType"/>
        <xsl:choose>
            <xsl:when test="$pPensType = '5'">страховой пенсии по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '6'">страховой пенсии по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '7'">страховой пенсии по старости</xsl:when>
            <xsl:when test="$pPensType = '12'">пенсии за выслугу лет</xsl:when>
            <xsl:when test="$pPensType = '13'">пенсии по старости по государственному пенсионному обеспечению</xsl:when>
            <xsl:when test="$pPensType = '14'">пенсии по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '15'">пенсии по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '16'">социальной пенсии по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '17'">социальной пенсии по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '18'">социальной пенсии по старости</xsl:when>
            <xsl:when test="$pPensType = '19'">социальной пенсии детям, оба родителя которых неизвестны</xsl:when>
            <xsl:when test="$pPensType = '20'">накопительной пенсии</xsl:when>
            <xsl:when test="$pPensType = '27'">страховой пенсии</xsl:when>
            <xsl:when test="$pPensType = '28'">пенсии по государственному пенсионному обеспечению</xsl:when>
            <xsl:when test="$pPensType = '29'">социальной пенсии</xsl:when>
            <xsl:when test="$pPensType = '35'">страховой пенсии по старости</xsl:when>
            <xsl:when test="$pPensType = '69'">пенсии за выслугу лет</xsl:when>
            <xsl:when test="$pPensType = '68'">пенсии по старости</xsl:when>
            <xsl:when test="$pPensType = '70'">пенсии по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '71'">пенсии по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '72'">пенсии по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '73'">пенсии по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '21'">срочной пенсионной выплаты</xsl:when>
            <xsl:when test="$pPensType = '22'">единовременной выплаты средств пенсионных накоплений</xsl:when>
             <xsl:when test="$pPensType = '8'">пенсии, предусмотренной Законом Российской федерации от 19 апреля 1991 г. № 1032-1 «О занятости населения в Российской Федерации</xsl:when>
              <xsl:when test="$pPensType = '24'">доли страховой пенсии по старости</xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="TypePaymentStr">
        <xsl:param name="pPensType"/>
        <xsl:choose>
			<xsl:when test="$pPensType = '4'">ежемесячную денежную выплату</xsl:when>
            <xsl:when test="$pPensType = '5'">страховую пенсию по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '6'">страховую пенсию по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '7'">страховую пенсию по старости</xsl:when>
            <xsl:when test="$pPensType = '12'">пенсию за выслугу лет</xsl:when>
            <xsl:when test="$pPensType = '13'">пенсию по старости по государственному пенсионному обеспечению</xsl:when>
            <xsl:when test="$pPensType = '14'">пенсию по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '15'">пенсию по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '16'">социальную пенсию по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '17'">социальную пенсию по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '18'">социальную пенсию по старости</xsl:when>
            <xsl:when test="$pPensType = '19'">социальную пенсию детям, оба родителя которых неизвестны</xsl:when>
            <xsl:when test="$pPensType = '20'">накопительной пенсию</xsl:when>
            <xsl:when test="$pPensType = '27'">страховую пенсию</xsl:when>
            <xsl:when test="$pPensType = '28'">пенсию по государственному пенсионному обеспечению</xsl:when>
            <xsl:when test="$pPensType = '29'">социальную пенсию</xsl:when>
            <xsl:when test="$pPensType = '35'">страховую пенсию по старости</xsl:when>
            <xsl:when test="$pPensType = '69'">пенсию за выслугу лет</xsl:when>
            <xsl:when test="$pPensType = '68'">пенсию по старости</xsl:when>
            <xsl:when test="$pPensType = '70'">пенсию по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '71'">пенсию по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '72'">пенсию по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '73'">пенсию по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '21'">срочную социальную выплату</xsl:when>
            <xsl:when test="$pPensType = '22'">единовременную выплату средств пенсионных накоплений</xsl:when>
            <xsl:when test="$pPensType = '8'">пенсию, предусмотренную Законом Российской федерации от 19 апреля 1991 г. № 1032-1 «О занятости населения в Российской Федерации»</xsl:when>
            <xsl:when test="$pPensType = '24'">долю страховой пенсии по старости</xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="CodePaymentStr">
        <xsl:param name="pPensType"/>
        <xsl:choose>
            <xsl:when test="$pPensType = '5'">по инвалидности</xsl:when>
            <xsl:when test="$pPensType = '6'">по случаю потери кормильца</xsl:when>
            <xsl:when test="$pPensType = '7'">по старости</xsl:when>
            <xsl:when test="$pPensType = '35'">по старости</xsl:when>
            <xsl:when test="$pPensType = '8'">предусмотренную Законом Российской федерации от 19 апреля 1991 г. № 1032-1 «О занятости населения в Российской Федерации</xsl:when>
            <xsl:when test="$pPensType = '13'">по государственному пенсионному обеспечению</xsl:when>  
        </xsl:choose>
    </xsl:template>
    <xsl:template name="PensActivityStr">
        <xsl:param name="pPensActivity"/>
        <xsl:choose>
            <xsl:when test="$pPensActivity = '1'">индексации</xsl:when>
            <xsl:when test="$pPensActivity = '2'">информировании</xsl:when>
            <xsl:when test="$pPensActivity = '3'">приостановлении выплаты</xsl:when>
            <xsl:when test="$pPensActivity = '4'">прекращении</xsl:when>
            <xsl:when test="$pPensActivity = '5'">восстановлении выплаты</xsl:when>
            <xsl:when test="$pPensActivity = '6'">возобновлении выплаты</xsl:when>
            <xsl:when test="$pPensActivity = '7'">назначении</xsl:when>
            <xsl:when test="$pPensActivity = '8'">перерасчете размера</xsl:when>
            <xsl:when test="$pPensActivity = '9'">корректировке</xsl:when>
            <xsl:when test="$pPensActivity = '10'">продлении выплаты</xsl:when>
            <xsl:when test="$pPensActivity = '11'">приостановлении права</xsl:when>
            <xsl:when test="$pPensActivity = '12'">возобновлении права</xsl:when>
            <xsl:when test="$pPensActivity = '13'">изменении суммы на НСУ</xsl:when>
            <xsl:when test="$pPensActivity = '14'">изменении</xsl:when>
            <xsl:when test="$pPensActivity = '15'">переводе</xsl:when>
            <xsl:when test="$pPensActivity = '16'">дополнительном увеличении</xsl:when>
            <xsl:when test="$pPensActivity = '17'">уточнении размера</xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="PensActivity">
        <xsl:param name="pPensActivity"/>
        <xsl:choose>
            <xsl:when test="$pPensActivity = '1'">индексация</xsl:when>
            <xsl:when test="$pPensActivity = '2'">информирование</xsl:when>
            <xsl:when test="$pPensActivity = '3'">приостановление выплаты</xsl:when>
            <xsl:when test="$pPensActivity = '4'">прекращение</xsl:when>
            <xsl:when test="$pPensActivity = '5'">восстановление выплаты</xsl:when>
            <xsl:when test="$pPensActivity = '6'">возобновление выплаты</xsl:when>
            <xsl:when test="$pPensActivity = '7'">назначение</xsl:when>
            <xsl:when test="$pPensActivity = '8'">перерасчет размера</xsl:when>
            <xsl:when test="$pPensActivity = '9'">корректировка</xsl:when>
            <xsl:when test="$pPensActivity = '10'">продление выплаты</xsl:when>
            <xsl:when test="$pPensActivity = '11'">приостановление права</xsl:when>
            <xsl:when test="$pPensActivity = '12'">возобновление права</xsl:when>
            <xsl:when test="$pPensActivity = '13'">изменение суммы на НСУ</xsl:when>
            <xsl:when test="$pPensActivity = '14'">изменение</xsl:when>
            <xsl:when test="$pPensActivity = '15'">перевод</xsl:when>
            <xsl:when test="$pPensActivity = '16'">дополнительное увеличении</xsl:when>
            <xsl:when test="$pPensActivity = '17'">уточнение размера</xsl:when>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
