<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" exclude-result-prefixes="xs УТ6" version="1.0">
	


<!-- Дата (кратко)-->
	<xsl:template name="DateShortStr">
		<xsl:param name="pDate"/>		
		<xsl:if test="$pDate and $pDate!=''">
			<xsl:variable name="dateText" select="string($pDate)"/>
			<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
		</xsl:if>
	</xsl:template>

<!-- Дата (особая) УТ6 -->
	<xsl:template name="УТ6:DateSpecialStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:if test="$pDate/УТ6:День">
				<xsl:value-of select="$pDate/УТ6:День"/>.</xsl:if>
			<xsl:choose>
				<xsl:when test="$pDate/УТ6:Месяц">
					<xsl:value-of select="$pDate/УТ6:Месяц"/>.</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pDate/УТ6:День">&#160;.</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$pDate/УТ6:Год">
				<xsl:value-of select="$pDate/УТ6:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Дата (особая) (развернуто) УТ6 -->
	<xsl:template name="УТ6:DateSpecialLongStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:choose>
				<xsl:when test="$pDate/УТ6:День">
					<xsl:value-of select="concat('&quot;', format-number($pDate/УТ6:День, '00'), '&quot;')"/>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$pDate/УТ6:Месяц">
					<xsl:choose>
						<xsl:when test="$pDate/УТ6:День">
							<xsl:choose>
								<xsl:when test="$pDate/УТ6:Месяц = 1"> января </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 2"> февраля </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 3"> марта </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 4"> апреля </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 5"> мая </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 6"> июня </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 7"> июля </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 8"> августа </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 9"> сентября </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 10"> октября </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 11"> ноября </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 12"> декабря </xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$pDate/УТ6:Месяц = 1">январь </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 2">февраль </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 3">март </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 4">апрель </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 5">май </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 6">июнь </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 7">июль </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 8">август </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 9">сентябрь </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 10">октябрь </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 11">ноябрь </xsl:when>
								<xsl:when test="$pDate/УТ6:Месяц = 12">декабрь </xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="$pDate/УТ6:Год">
				<xsl:value-of select="$pDate/УТ6:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Фамилия И.О. -->
	<xsl:template name="УТ6:NameStrShort">
		<xsl:param name="pName"/>
		<xsl:param name="pIOFirst"/>
		<xsl:if test="$pName">
			<xsl:choose>
				<xsl:when test="$pIOFirst">
					<xsl:if test="$pName/УТ6:Имя">
						<xsl:value-of select="substring($pName/УТ6:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ6:Отчество">
						<xsl:value-of select="substring($pName/УТ6:Отчество, 1, 1)"/>. </xsl:if>
					<xsl:if test="$pName/УТ6:Фамилия">
						<xsl:value-of select="$pName/УТ6:Фамилия"/>&#160;</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pName/УТ6:Фамилия">
						<xsl:value-of select="$pName/УТ6:Фамилия"/>&#160;</xsl:if>
					<xsl:if test="$pName/УТ6:Имя">
						<xsl:value-of select="substring($pName/УТ6:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ6:Отчество">
						<xsl:value-of select="substring($pName/УТ6:Отчество, 1, 1)"/>. </xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<!-- ФИО -->
	<xsl:template name="УТ6:NameStr">
		<xsl:param name="pName"/>
		<!--pNoBreakWhitespace - устанавливает, следует ли использовать неразрывные пробелы или разрывные
				1 - неразрывные
				0 - разрывные (3-per-em space)-->
		<xsl:param name="pNoBreakWhitespace" select="1"/>
		<xsl:if test="$pName">
			<xsl:if test="$pName/УТ6:Фамилия">
				<xsl:value-of select="$pName/УТ6:Фамилия"/><xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose></xsl:if>
			<xsl:if test="$pName/УТ6:Имя">
				<xsl:value-of select="$pName/УТ6:Имя"/><xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose></xsl:if>
			<xsl:if test="$pName/УТ6:Отчество">
				<xsl:value-of select="$pName/УТ6:Отчество"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Пол -->
	<xsl:template name="УТ6:SexStr">
	<xsl:param name="pSex"/>
			<td colspan="3" class="afValue">
				<xsl:choose>
					<xsl:when test="$pSex = 1 ">М</xsl:when>
					<xsl:when test="$pSex = 2 ">Ж</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</td>
	</xsl:template>

	<!-- Документ, удостоверяющий личность -->
	<xsl:template name="УТ6:DocumentStr">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable afTable100">
				<tr>
					<td>Наименование документа, удостоверяющего личность</td>
					<td colspan="3" class="afValue">
						<xsl:choose>
							<xsl:when test="$pDocument/УТ6:Код = 6 "> Свидетельство о рождении</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 9 "> Удостоверение беженца</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 12"> Вид на жительство в Российской Федерации</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 16"> Военный билет</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 18"> Временное удостоверение личности гражданина Российской Федерации</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 26"> Загранпаспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 27"> Паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 28"> Паспорт иностранного гражданина</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 31"> Разрешение на временное проживание</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 32"> Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 33"> Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 36"> Служебный паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 37"> Справка об освобождении из места лишения свободы</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 39"> Удостоверение личности военнослужащего РФ</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 93"> Свидетельство о смерти</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 210"> Дипломатический паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 511"> Иной документ, удостоверяющий личность</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 688"> Паспорт гражданина СССР</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 689"> Загранпаспорт гражданина СССР</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 690"> Удостоверение личности офицера</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 691"> Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 692"> Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 693"> Военный билет офицера запаса</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 706"> Временное удостоверение, выданное взамен военного билета</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 29"> Паспорт Минморфлота</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 30"> Паспорт моряка</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
							<xsl:when test="$pDocument/УТ6:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pDocument/УТ6:Серия, ' ', $pDocument/УТ6:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ6:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ6:КемВыдан"/>
					</td>
				</tr>
				<tr>
					<td>Дата рождения</td>
					<td colspan="3" class="afValue">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pData"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ6:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
				<xsl:if test="$pBirthplace">
					<tr>
						<td>Место рождения</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="УТ6:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия документа
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if></td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ6:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>

	<!-- ДУЛ новая форма -->
	<xsl:template name="УТ6:DocumentStrNF">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable afTable100">
                <tr>
                    <td>Документ, удостоверяющий личность: наименование</td>
                    <td colspan="3" class="afValue">
                        <xsl:choose>
                            <xsl:when test="$pDocument/УТ6:Код">
								<xsl:call-template name="УТ6:CodDocumentStr">
									<xsl:with-param   name="pCodDocument" select="$pDocument"/>
								</xsl:call-template>   
                            </xsl:when>
                            <xsl:otherwise>&#160;</xsl:otherwise>
                        </xsl:choose>
                    </td>
                </tr>                             
                    <tr>
                        <td>серия (при наличии)</td>
                        <td class="afValue">
                            <xsl:value-of select="$pDocument/УТ6:Серия"/>
                        </td>
                        <td>номер</td>
                        <td class="afValue">
                            <xsl:value-of select="$pDocument/УТ6:Номер"/>
                        </td>
                        <td>дата</td>
                        <td class="afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="$pDocument/УТ6:ДатаВыдачи"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </td>
                    </tr>
                    <tr>
                        <td>орган, выдавший документ</td>
                        <td colspan="3" class="afValue">
                            <xsl:value-of select="$pDocument/УТ6:КемВыдан"/>
                        </td>
                    </tr>
					<tr>
						<td>дата рождения</td>
						<td colspan="3" class="afValue">
							<xsl:if test="$pData">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate" select="$pData"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="$pDataSpecial">
								<xsl:call-template name="УТ6:DateSpecialStr">
									<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
								</xsl:call-template>
							</xsl:if>
						</td>
					</tr>  
					
					<xsl:if test="$pBirthplace">
					<tr>
						<td>место рождения</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="УТ6:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>                  
                    
                 <xsl:if test="$pPeriod = '1'">
					<tr>
						<td>срок действия документа (при наличии в документе)
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if></td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ6:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
                </table>
         </xsl:if>
    </xsl:template>

	<!-- Код Документа, удостоверяющий личность -->
	<xsl:template name="УТ6:CodDocumentStr">
	<xsl:param name="pCodDocument"/>
			<xsl:choose>
					<xsl:when test="$pCodDocument/УТ6:Код = 6 "> Свидетельство о рождении</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 9 "> Удостоверение беженца</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 12"> Вид на жительство в Российской Федерации</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 16"> Военный билет</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 18"> Временное удостоверение личности гражданина Российской Федерации</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 26"> Загранпаспорт гражданина РФ</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 27"> Паспорт гражданина РФ</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 28"> Паспорт иностранного гражданина</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 31"> Разрешение на временное проживание</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 32"> Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 33"> Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 36"> Служебный паспорт гражданина РФ</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 37"> Справка об освобождении из места лишения свободы</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 39"> Удостоверение личности военнослужащего РФ</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 93"> Свидетельство о смерти</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 210"> Дипломатический паспорт гражданина РФ</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 511"> Иной документ, удостоверяющий личность</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 688"> Паспорт гражданина СССР</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 689"> Загранпаспорт гражданина СССР</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 690"> Удостоверение личности офицера</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 691"> Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 692"> Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 693"> Военный билет офицера запаса</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 706"> Временное удостоверение, выданное взамен военного билета</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 29"> Паспорт Минморфлота</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 30"> Паспорт моряка</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
					<xsl:when test="$pCodDocument/УТ6:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	<xsl:template name="CodDULStr">
	<xsl:param name="pCodDocument"/>
			<xsl:choose>
					<xsl:when test="$pCodDocument = 6 "> Свидетельство о рождении</xsl:when>
					<xsl:when test="$pCodDocument = 9 "> Удостоверение беженца</xsl:when>
					<xsl:when test="$pCodDocument = 12"> Вид на жительство в Российской Федерации</xsl:when>
					<xsl:when test="$pCodDocument = 16"> Военный билет</xsl:when>
					<xsl:when test="$pCodDocument = 18"> Временное удостоверение личности гражданина Российской Федерации</xsl:when>
					<xsl:when test="$pCodDocument = 26"> Загранпаспорт гражданина РФ</xsl:when>
					<xsl:when test="$pCodDocument = 27"> Паспорт гражданина РФ</xsl:when>
					<xsl:when test="$pCodDocument = 28"> Паспорт иностранного гражданина</xsl:when>
					<xsl:when test="$pCodDocument = 31"> Разрешение на временное проживание</xsl:when>
					<xsl:when test="$pCodDocument = 32"> Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
					<xsl:when test="$pCodDocument = 33"> Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
					<xsl:when test="$pCodDocument = 36"> Служебный паспорт гражданина РФ</xsl:when>
					<xsl:when test="$pCodDocument = 37"> Справка об освобождении из места лишения свободы</xsl:when>
					<xsl:when test="$pCodDocument = 39"> Удостоверение личности военнослужащего РФ</xsl:when>
					<xsl:when test="$pCodDocument = 93"> Свидетельство о смерти</xsl:when>
					<xsl:when test="$pCodDocument = 210"> Дипломатический паспорт гражданина РФ</xsl:when>
					<xsl:when test="$pCodDocument = 511"> Иной документ, удостоверяющий личность</xsl:when>
					<xsl:when test="$pCodDocument = 688"> Паспорт гражданина СССР</xsl:when>
					<xsl:when test="$pCodDocument = 689"> Загранпаспорт гражданина СССР</xsl:when>
					<xsl:when test="$pCodDocument = 690"> Удостоверение личности офицера</xsl:when>
					<xsl:when test="$pCodDocument = 691"> Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
					<xsl:when test="$pCodDocument = 692"> Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
					<xsl:when test="$pCodDocument = 693"> Военный билет офицера запаса</xsl:when>
					<xsl:when test="$pCodDocument = 706"> Временное удостоверение, выданное взамен военного билета</xsl:when>
					<xsl:when test="$pCodDocument = 13"> Вид на жительство иностранного гражданина</xsl:when>
					<xsl:when test="$pCodDocument = 29"> Паспорт Минморфлота</xsl:when>
					<xsl:when test="$pCodDocument = 30"> Паспорт моряка</xsl:when>
					<xsl:when test="$pCodDocument = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
					<xsl:when test="$pCodDocument = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	<!-- Гражданство-->
	<xsl:template name="NationalityStr">
		<xsl:param name="pNationalityType"/>
		<xsl:choose>
			<xsl:when test="$pNationalityType = '1'"> гражданин(-ка) РФ </xsl:when>
			<xsl:when test="$pNationalityType = '2'"> иностранный гражданин </xsl:when>
			<xsl:when test="$pNationalityType = '3'"> лицо без гражданства </xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Пункт нормативного документа-->
	<xsl:template name="УТ6:NormativeDocumentStr">
		<xsl:param name="pNormativeDocument"/>
		<xsl:choose>
			<xsl:when test="$pNormativeDocument">
				<xsl:if test="$pNormativeDocument/УТ6:Подпункт"> подпункт <xsl:value-of select="$pNormativeDocument/УТ6:Подпункт"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ6:Пункт">
					<xsl:value-of select="concat(' п.',' ', $pNormativeDocument/УТ6:Пункт)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ6:Часть">
					<xsl:value-of select="concat(' ч.',' ', $pNormativeDocument/УТ6:Часть)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ6:Статья">
					<xsl:value-of select="concat(' ст.',' ', $pNormativeDocument/УТ6:Статья)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ6:НормативныйДокумент">
					<xsl:value-of select="concat(' ',' ', $pNormativeDocument/УТ6:НормативныйДокумент)"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>

	<xsl:template name="УТ6:AddressStr">
		<xsl:param name="pAddress"/>
		<xsl:param name="needIndex" select="1"/>
		<xsl:param name="needRegion" select="1"/>
		<xsl:if test="$needIndex and $pAddress/УТ6:Индекс">
			<xsl:value-of select="$pAddress/УТ6:Индекс"/>, </xsl:if>
		<xsl:if test="$needRegion and $pAddress/УТ6:Регион">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ6:Регион/УТ6:Сокращение">	
					<xsl:choose>
						<xsl:when test="$pAddress/УТ6:Регион/УТ6:Сокращение='край' or $pAddress/УТ6:Регион/УТ6:Сокращение='Республика'">
							<xsl:value-of select="concat($pAddress/УТ6:Регион/УТ6:Название, ' ', $pAddress/УТ6:Регион/УТ6:Сокращение)"/>,
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="concat($pAddress/УТ6:Регион/УТ6:Название, ' ', $pAddress/УТ6:Регион/УТ6:Сокращение, '.')"/>,</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ6:Регион/УТ6:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ6:Округ">
			<xsl:value-of select="$pAddress/УТ6:Округ"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ6:Район">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ6:Район/УТ6:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ6:Район/УТ6:Название, ' ', $pAddress/УТ6:Район/УТ6:Сокращение)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($pAddress/УТ6:Район/УТ6:Название, ' р-н')"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ6:Город">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ6:Город/УТ6:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ6:Город/УТ6:Сокращение, '. ', $pAddress/УТ6:Город/УТ6:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('г. ', $pAddress/УТ6:Город/УТ6:Название)"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ6:ВнутригородскойРайон">
			<xsl:value-of select="$pAddress/УТ6:ВнутригородскойРайон"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ6:НаселенныйПункт">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ6:НаселенныйПункт/УТ6:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ6:НаселенныйПункт/УТ6:Сокращение, '. ', $pAddress/УТ6:НаселенныйПункт/УТ6:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ6:НаселенныйПункт/УТ6:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ6:Улица">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ6:Улица/УТ6:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ6:Улица/УТ6:Сокращение, '. ', $pAddress/УТ6:Улица/УТ6:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ6:Улица/УТ6:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ6:Дом">
			<xsl:value-of select="concat(' д. ', $pAddress/УТ6:Дом)"/>
		</xsl:if>
		<xsl:if test="$pAddress/УТ6:Строение or $pAddress/УТ6:Владение or $pAddress/УТ6:Корпус or $pAddress/УТ6:Квартира">, </xsl:if>
		<xsl:if test="$pAddress/УТ6:Строение">
			<xsl:value-of select="concat(' стр. ', $pAddress/УТ6:Строение)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ6:Владение">
			<xsl:value-of select="$pAddress/УТ6:Владение"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ6:Корпус">
			<xsl:value-of select="concat(' корпус ', $pAddress/УТ6:Корпус)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ6:Квартира">
			<xsl:value-of select="concat(' кв. ', $pAddress/УТ6:Квартира)"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="УТ6:AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress/УТ6:Иностранный">
			<xsl:if test="$pAddress/УТ6:Иностранный/УТ6:КодСтраны">
				<xsl:value-of select="$pAddress/УТ6:Иностранный/УТ6:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ6:Иностранный/УТ6:НазваниеСтраны">
				<xsl:value-of select="$pAddress/УТ6:Иностранный/УТ6:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ6:Иностранный/УТ6:АдресКириллицей">
				<xsl:value-of select="$pAddress/УТ6:Иностранный/УТ6:АдресКириллицей"/></xsl:if>
			<xsl:if test="$pAddress/УТ6:Иностранный/УТ6:АдресЛатиницей">
				,&#160;<xsl:value-of select="$pAddress/УТ6:Иностранный/УТ6:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress">
			<xsl:if test="$pAddress/УТ6:КодСтраны">
				<xsl:value-of select="$pAddress/УТ6:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ6:НазваниеСтраны">
				<xsl:value-of select="$pAddress/УТ6:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ6:АдресКириллицей">
				<xsl:value-of select="$pAddress/УТ6:АдресКириллицей"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ6:АдресЛатиницей">
				<xsl:value-of select="$pAddress/УТ6:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Место рождения -->
	<xsl:template name="УТ6:BirthplaceStr">
		<xsl:param name="pBirthplace"/>
		<xsl:if test="$pBirthplace/УТ6:Город">
			<xsl:value-of select="$pBirthplace/УТ6:Город"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ6:Район">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ6:Район)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ6:Регион">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ6:Регион)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ6:Страна">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ6:Страна)"/>
		</xsl:if>
	</xsl:template>
	<!-- Место рождения -->
	<xsl:template name="УТ6:BirthplaceStrRev">
		<xsl:param name="pBirthplace"/>
		<xsl:if test="$pBirthplace/УТ6:Страна">
			<xsl:value-of select="$pBirthplace/УТ6:Страна"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ6:Регион">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ6:Регион)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ6:Район">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ6:Район)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ6:Город">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ6:Город)"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="УТ6:NumberedDocName">
		<xsl:param name="pDoc"/>
		<xsl:value-of select="$pDoc/УТ6:Наименование"/>
		<xsl:for-each select="$pDoc/УТ6:Реквизиты/УТ6:Реквизит">
			<xsl:if test="position() > 1">,</xsl:if> &#160;<xsl:value-of select="./УТ6:Наименование"/>&#160;<xsl:value-of select="./УТ6:Значение"/>
		</xsl:for-each>
		<xsl:if test="$pDoc/УТ6:ПредставленностьДокумента"> &#160;<xsl:value-of select="$pDoc/УТ6:ПредставленностьДокумента"/> экз. </xsl:if>
	</xsl:template>

	<!-- Представитель УТ6 -->
	<xsl:template name="УТ6:RepresentativeStr">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:if test="$pRepresent">
			<p class="afParagraph">2. Представитель <xsl:call-template name="УТ6:RepresentativeType">
					<xsl:with-param name="pRepresent" select="$pRepresent"/>
				</xsl:call-template>
			</p>
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:call-template name="УТ6:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/УТ6:АнкетныеДанные/УТ6:ФИО"/>
				</xsl:call-template>
				<xsl:if test="$pRepresent/УТ6:ЮридическоеЛицо"> ,&#160; <xsl:value-of select="$pRepresent/УТ6:ЮридическоеЛицо/УТ6:Наименование"/>
				</xsl:if>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
			<p class="afInterval"/>

			<xsl:if test="$pRepresent/УТ6:АнкетныеДанные/УТ6:АдресРегистрации">
				<div class="afRow">
					<div class="afC">адрес места жительства</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ6:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ6:АнкетныеДанные/УТ6:АдресРегистрации"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ6:АнкетныеДанные/УТ6:АдресПребывания">
				<div class="afRow">
					<div class="afC">адрес места пребывания</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ6:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ6:АнкетныеДанные/УТ6:АдресПребывания"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ6:АнкетныеДанные/УТ6:АдресФактический">
				<div class="afRow">
					<div class="afC">адрес места фактического проживания</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ6:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ6:АнкетныеДанные/УТ6:АдресФактический"/>
					</xsl:call-template>
				</p>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ6:ЮридическоеЛицо/УТ6:ЮрАдрес">
				<div class="afRow">
					<div class="afC">юридический адрес организации</div>
					<div class="afBlankUnderlinedBlock afMarginLeft300"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ6:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ6:ЮридическоеЛицо/УТ6:ЮрАдрес"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ6:ЮридическоеЛицо/УТ6:Адрес">
				<div class="afRow">
					<div class="afC">адрес места нахождения организации</div>
					<div class="afBlankUnderlinedBlock afMarginLeft300"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ6:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ6:ЮридическоеЛицо/УТ6:Адрес"/>
					</xsl:call-template>
				</p>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ6:АнкетныеДанные/УТ6:Телефоны">
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/УТ6:АнкетныеДанные/УТ6:Телефоны"/>
					</div>
				</div>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент">
				<table class="afTable">
					<tr>
						<td>Наименование документа, удостоверяющего личность представителя</td>
						<td colspan="3" class="afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 6">Свидетельство о рождении</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 9">Удостоверение беженца</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 12">Вид на жительство в Российской Федерации</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 16">Военный билет</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 18">Временное удостоверение личности гражданина Российской Федерации</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 26">Загранпаспорт гражданина РФ</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 27">Паспорт гражданина РФ</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 28">Паспорт иностранного гражданина</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 31">Разрешение на временное проживание</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 32">Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 33">Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 36">Служебный паспорт гражданина РФ</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 37">Справка об освобождении из места лишения свободы</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 39">Удостоверение личности военнослужащего РФ</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 93">Свидетельство о смерти</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 210">Дипломатический паспорт гражданина РФ</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 511">Иной документ, удостоверяющий личность</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 688">Паспорт гражданина СССР</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 689">Загранпаспорт гражданина СССР</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 690">Удостоверение личности офицера</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 691">Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 692">Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 693">Военный билет офицера запаса</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 706">Временное удостоверение, выданное взамен военного билета</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 29"> Паспорт Минморфлота</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 30"> Паспорт моряка</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
								<xsl:when test="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td>Серия, номер</td>
						<td class="afValue">
							<xsl:value-of select="concat($pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Серия, ' ', $pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Номер)"/>
						</td>
						<td>Дата выдачи</td>
						<td class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:ДатаВыдачи"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>Кем выдан</td>
						<td colspan="3" class="afValue">
							<xsl:value-of select="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:КемВыдан"/>
						</td>
					</tr>
					<xsl:if test="$pIDPeriod = '1'">
						<tr>
							<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
									<span class="afSubscript"> (при наличии)</span>
								</xsl:if></td>
							<td colspan="3" class="afValue">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate">
										<xsl:value-of select="$pRepresent/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:СрокДействия"/>
									</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:if>
				</table>
			</xsl:if>
			<p class="afInterval"/>
			<table class="afTable">
				<tr>
					<td>Наименование документа, подтверждающего полномочия представителя</td>
					<td colspan="3" class="afValue">
						<xsl:choose>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1">Документ, выданный органом опеки и попечительства</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 2">Положение (устав) организации</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 3">Постановление администрации об установлении опекунства</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 4">Решение органа опеки и попечительства</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 5">Решение суда</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 6">Свидетельство о рождении</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 7">Свидетельство об установлении отцовства</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 8">Свидетельство об усыновлении (удочерении)</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 9">Удостоверение беженца</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 10">Удостоверение, выданное органом опеки и попечительства</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 11">Учредительные документы организации</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 19">Документ исправительного учреждения о нахождении (пребывании) осужденного к лишению свободы или принудительным работам в исправительном учреждении</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 20">Документ стационарной организации социального обслуживания о нахождении (пребывании) гражданина в этой организации</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 286">Нотариальная доверенность</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 513">Доверенность, выданная в порядке, установленном Гражданским кодексом Российской Федерации</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 630">Документ, удостоверяющий личность представителя гражданина Российской Федерации</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 632">Документ, подтверждающий полномочия представителя</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 710">Доверенность</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 887">Иной документ, подтверждающий полномочия представителя</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 964">Документ, подтверждающий полномочия уполномоченного представителя застрахованного лица</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 968">Документ, подтверждающий полномочия представителя страхователя</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1133">Акт об отобрании ребенка</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1134">Акт органа опеки и попечительства о временном назначении опекуна или попечителя (акт о предварительных опеке или попечительстве)</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1135">Акт органа опеки и попечительства о назначении опекуна или попечителя</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1136">Акт органа опеки и попечительства об объявлении дееспособным</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1137">Акт органа опеки и попечительства об освобождении опекуна или попечителя от исполнения возложенных на них обязанностей либо об их отстранении от исполнения возложенных на них обязанностей</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1138">Выписка из судебного решения</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1139">Иной документ подтверждающий полномочия (прекращения полномочий) законного представителя</xsl:when>
							<xsl:when test="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код = 1140">Акт гражданского состояния ЕГР ЗАГС</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Серия, ' ', $pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:КемВыдан"/>
					</td>
				</tr>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия полномочий</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pRepresent/УТ6:ДокументПодтверждающийПолномочия/УТ6:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>

			</table>
		</xsl:if>
	</xsl:template>

	<!-- Тип представителя УТ6 -->
	<xsl:template name="УТ6:RepresentativeType">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pType1Text" select="'законный представитель недееспособного лица'"/>
		<xsl:param name="pNoteStyle" select="'afItalic'"/>
		<xsl:if test="$pRepresent">
			<span> (<xsl:choose>
				<xsl:when test="$pRepresent/УТ6:Тип[text() = '1'] and count($pRepresent/УТ6:ЮридическоеЛицо) = 0"><span class="afUnderline"><xsl:value-of select="$pType1Text"/></span></xsl:when>
				<xsl:otherwise><xsl:value-of select="$pType1Text"/></xsl:otherwise>
				</xsl:choose>,&#160;<xsl:choose>
					<xsl:when test="count($pRepresent/УТ6:ЮридическоеЛицо) > 0"><span class="afUnderline">организация, на которую возложено исполнение обязанностей опекуна или попечителя</span></xsl:when>
					<xsl:otherwise>организация, на которую возложено исполнение обязанностей опекуна или попечителя</xsl:otherwise></xsl:choose>,&#160;<xsl:choose>
					<xsl:when test="$pRepresent/УТ6:Тип[text() = '2'] and count($pRepresent/УТ6:ЮридическоеЛицо) = 0"><span class="afUnderline">доверенное лицо</span></xsl:when>
					<xsl:otherwise>доверенное лицо</xsl:otherwise>
					</xsl:choose>) <span class="{$pNoteStyle}">(нужное подчеркнуть):</span></span>
		</xsl:if>
	</xsl:template>
	<xsl:template name="УТ6:CodDUP">
		<xsl:param name="pCod"/>
						<xsl:choose>
							<xsl:when test="$pCod = 1">Документ, выданный органом опеки и попечительства</xsl:when>
							<xsl:when test="$pCod = 2">Положение (устав) организации</xsl:when>
							<xsl:when test="$pCod = 3">Постановление администрации об установлении опекунства</xsl:when>
							<xsl:when test="$pCod = 4">Решение органа опеки и попечительства</xsl:when>
							<xsl:when test="$pCod = 5">Решение суда</xsl:when>
							<xsl:when test="$pCod = 6">Свидетельство о рождении</xsl:when>
							<xsl:when test="$pCod = 7">Свидетельство об установлении отцовства</xsl:when>
							<xsl:when test="$pCod = 8">Свидетельство об усыновлении (удочерении)</xsl:when>
							<xsl:when test="$pCod = 9">Удостоверение беженца</xsl:when>
							<xsl:when test="$pCod = 10">Удостоверение, выданное органом опеки и попечительства</xsl:when>
							<xsl:when test="$pCod = 11">Учредительные документы организации</xsl:when>
							<xsl:when test="$pCod = 19">Документ исправительного учреждения о нахождении (пребывании) осужденного к лишению свободы или принудительным работам в исправительном учреждении</xsl:when>
							<xsl:when test="$pCod = 20">Документ стационарной организации социального обслуживания о нахождении (пребывании) гражданина в этой организации</xsl:when>
							<xsl:when test="$pCod = 286">Нотариальная доверенность</xsl:when>
							<xsl:when test="$pCod = 513">Доверенность, выданная в порядке, установленном Гражданским кодексом Российской Федерации</xsl:when>
							<xsl:when test="$pCod = 630">Документ, удостоверяющий личность представителя гражданина Российской Федерации</xsl:when>
							<xsl:when test="$pCod = 632">Документ, подтверждающий полномочия представителя</xsl:when>
							<xsl:when test="$pCod = 710">Доверенность</xsl:when>
							<xsl:when test="$pCod = 887">Иной документ, подтверждающий полномочия представителя</xsl:when>
							<xsl:when test="$pCod = 964">Документ, подтверждающий полномочия уполномоченного представителя застрахованного лица</xsl:when>
							<xsl:when test="$pCod = 968">Документ, подтверждающий полномочия представителя страхователя</xsl:when>
							<xsl:when test="$pCod = 1133">Акт об отобрании ребенка</xsl:when>
							<xsl:when test="$pCod = 1134">Акт органа опеки и попечительства о временном назначении опекуна или попечителя (акт о предварительных опеке или попечительстве)</xsl:when>
							<xsl:when test="$pCod = 1135">Акт органа опеки и попечительства о назначении опекуна или попечителя</xsl:when>
							<xsl:when test="$pCod = 1136">Акт органа опеки и попечительства об объявлении дееспособным</xsl:when>
							<xsl:when test="$pCod = 1137">Акт органа опеки и попечительства об освобождении опекуна или попечителя от исполнения возложенных на них обязанностей либо об их отстранении от исполнения возложенных на них обязанностей</xsl:when>
							<xsl:when test="$pCod = 1138">Выписка из судебного решения</xsl:when>
							<xsl:when test="$pCod = 1139">Иной документ подтверждающий полномочия (прекращения полномочий) законного представителя</xsl:when>
							<xsl:when test="$pCod = 1140">Акт гражданского состояния ЕГР ЗАГС</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					
	</xsl:template>
	

</xsl:stylesheet>
