<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:АФ6="http://пф.рф/АФ/2023-01-10" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 АФ6" version="1.0">
           
    <xsl:template name="PrintSignature">
        <xsl:param name="pSignature"/>
        <xsl:choose>
            <xsl:when test="$pSignature">
                <xsl:variable name="dateStartText" select="$pSignature/АФ6:СрокДействия/АФ6:С"/>
                <xsl:variable name="dateEndText" select="$pSignature/АФ6:СрокДействия/АФ6:По"/> 
                <div class="afSignature">
                    <p>Документ подписан <br/>
                        усиленной квалифицированной электронной <br/>
                        подписью. </p>
                    
                    <xsl:if test="$pSignature/АФ6:ОсновноеНазвание">
                        Организация: <xsl:value-of select="$pSignature/АФ6:ОсновноеНазвание"/> <br/>    
                    </xsl:if>
                    Сертификат: <xsl:value-of select="$pSignature/АФ6:Идентификатор"/> <br/>
                    <xsl:if test="$pSignature/АФ6:Владелец">
						Кому выдан: <xsl:if test="$pSignature/АФ6:Владелец/УТ6:Фамилия">
							<xsl:value-of select="$pSignature/АФ6:Владелец/УТ6:Фамилия"/>&#160;</xsl:if>
						<xsl:if test="$pSignature/АФ6:Владелец/УТ6:Имя">
							<xsl:value-of select="$pSignature/АФ6:Владелец/УТ6:Имя"/>&#160;</xsl:if>
						<xsl:if test="$pSignature/АФ6:Владелец/УТ6:Отчество">
							<xsl:value-of select="$pSignature/АФ6:Владелец/УТ6:Отчество"/>
						</xsl:if> <br/>
                    </xsl:if>
                    Издатель: <xsl:value-of select="$pSignature/АФ6:Издатель"/> <br/>
                    Действителен: c <xsl:value-of select="concat(substring($dateStartText, 9, 2), '.', substring($dateStartText, 6, 2), '.', substring($dateStartText, 1, 4))"/> по <xsl:value-of select="concat(substring($dateEndText, 9, 2), '.', substring($dateEndText, 6, 2), '.', substring($dateEndText, 1, 4))"/>
                </div>
            </xsl:when>
             <xsl:otherwise>
                <div class="afSignature">
                    <p>Документ подписан <br/>
                        усиленной квалифицированной электронной <br/>
                        подписью. </p>
                    Организация: СФР <br/>
                    Сертификат: 5992945599368486741<br/>
                    Издатель: blastoff_ca_test<br/>
                    Действителен: с 22.09.2022 по 27.01.2032
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
