<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:УТ7="http://пф.рф/УТ/2023-04-03" xmlns:АФ7="http://пф.рф/АФ/2023-04-03" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ7 АФ7" version="1.0">
           
    <xsl:template name="PrintSignature">
        <xsl:param name="pSignature"/>            
        <xsl:choose>
            <xsl:when test="$pSignature">
                <xsl:variable name="dateStartText" select="$pSignature/АФ7:СрокДействия/АФ7:С"/>
                <xsl:variable name="dateEndText" select="$pSignature/АФ7:СрокДействия/АФ7:По"/> 
                <div class="afSignature">
                    <p>Документ подписан <br/>
                        усиленной квалифицированной электронной <br/>
                        подписью. </p>
                    
                    <xsl:if test="$pSignature/АФ7:ОсновноеНазвание">
                        Организация: <xsl:value-of select="$pSignature/АФ7:ОсновноеНазвание"/> <br/>    
                    </xsl:if>
                    Сертификат: <xsl:value-of select="$pSignature/АФ7:Идентификатор"/> <br/>
                    Кому выдан: <xsl:if test="$pSignature/АФ7:Владелец/УТ7:Фамилия">
                        <xsl:value-of select="$pSignature/АФ7:Владелец/УТ7:Фамилия"/>&#160;</xsl:if>
                    <xsl:if test="$pSignature/АФ7:Владелец/УТ7:Имя">
                        <xsl:value-of select="$pSignature/АФ7:Владелец/УТ7:Имя"/>&#160;</xsl:if>
                    <xsl:if test="$pSignature/АФ7:Владелец/УТ7:Отчество">
                        <xsl:value-of select="$pSignature/АФ7:Владелец/УТ7:Отчество"/>
                    </xsl:if> <br/>
                    Издатель: <xsl:value-of select="$pSignature/АФ7:Издатель"/> <br/>
                    Действителен: c <xsl:value-of select="concat(substring($dateStartText, 9, 2), '.', substring($dateStartText, 6, 2), '.', substring($dateStartText, 1, 4))"/> по <xsl:value-of select="concat(substring($dateEndText, 9, 2), '.', substring($dateEndText, 6, 2), '.', substring($dateEndText, 1, 4))"/>                
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="afSignature">
                    <p>Документ подписан <br/>
                        усиленной квалифицированной электронной <br/>
                        подписью. </p>
                    Организация: СФР <br/>
                    Сертификат: 00a9ad8c2b8b0b5d0601f153c8ce39976f<br/>
                    Издатель: Федеральное Казначейство<br/>
                    Действителен: с 31.10.2023 по 23.01.2025
                </div>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
</xsl:stylesheet>